<?php
// admin_login.php
session_start();
require '../../config.php'; // mysqli $conn + BASE_URL available

// Ensure utf8mb4 + required collation (no PDO)
if (isset($conn) && $conn instanceof mysqli) {
  mysqli_set_charset($conn, 'utf8mb4');
  @mysqli_query($conn, "SET collation_connection='utf8mb4_general_ci'");
}

// Security headers
header('X-Frame-Options: DENY');
header('X-Content-Type-Options: nosniff');
header('Referrer-Policy: no-referrer-when-downgrade');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

// CSRF token
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    $error = "Invalid session. Please refresh.";
  } else {
    $username = mysqli_real_escape_string($conn, trim($_POST['username'] ?? ''));
    $password = $_POST['password'] ?? '';
    if ($username !== '' && $password !== '') {
      $res = mysqli_query($conn, "SELECT username,password FROM admins WHERE username='{$username}' LIMIT 1");
      if ($res && mysqli_num_rows($res) === 1) {
        $row = mysqli_fetch_assoc($res);
        if (password_verify($password, $row['password'])) {
          $_SESSION['admin'] = true;
          $_SESSION['username'] = $row['username'];
          $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
          header("Location: ../applications-in-progress");
          exit;
        }
      }
      $error = "Invalid credentials.";
    } else {
      $error = "Please enter both username and password.";
    }
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Investors Clinic | Admin Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="icon" type="image/png" href="<?= htmlspecialchars(BASE_URL) ?>assets/img/ku-logo.png">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
<style>
  :root{
    --ink:#0b1220;
    --ink-2:#162338;
    --muted:#485c77;
    --ring-1:#5ec6ff;   /* sky start */
    --ring-2:#6f8cff;   /* indigo */
    --ring-3:#7a5cff;   /* violet */
    --ring-4:#33d1b5;   /* teal */
    --stroke:rgba(15,23,42,.10);
    --card-bg:#ffffff;
    --input-stroke:#d9e2f1;
  }

  *{box-sizing:border-box}
  html,body{height:100%}

  /* CRISP, NO BLUR */
  html, body{
    margin:0;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    text-rendering: optimizeLegibility;
    font-family:'Inter',system-ui,-apple-system,Segoe UI,Roboto,"Helvetica Neue",Arial;
    color:var(--ink);
    background:#8fd4ff; /* fallback */
  }

  /* MODERN, RICH (but light) ANIMATED GRADIENT
     Starts from sky blue and shifts across modern hues */
  body::before{
    content:"";
    position:fixed; inset:0; z-index:-2;
    background: linear-gradient(135deg,
      #7ccfff 0%,
      #5ec6ff 18%,
      #7aa7ff 38%,
      #9b8bff 55%,
      #6ee7d6 75%,
      #7ccfff 100%
    );
    background-size: 260% 260%;
    animation: gradientShift 16s ease-in-out infinite;
  }
  @keyframes gradientShift{
    0%   {background-position: 0% 50%}
    50%  {background-position: 100% 50%}
    100% {background-position: 0% 50%}
  }

  /* gentle spotlight so the center is brighter, edges cooler */
  body::after{
    content:"";
    position:fixed; inset:0; z-index:-1; pointer-events:none;
    background:
      radial-gradient(60rem 40rem at 50% 38%, rgba(255,255,255,.35), transparent 60%),
      radial-gradient(50rem 30rem at 90% -10%, rgba(255,255,255,.18), transparent 70%);
  }

  .wrap{min-height:100%; display:grid; place-items:center; padding:28px}

  /* BRAND (no link / no redirect) */
  .brand{
    position:fixed; left:20px; top:18px; z-index:5; user-select:none;
    display:flex; flex-direction:column; gap:2px; line-height:1.15;
    color:#061021; text-shadow:0 1px 0 rgba(255,255,255,.5);
    font-weight:800; letter-spacing:.2px;
  }
  .brand small{color:#0a1b36cc; font-weight:700}

  /* MODERN CARD WITH GRADIENT RING + MATCHED CONTRAST */
  .card-ring{
    width:min(94vw,480px);
    border-radius:22px;
    padding:2px;              /* ring thickness */
    background:
      linear-gradient(140deg, var(--ring-1), var(--ring-2) 33%, var(--ring-3) 66%, var(--ring-4));
    box-shadow:
      0 20px 60px rgba(0,0,0,.12),
      0 10px 30px rgba(94,198,255,.25);
  }
  .card-modern{
    border-radius:20px;
    background: var(--card-bg);
    padding:28px 26px;
    border:1px solid #eef2fa;
    box-shadow:
      0 1px 0 rgba(255,255,255,.9) inset,
      0 0 0 1px rgba(255,255,255,.8) inset,
      0 12px 36px rgba(14, 22, 42, .06);
  }

  .ku-badge{
    display:inline-flex; align-items:center; gap:10px;
    padding:10px 14px; border-radius:14px;
    background:#f2f7ff; border:1px solid #e3edff; color:#0b1a33; font-weight:700;
  }
  .secure-pill{
    display:inline-block; padding:8px 10px; border-radius:999px;
    background:#f4fbff; border:1px solid #d6f1ff; color:#0b1a33; font-weight:600; font-size:.85rem;
  }

  h1{font-size:24px; font-weight:800; margin:14px 0 6px;}
  .sub{color:var(--muted); font-weight:500; font-size:14px; margin-bottom:18px}

  .form-label{font-weight:600; color:var(--ink-2)}
  .form-control{
    background:#fff;
    border:1px solid var(--input-stroke);
    color:#0f172a;
    height:48px;
    border-radius:12px;
    transition: box-shadow .15s ease, border-color .15s ease, transform .12s ease;
  }
  .form-control:focus{
    border-color:#a8c8ff;
    box-shadow:0 0 0 4px rgba(94,198,255,.18);
    outline:none;
  }
  .form-control::placeholder{color:#96a6bf}

  .btn-brand{
    border:0;
    border-radius:14px;
    font-weight:800; letter-spacing:.2px;
    height:48px; padding:0 22px;
    color:#09162c;
    background:linear-gradient(135deg, #e9f3ff, #dfe8ff 50%, #eafaff);
    box-shadow:
      0 10px 30px rgba(94,198,255,.28),
      0 6px 18px rgba(122,92,255,.18);
    transition: transform .12s ease, box-shadow .15s ease;
  }
  .btn-brand:hover{ transform: translateY(-1px); box-shadow:0 16px 42px rgba(94,198,255,.34), 0 8px 20px rgba(122,92,255,.22); }

  .btn-back{
    border:1px solid #e7eef9;
    background:#ffffff;
    border-radius:12px;
    font-weight:600; color:#14233c; height:40px; padding:0 14px;
  }
  .btn-back:hover{background:#f6fbff}

  .alert{
    border-radius:14px; padding:.65rem .9rem;
    border:1px solid #ffd3db;
    background: linear-gradient(180deg,#fff4f6,#fffafb);
    color:#860018;
  }

  .helper{ margin-top:14px; color:var(--muted); font-size:12.5px; }
  .helper .nolink{ font-weight:600; color:#0f172a; }

  .corner{ position:fixed; right:12px; bottom:10px; color:#0f172a99; font-size:12px; }

  /* Mobile */
  @media (max-width:520px){
    .brand{left:14px; top:12px}
    .card-ring{width:100%}
    .card-modern{padding:22px 18px}
  }
</style>
</head>
<body>
<div class="wrap">
  <!-- Brand (no redirect) -->
  <div class="brand" aria-label="Investors Clinic HR Admin">
    <div>Investors Clinic</div>
    <small>HR Admin</small>
  </div>

  <!-- Modern gradient-ring card -->
  <div class="card-ring">
    <div class="card-modern">
      <div class="d-flex align-items-center justify-content-between mb-2">
        <div class="ku-badge">HR Administrator</div>
        <span class="secure-pill">Secure Access</span>
      </div>

      <h1>Sign In</h1>
      <div class="sub">Use your Investors Clinic admin credentials to continue.</div>

      <?php if(!empty($error)): ?>
        <div class="alert mb-3"><?= htmlspecialchars($error) ?></div>
      <?php endif; ?>

      <form method="POST" autocomplete="off" novalidate>
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token']) ?>">
        <div class="mb-3">
          <label class="form-label" for="username">Username</label>
          <input id="username" name="username" type="text" class="form-control" required autofocus placeholder="Enter your username">
        </div>
        <div class="mb-2">
          <label class="form-label" for="password">Password</label>
          <input id="password" name="password" type="password" class="form-control" required placeholder="Enter your password">
        </div>

        <div class="d-flex justify-content-between align-items-center mt-3 gap-2">
          <button type="button" class="btn btn-back" onclick="location.href='<?= htmlspecialchars(BASE_URL) ?>employee/employee-app/'">← Back</button>
          <button type="submit" class="btn btn-brand px-4">Sign In</button>
        </div>

 
      </form>
    </div>
  </div>
</div>

<div class="corner">© <?= date('Y') ?> IC — Admin Portal</div>

<script>
  // Submit on Enter in password
  (function(){
    const pwd = document.getElementById('password');
    if(pwd){ pwd.addEventListener('keydown', e => { if(e.key === 'Enter'){ e.target.form.submit(); } }); }
  })();
</script>
</body>
</html>
