<?php
require '../../config.php';

if (!isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$errors = [];
$success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $first_name = trim($_POST['first_name'] ?? '');
  $last_name = trim($_POST['last_name'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $old_password = $_POST['old_password'] ?? '';
  $new_password = $_POST['new_password'] ?? '';
  $confirm_password = $_POST['confirm_password'] ?? '';

  if ($first_name === '') $errors[] = "First name is required.";
  if ($last_name === '') $errors[] = "Last name is required.";
  if ($phone === '') $errors[] = "Phone number is required.";

  $changePassword = false;
  if (!empty($old_password) || !empty($new_password) || !empty($confirm_password)) {
    if (empty($old_password) || empty($new_password) || empty($confirm_password)) {
      $errors[] = "All password fields are required.";
    } elseif (!password_verify($old_password, $admin['password'])) {
      $errors[] = "Old password is incorrect.";
    } elseif ($new_password !== $confirm_password) {
      $errors[] = "New passwords do not match.";
    } else {
      $changePassword = true;
    }
  }

  if (empty($errors)) {
    // Update name, phone
    $stmt = mysqli_prepare($conn, "UPDATE admins SET first_name=?, last_name=?, phone=?" . ($changePassword ? ", password=?" : "") . " WHERE username=?");

    if ($changePassword) {
      $hashedPassword = password_hash($new_password, PASSWORD_BCRYPT);
      mysqli_stmt_bind_param($stmt, 'sssss', $first_name, $last_name, $phone, $hashedPassword, $username);
    } else {
      mysqli_stmt_bind_param($stmt, 'ssss', $first_name, $last_name, $phone, $username);
    }

    if (mysqli_stmt_execute($stmt)) {
      $success = $changePassword ? "Profile and password updated successfully." : "Profile updated successfully.";
    } else {
      $errors[] = "Error updating profile.";
    }
    mysqli_stmt_close($stmt);

    $admin = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM admins WHERE username='$username'"));
  }
}
?>

<!-- Header -->
<div class="app-topstrip bg-dark py-1 px-4 w-100 d-flex align-items-center justify-content-between">
  <div class="d-flex align-items-center gap-3">
    <a class="nav-link sidebartoggler d-block d-xl-none text-white" id="headerCollapse" href="javascript:void(0)">
      <i class="ti ti-menu-2 fs-4"></i>
    </a>
    <a class="d-flex justify-content-center" href="#" target="_blank" 
      style="background: white; display: inline-block; width: 70px; height: auto;">
      <img src="<?= BASE_URL ?>assets/images/logos/logo.png" alt="Logo" width="65" height="60x">
    </a>
  </div>

  <div class="d-flex align-items-center gap-3">
    <div class="dropdown">
      <a class="all-access-pass-btn rounded btn btn-primary d-flex align-items-center justify-content-center gap-2 fs-4 border-0 text-black px-3 py-2 dropdown-toggle" href="#" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
        Profile
      </a>
      <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
        <li>
          <a class="dropdown-item d-flex align-items-center gap-3" href="#">
            <img src="<?= BASE_URL ?>assets/images/profile/user-1.jpg" width="40" height="40" class="rounded-circle border">
            <div>
              <div class="fw-semibold"><?= htmlspecialchars(($admin['first_name'] ?? '') . ' ' . ($admin['last_name'] ?? '')) ?></div>
              <div class="small text-muted"><?= htmlspecialchars($admin['username'] ?? 'No username') ?></div>
            </div>
          </a>
        </li>
        <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editProfileModal">Account</a></li>
        <li><hr class="dropdown-divider"></li>
        <li><a class="dropdown-item" href="<?= BASE_URL ?>admin/logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="editProfileModal" tabindex="-1" aria-labelledby="editProfileModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <form method="POST">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title" id="editProfileModalLabel">Edit Profile</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
          <?php endif; ?>
          <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
              <?php foreach ($errors as $error): echo htmlspecialchars($error) . "<br>"; endforeach; ?>
            </div>
          <?php endif; ?>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">First Name</label>
              <input type="text" class="form-control" name="first_name" value="<?= htmlspecialchars($admin['first_name']) ?>" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Last Name</label>
              <input type="text" class="form-control" name="last_name" value="<?= htmlspecialchars($admin['last_name']) ?>" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Phone</label>
              <input type="text" class="form-control" name="phone" value="<?= htmlspecialchars($admin['phone']) ?>" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Username (readonly)</label>
              <input type="text" class="form-control" value="<?= htmlspecialchars($admin['username']) ?>" readonly>
            </div>
            <div class="col-md-6">
              <label class="form-label">Old Password</label>
              <input type="password" class="form-control" name="old_password">
            </div>
            <div class="col-md-6">
              <label class="form-label">New Password</label>
              <input type="password" class="form-control" name="new_password">
            </div>
            <div class="col-md-6">
              <label class="form-label">Confirm New Password</label>
              <input type="password" class="form-control" name="confirm_password">
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Update Profile</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Auto-open modal on submit (optional) -->
<?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
<script>
  const profileModal = new bootstrap.Modal(document.getElementById('editProfileModal'));
  profileModal.show();
</script>
<?php endif; ?>
