<?php
require '../../config.php';
$uriParts = explode('/', trim($_SERVER['REQUEST_URI'], '/'));
$current_file = end($uriParts);
?>
<style>
  .left-sidebar .btn#sidebarCloseBtn {
    position: absolute;
    top: 10px;
    right: 10px;
    cursor: pointer;
    z-index: 1051;
  }
</style>

<aside class="left-sidebar bg-white">
  <div class="brand-logo p-3">
    <a href="<?= BASE_URL ?>admin/dashboard" class="d-flex flex-column align-items-center text-decoration-none">
      <span class="fs-6 fw-bold text-body">Welcome</span>
      <span class="fs-4 text-body">
        <?= isset($_SESSION['admin_username']) ? htmlspecialchars($_SESSION['admin_username']) : 'Admin' ?>
      </span>
    </a>
    <button id="sidebarCloseBtn" class="btn btn-sm btn-light d-xl-none" style="font-size: 1.5rem; line-height:1; border:none; background:transparent; color:#333;">
      &times;
    </button>
  </div>

  <nav class="sidebar-nav scroll-sidebar" data-simplebar>
    <ul id="sidebarnav">

      <li class="sidebar-item">
        <a class="sidebar-link d-flex align-items-center py-2 px-3 <?= $current_file === 'dashboard' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/dashboard">
          <iconify-icon icon="solar:atom-line-duotone" class="me-2 fs-5"></iconify-icon>
          <span>Dashboard</span>
        </a>
      </li>
      <li class="sidebar-item">
        <a class="sidebar-link d-flex align-items-center py-2 px-3 <?= $current_file === 'submitted-applications' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/submitted-applications">
          <iconify-icon icon="mdi:file-document-outline" class="me-2 fs-5"></iconify-icon>
          <span>Submitted Applications</span>
        </a>
      </li>
	  <li class="sidebar-item">
        <a class="sidebar-link d-flex align-items-center py-2 px-3 <?= $current_file === 'in-progress-applications' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/in-progress-applications">
          <iconify-icon icon="mdi:file-document-outline" class="me-2 fs-5"></iconify-icon>
		  <span>In Progress Applications</span>
        </a>
      </li>
	  <li class="sidebar-item">
        <a class="sidebar-link d-flex align-items-center py-2 px-3 <?= $current_file === 'employee_applications' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/employee_applications">
		  <iconify-icon icon="mdi:file-document-outline" class="me-2 fs-5"></iconify-icon>
          <span>All Applications</span>
        </a>
      </li>
	  
	  
      <li class="sidebar-item">
        <a class="sidebar-link d-flex align-items-center py-2 px-3" href="<?= BASE_URL ?>admin/logout.php">
          <iconify-icon icon="mdi:logout" class="me-2 fs-5"></iconify-icon>
            <span>Logout</span>
        </a>
      </li>

    </ul>
  </nav>
</aside>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    const pageWrapper = document.querySelector('.page-wrapper');
    const closeBtn = document.getElementById('sidebarCloseBtn');

    closeBtn?.addEventListener('click', function () {
      if (pageWrapper.classList.contains('show-sidebar')) {
        pageWrapper.classList.remove('show-sidebar');
        pageWrapper.classList.add('mini-sidebar');
      }
    });
  });
</script>
