<?php
require '../../config.php';
$adminName    = isset($_SESSION['admin_username']) && $_SESSION['admin_username'] !== '' ? $_SESSION['admin_username'] : 'Admin';
$adminInitial = strtoupper(mb_substr($adminName, 0, 1));

$uriParts = explode('/', trim($_SERVER['REQUEST_URI'], '/'));
$current_file = end($uriParts);
?>
<aside class="left-sidebar">
  <div>
    <div class="brand-logo d-flex align-items-center justify-content-between px-3 py-2">
      <a href="<?= BASE_URL ?>admin/dashboard" class="text-nowrap logo-img d-flex align-items-center gap-2 text-decoration-none">
        <span class="badge bg-primary text-white fw-semibold"><?= htmlspecialchars($adminInitial) ?></span>
        <span class="fw-semibold text-dark text-truncate">Welcome, <?= htmlspecialchars($adminName) ?></span>
      </a>
 

      <!-- Mobile close (kept from template) -->
      <div class="close-btn d-xl-none d-block sidebartoggler cursor-pointer ms-2" id="sidebarCollapse">
        <i class="ti ti-x fs-8"></i>
      </div>
    </div>

    <!-- Sidebar navigation (WrapPixel structure) -->
    <nav class="sidebar-nav scroll-sidebar" data-simplebar="">
      <ul id="sidebarnav" class="text-dark">
        <li class="nav-small-cap">
          <iconify-icon icon="solar:menu-dots-linear" class="nav-small-cap-icon fs-4"></iconify-icon>
          <span class="hide-menu text-dark">Menu</span>
        </li>

        <li class="sidebar-item">
          <a class="sidebar-link text-dark gap-2 <?= $current_file === 'dashboard' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/dashboard" aria-expanded="false">
            <iconify-icon icon="solar:atom-line-duotone"></iconify-icon>
            <span class="hide-menu text-dark">Dashboard</span>
          </a>
        </li>
		
		<!--<li class="sidebar-item">
          <a class="sidebar-link text-dark gap-2 </?= $current_file === 'applications-all' ? 'active' : '' ?>" href="</?= BASE_URL ?>admin/applications-all" aria-expanded="false">
            <iconify-icon icon="mdi:file-document-outline"></iconify-icon>
            <span class="hide-menu text-dark">Applications</span>
          </a>
        </li> -->

		<!-- Applications group -->
      <li class="sidebar-item">
        <a class="sidebar-link justify-content-between text-dark" href="javascript:void(0)" aria-expanded="<?= in_array($current_file, ['pif-pending']) ? 'true' : 'false' ?>" data-bs-toggle="collapse" data-bs-target="#preApplicationsMenu" aria-controls="preApplicationsMenu">
          <div class="d-flex align-items-center gap-2">
            <iconify-icon icon="mdi:file-document-outline"></iconify-icon>
            <span class="hide-menu text-dark">Pre Applications</span>
          </div>
        </a>
        <ul id="preApplicationsMenu" class="collapse first-level <?= in_array($current_file, ['pif-pending']) ? 'show' : '' ?>" aria-expanded="<?= in_array($current_file, ['pif-pending']) ? 'true' : 'false' ?>">
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'pif-pending' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/pif-pending">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">PIF Pending</span>
              </div>
            </a>
          </li>
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'pif-rejected' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/pif-rejected">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">PIF Rejected</span>
              </div>
            </a>
          </li>
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'pif-approved' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/pif-approved">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">PIF Approved</span>
              </div>
            </a>
          </li>
        </ul>
      </li>

      <li class="sidebar-item">
        <a class="sidebar-link justify-content-between text-dark" href="javascript:void(0)" aria-expanded="<?= in_array($current_file, ['applications-submitted', 'applications-in-progress', 'applications-approved', 'applications-rejected', 'employees-no-application']) ? 'true' : 'false' ?>" data-bs-toggle="collapse" data-bs-target="#onboardingApplicationsMenu" aria-controls="onboardingApplicationsMenu">
          <div class="d-flex align-items-center gap-2">
            <iconify-icon icon="mdi:file-document-outline"></iconify-icon>
            <span class="hide-menu text-dark">Onboarding</span>
          </div>
        </a>
        <ul id="onboardingApplicationsMenu" class="collapse first-level <?= in_array($current_file, ['applications-submitted', 'applications-in-progress', 'applications-approved', 'applications-rejected', 'employees-no-application']) ? 'show' : '' ?>" aria-expanded="<?= in_array($current_file, ['applications-submitted', 'applications-in-progress', 'applications-approved', 'applications-rejected', 'employees-no-application']) ? 'true' : 'false' ?>">
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'applications-submitted' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/applications-submitted">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">Submitted Applications</span>
              </div>
            </a>
          </li>
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'applications-in-progress' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/applications-in-progress">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">In Progress Applications</span>
              </div>
            </a>
          </li>
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'applications-approved' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/applications-approved">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">Approved Applications</span>
              </div>
            </a>
          </li>
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'applications-rejected' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/applications-rejected">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">Rejected Applications</span>
              </div>
            </a>
          </li>
          <li class="sidebar-item">
            <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'employees-no-application' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/employees-no-application">
              <div class="d-flex align-items-center gap-2">
                <span class="d-flex"><span class="icon-small"></span></span>
                <span class="hide-menu text-dark">Employees No Application</span>
              </div>
            </a>
          </li>
        </ul>
      </li>
		
		<!-- Payment group -->
        <!-- <li class="sidebar-item">
          <a class="sidebar-link justify-content-between text-dark" href="javascript:void(0)" aria-expanded="true">
            <div class="d-flex align-items-center gap-2">
                <iconify-icon icon="mdi:file-document-outline"></iconify-icon>
              <span class="hide-menu text-dark">Payment</span>
            </div>
          </a>
          <ul aria-expanded="true" class="collapse first-level show">
            <li class="sidebar-item">
              <a class="sidebar-link justify-content-between text-dark <?= $current_file === 'payment-seat-booking' ? 'active' : '' ?>" href="<?= BASE_URL ?>admin/payment-seat-booking">
                <div class="d-flex align-items-center gap-2">
                  <span class="d-flex"><span class="icon-small"></span></span>
                  <span class="hide-menu text-dark">Seat Booking</span>
                </div>
              </a>
            </li>
            <li class="sidebar-item">
              <a class="sidebar-link justify-content-between text-dark" href="<?= BASE_URL ?>admin/payment-visa">
                <div class="d-flex align-items-center gap-2">
                  <span class="d-flex"><span class="icon-small"></span></span>
                  <span class="hide-menu text-dark">Visa Payment</span>
                </div>
              </a>
            </li>
          </ul>
        </li> -->
		
        <!-- Account group -->
        <li class="sidebar-item">
          <!--<a class="sidebar-link justify-content-between text-dark" href="javascript:void(0)" aria-expanded="true">-->
          <!--  <div class="d-flex align-items-center gap-2">-->
          <!--      <iconify-icon icon="mdi:account-circle-outline"></iconify-icon>-->
          <!--    <span class="hide-menu text-dark">Account</span>-->
          <!--  </div>-->
          <!--</a>-->
          <ul aria-expanded="true" class="collapse first-level show">
            <li class="sidebar-item">
              <a class="sidebar-link justify-content-between text-dark" href="<?= BASE_URL ?>admin/logout.php">
                <div class="d-flex align-items-center gap-2">
                  <span class="d-flex"><span class="icon-small"></span></span>
                  <span class="hide-menu text-dark">Logout</span>
                </div>
              </a>
            </li>
          </ul>
        </li>

        <!-- Add other items as needed -->
      </ul>
      <!-- NOTE: The "Quick Actions" card was removed per request -->
    </nav>
    <!-- End Sidebar navigation -->
	<!-- Theme (BG/Text) — kept; you can delete this block if not needed -->
    <div class="px-3 pb-2">
      <div class="row g-2 align-items-center">
        <div class="col-6">
          <label class="form-label small mb-1" for="sbBg">BG</label>
          <input type="color" id="sbBg" class="form-control form-control-color w-100" value="#ffffff" title="Sidebar background">
        </div>
        <div class="col-6">
          <label class="form-label small mb-1" for="sbTxt">Text</label>
          <input type="color" id="sbTxt" class="form-control form-control-color w-100" value="#212529" title="Sidebar text color">
        </div>
      </div>
    </div>
	
  </div>
</aside>

<script>
// Run AFTER WrapPixel's sidebarmenu/app scripts so we don't fight them
window.addEventListener('load', function () {
  // ---------- High contrast (keep text readable) ----------
  document.querySelectorAll('.left-sidebar .sidebar-link, .left-sidebar .hide-menu, .left-sidebar .nav-small-cap')
    .forEach(el => { el.classList.add('text-dark', 'fw-semibold'); });

  // ---------- Collapse/Expand (mini) toggle ----------
  const WRAP  = document.getElementById('main-wrapper');
  const BTN   = document.getElementById('btnSidebarMini');
  const ICO   = document.getElementById('btnSidebarMiniIcon');
  const TXT   = document.getElementById('btnSidebarMiniText');
  const MINI_KEY = 'wrap:mini';

  function applyMiniFromStorage() {
    try {
      if (localStorage.getItem(MINI_KEY) === '1') {
        WRAP && WRAP.classList.add('mini-sidebar');
        ICO && ICO.setAttribute('icon', 'mdi:chevron-double-right');
        TXT && (TXT.textContent = 'Expand');
      } else {
        WRAP && WRAP.classList.remove('mini-sidebar');
        ICO && ICO.setAttribute('icon', 'mdi:chevron-double-left');
        TXT && (TXT.textContent = 'Collapse');
      }
    } catch (e) {}
  }
  applyMiniFromStorage();

  BTN && BTN.addEventListener('click', function(){
    if (!WRAP) return;
    WRAP.classList.toggle('mini-sidebar');
    const isMini = WRAP.classList.contains('mini-sidebar');
    ICO && ICO.setAttribute('icon', isMini ? 'mdi:chevron-double-right' : 'mdi:chevron-double-left');
    TXT && (TXT.textContent = isMini ? 'Expand' : 'Collapse');
    try { localStorage.setItem(MINI_KEY, isMini ? '1' : '0'); } catch(e){}
  });

  // ---------- Persist each section's expand/collapse ----------
  const groups = document.querySelectorAll('.left-sidebar .sidebar-item > a.has-arrow');
  groups.forEach((trigger, idx) => {
    const key = 'grp:' + (trigger.textContent.trim() || idx);
    const container = trigger.parentElement.querySelector('ul.first-level');
    if (!container) return;

    // restore
    try {
      const saved = localStorage.getItem(key);
      const open = saved === null ? true : saved === '1';
      trigger.setAttribute('aria-expanded', open ? 'true' : 'false');
      container.classList.toggle('show', open);
    } catch(e){}

    // listen after template toggles it
    trigger.addEventListener('click', () => {
      setTimeout(() => {
        const openNow = trigger.getAttribute('aria-expanded') === 'true' || container.classList.contains('show');
        try { localStorage.setItem(key, openNow ? '1' : '0'); } catch(e){}
      }, 250);
    });
  });

  // ---------- Theme (BG/Text) ----------
  const sidebar = document.querySelector('.left-sidebar');
  const bg = document.getElementById('sbBg');
  const tx = document.getElementById('sbTxt');
  const KBG='sb:bg', KTX='sb:txt';

  function applyTheme() {
    if (!sidebar) return;
    if (bg) sidebar.style.backgroundColor = bg.value || '';
    if (tx) {
      sidebar.style.color = tx.value || '';
      sidebar.querySelectorAll('.sidebar-link,.hide-menu,.nav-small-cap,iconify-icon').forEach(el => {
        el.style.color = tx.value || '';
      });
    }
  }

  try {
    const sbg = localStorage.getItem(KBG), stx = localStorage.getItem(KTX);
    if (sbg) bg.value = sbg;
    if (stx) tx.value = stx;
    applyTheme();
  } catch(e){}

  bg && bg.addEventListener('input', () => { applyTheme(); try{localStorage.setItem(KBG, bg.value);}catch(e){} });
  tx && tx.addEventListener('input', () => { applyTheme(); try{localStorage.setItem(KTX, tx.value);}catch(e){} });
});
</script>
