<?php
session_start();
require '../../config.php';

/* Charset + collation per your standard (no PDO) */
mysqli_set_charset($conn, 'utf8mb4');
@mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;

/* Fetch payment journey rows */
$q = mysqli_query($conn, "SELECT * FROM broriser_payment_journey ORDER BY COALESCE(updated_at, created_at) DESC");

/* Quick stats */
$total_q = mysqli_query($conn, "SELECT COUNT(*) c FROM broriser_payment_journey");
$total   = $total_q ? (int)mysqli_fetch_assoc($total_q)['c'] : 0;

$seat_done_q = mysqli_query($conn, "SELECT COUNT(*) c FROM broriser_payment_journey WHERE seat_booking_done=1");
$seat_done   = $seat_done_q ? (int)mysqli_fetch_assoc($seat_done_q)['c'] : 0;

$adm800_q = mysqli_query($conn, "SELECT COUNT(*) c FROM broriser_payment_journey WHERE adm_1800_done=1");
$adm800   = $adm800_q ? (int)mysqli_fetch_assoc($adm800_q)['c'] : 0;

$adm2500_q = mysqli_query($conn, "SELECT COUNT(*) c FROM broriser_payment_journey WHERE adm_2500_done=1");
$adm2500   = $adm2500_q ? (int)mysqli_fetch_assoc($adm2500_q)['c'] : 0;

$fy2500_q = mysqli_query($conn, "SELECT COUNT(*) c FROM broriser_payment_journey WHERE first_year_2500_done=1");
$fy2500   = $fy2500_q ? (int)mysqli_fetch_assoc($fy2500_q)['c'] : 0;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>broriser Payment Journey</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
  <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-primary)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:260px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .chip{display:inline-flex;align-items:center;gap:.5rem;border:1px solid var(--bs-border-color);padding:.35rem .65rem;border-radius:999px;background:#fff}
    .btn-icon{display:inline-flex;align-items:center;gap:.4rem}
    .pill-paid{background:rgba(25,135,84,.12);color:#198754;border:1px solid rgba(25,135,84,.35);border-radius:999px;padding:.15rem .5rem;font-size:.75rem;white-space:nowrap}
    .pill-unpaid{background:rgba(220,53,69,.08);color:#dc3545;border:1px solid rgba(220,53,69,.3);border-radius:999px;padding:.15rem .5rem;font-size:.75rem;white-space:nowrap}
    .proof-link{display:inline-block;margin-left:.35rem;font-size:.75rem}
    @media (max-width: 575.98px){
      .toolbar{flex-direction:column;align-items:stretch}
      .search-wrap{min-width:100%}
      .table thead th{font-size:.85rem}
    }
    @media print {
      .no-print{display:none!important}
      table{font-size:12px}
      .table thead th{background:#000!important;color:#fff!important}
    }
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php include __DIR__ . '/../partials/header.php'; include __DIR__ . '/../partials/sidebar.php'; ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">

        <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
          <div class="page-title">
            <span class="dot"></span>
            <div>
              <h2 class="mb-0">broriser Payment Journey</h2>
              <div class="text-muted small">Track each applicant’s steps: Seat Booking, $1800, $2500, First-Year $2500</div>
            </div>
          </div>
          <div class="d-flex flex-wrap gap-2">
            <span class="chip"><i class="bi bi-collection"></i>Total: <strong><?= number_format($total) ?></strong></span>
            <span class="chip"><i class="bi bi-cash-coin"></i>Seat Booking: <strong><?= number_format($seat_done) ?></strong></span>
            <span class="chip"><i class="bi bi-cash-stack"></i>$1800: <strong><?= number_format($adm800) ?></strong></span>
            <span class="chip"><i class="bi bi-cash"></i>$2500: <strong><?= number_format($adm2500) ?></strong></span>
            <span class="chip"><i class="bi bi-bank"></i>First-Year $2500: <strong><?= number_format($fy2500) ?></strong></span>
          </div>
        </div>

        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="search-wrap">
                <i class="bi bi-search"></i>
                <input id="tableSearch" type="text" class="form-control" placeholder="Search name, email, phone...">
              </div>
              <div class="d-flex align-items-center gap-2">
                <label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto">
                  <option value="10">10</option><option value="25">25</option><option value="50">50</option><option value="500">500</option><option value="all">All</option>
                </select>
              </div>
              <div class="ms-auto d-flex flex-wrap gap-2 no-print">
                <div class="btn-group">
                  <button id="btnExportCSV" class="btn btn-outline-primary btn-icon"><i class="bi bi-filetype-csv"></i><span>CSV</span></button>
                  <button id="btnExportXLS" class="btn btn-outline-success btn-icon"><i class="bi bi-file-earmark-excel"></i><span>Excel</span></button>
                  <button id="btnExportPDF" class="btn btn-outline-danger btn-icon"><i class="bi bi-filetype-pdf"></i><span>PDF</span></button>
                </div>
                <button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button>
              </div>
            </div>

            <div class="table-responsive">
              <table id="journeyTable" class="table table-hover align-middle mb-3">
                <thead class="table-dark">
                  <tr>
                    <th style="width:56px">#</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Number</th>
                    <th style="width:180px">Applied Date</th>
                    <th style="width:160px">Seat Booking</th>
                    <th style="width:130px">$1800</th>
                    <th style="width:130px">$2500</th>
                    <th style="width:160px">First-Year $2500</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $i=1;
                  if ($q && mysqli_num_rows($q)>0):
                    while($row = mysqli_fetch_assoc($q)):
                      $applied = !empty($row['applied_date']) ? date('d M Y, h:i A', strtotime($row['applied_date'])) : '-';

                      $seatBadge  = $row['seat_booking_done'] ? '<span class="pill-paid">Paid</span>'   : '<span class="pill-unpaid">Unpaid</span>';
                      $sProof     = $row['seat_booking_proof'] ? '<a class="proof-link" href="'.htmlspecialchars($row['seat_booking_proof']).'" target="_blank">proof</a>' : '';

                      $p800Badge  = $row['adm_1800_done'] ? '<span class="pill-paid">Paid</span>'       : '<span class="pill-unpaid">Unpaid</span>';
                      $p800Proof  = $row['adm_1800_proof'] ? '<a class="proof-link" href="'.htmlspecialchars($row['adm_1800_proof']).'" target="_blank">proof</a>' : '';

                      $p25Badge   = $row['adm_2500_done'] ? '<span class="pill-paid">Paid</span>'      : '<span class="pill-unpaid">Unpaid</span>';
                      $p25Proof   = $row['adm_2500_proof'] ? '<a class="proof-link" href="'.htmlspecialchars($row['adm_2500_proof']).'" target="_blank">proof</a>' : '';

                      $fyBadge    = $row['first_year_2500_done'] ? '<span class="pill-paid">Paid</span>': '<span class="pill-unpaid">Unpaid</span>';
                      $fyProof    = $row['first_year_2500_proof'] ? '<a class="proof-link" href="'.htmlspecialchars($row['first_year_2500_proof']).'" target="_blank">proof</a>' : '';
                  ?>
                  <tr class="data-row">
                    <td class="text-muted"><?= $i++; ?></td>
                    <td class="fw-semibold"><?= htmlspecialchars($row['employee_name'] ?? '') ?></td>
                    <td><a class="text-decoration-none" href="mailto:<?= htmlspecialchars($row['email'] ?? '') ?>"><?= htmlspecialchars($row['email'] ?? '') ?></a></td>
                    <td><a class="text-decoration-none" href="tel:<?= htmlspecialchars($row['phone'] ?? '') ?>"><?= htmlspecialchars($row['phone'] ?? '') ?></a></td>
                    <td class="text-muted small"><?= $applied ?></td>
                    <td><?= $seatBadge . $sProof ?></td>
                    <td><?= $p800Badge . $p800Proof ?></td>
                    <td><?= $p25Badge . $p25Proof ?></td>
                    <td><?= $fyBadge . $fyProof ?></td>
                  </tr>
                  <?php endwhile; else: ?>
                  <tr><td colspan="9" class="text-center text-muted py-5">No records found.</td></tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

            <div class="d-flex flex-wrap align-items-center justify-content-between">
              <div class="small text-muted"><span id="rowsInfo">0</span> rows</div>
              <nav><ul class="pagination mb-0" id="pager"></ul></nav>
            </div>

          </div>
        </div>

      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <script>
    (function(){
      const table = document.getElementById('journeyTable');
      const tbody = table.querySelector('tbody');
      const search = document.getElementById('tableSearch');
      const rowsPerPageSel = document.getElementById('rowsPerPage');
      const pager = document.getElementById('pager');
      const rowsInfo = document.getElementById('rowsInfo');
      const refreshBtn = document.getElementById('btnRefresh');
      const btnCSV  = document.getElementById('btnExportCSV');
      const btnXLS  = document.getElementById('btnExportXLS');
      const btnPDF  = document.getElementById('btnExportPDF');

      let allRows = Array.from(tbody.querySelectorAll('tr.data-row'));
      let filtered = allRows.slice();
      let page = 1;
      let rpp = rowsPerPageSel.value;

      function normalize(s){ return (s||'').toString().toLowerCase().trim(); }

      function applyFilter(){
        const q = normalize(search.value);
        filtered = allRows.filter(tr=>{
          if(!q) return true;
          return normalize(tr.innerText).includes(q);
        });
        page = 1;
        render();
      }

      function render(){
        rpp = rowsPerPageSel.value;
        const perPage = (rpp==='all') ? filtered.length || 1 : parseInt(rpp,10);

        allRows.forEach(tr=>tr.style.display='none');

        const total = filtered.length;
        const totalPages = Math.max(1, Math.ceil(total / perPage));
        if(page>totalPages) page = totalPages;
        const start = (page-1)*perPage;
        const end   = (rpp==='all') ? total : Math.min(start+perPage, total);

        for(let i=start;i<end;i++){ filtered[i].style.display=''; }

        rowsInfo.textContent = total;

        pager.innerHTML = '';
        function addItem(txt, p, disabled=false, active=false){
          const li = document.createElement('li');
          li.className = 'page-item' + (disabled?' disabled':'') + (active?' active':'');
          const a = document.createElement('a');
          a.className = 'page-link';
          a.href = '#';
          a.textContent = txt;
          a.onclick = (e)=>{ e.preventDefault(); if(!disabled){ page = p; render(); } };
          li.appendChild(a);
          pager.appendChild(li);
        }
        addItem('«', 1, page===1);
        addItem('‹', Math.max(1,page-1), page===1);
        const windowSize = 5;
        let startP = Math.max(1, page - Math.floor(windowSize/2));
        let endP   = Math.min(totalPages, startP + windowSize - 1);
        startP = Math.max(1, Math.min(startP, endP - windowSize + 1));
        for(let p=startP;p<=endP;p++){ addItem(p, p, false, p===page); }
        addItem('›', Math.min(totalPages,page+1), page===totalPages);
        addItem('»', totalPages, page===totalPages);
      }

      search.addEventListener('input', applyFilter);
      rowsPerPageSel.addEventListener('change', function(){ page=1; render(); });
      refreshBtn.addEventListener('click', function(){ location.reload(); });

      /* Export CSV */
      btnCSV.addEventListener('click', function(){
        const headers = ['#','Name','Email','Number','Applied Date','Seat Booking','$1800','$2500','First-Year $2500'];
        const lines = [headers.join(',')];
        filtered.forEach(tr=>{
          const tds = Array.from(tr.querySelectorAll('td'));
          const vals = [0,1,2,3,4,5,6,7,8].map(i=> (tds[i] ? tds[i].innerText.replace(/\r?\n|\r/g,' ').trim() : '') );
          lines.push(vals.map(v=> `"${v.replace(/"/g,'""')}"`).join(','));
        });
        const blob = new Blob([lines.join('\n')], {type:'text/csv;charset=utf-8;'});
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href=url; a.download='broriser_payment_journey.csv';
        document.body.appendChild(a); a.click(); document.body.removeChild(a);
        URL.revokeObjectURL(url);
      });

      /* Export Excel */
      btnXLS.addEventListener('click', function(){
        let html = '<table><thead><tr><th>#</th><th>Name</th><th>Email</th><th>Number</th><th>Applied Date</th><th>Seat Booking</th><th>$1800</th><th>$2500</th><th>First-Year $2500</th></tr></thead><tbody>';
        filtered.forEach(tr=>{
          const tds = Array.from(tr.querySelectorAll('td'));
          html += '<tr>'+[0,1,2,3,4,5,6,7,8].map(i=>`<td>${(tds[i]?tds[i].innerText:'').replace(/\r?\n|\r/g,' ').trim()}</td>`).join('')+'</tr>';
        });
        html += '</tbody></table>';
        const blob = new Blob([html], {type:'application/vnd.ms-excel'});
        const url = URL.createObjectURL(blob);
        const a=document.createElement('a');
        a.href=url; a.download='broriser_payment_journey.xls';
        document.body.appendChild(a); a.click(); document.body.removeChild(a);
        URL.revokeObjectURL(url);
      });

      /* Export PDF (print) */
      btnPDF.addEventListener('click', function(){
        let head = '<html><head><title>broriser Payment Journey</title><style>body{font-family:system-ui,Segoe UI,Roboto,Arial,sans-serif;padding:16px}table{width:100%;border-collapse:collapse}th,td{border:1px solid #444;padding:8px;font-size:12px;text-align:left;vertical-align:top}thead th{background:#000;color:#fff}</style></head><body><h2>broriser Payment Journey</h2><table><thead><tr><th>#</th><th>Name</th><th>Email</th><th>Number</th><th>Applied Date</th><th>Seat Booking</th><th>$1800</th><th>$2500</th><th>First-Year $2500</th></tr></thead><tbody>';
        let body = '';
        filtered.forEach(tr=>{
          const tds = Array.from(tr.querySelectorAll('td'));
          body += '<tr>'+[0,1,2,3,4,5,6,7,8].map(i=>`<td>${(tds[i]?tds[i].innerText:'').replace(/\r?\n|\r/g,' ').trim()}</td>`).join('')+'</tr>';
        });
        let tail='</tbody></table></body></html>';
        const w=window.open('', '_blank'); w.document.write(head+body+tail); w.document.close(); w.focus(); w.print();
      });

      /* init */
      (function init(){ render(); })();
    })();
  </script>
</body>
</html>
