<?php
session_start();
require '../../config.php';
if (!isset($_SESSION['admin'], $_SESSION['username'])) {
    header("Location: " . BASE_URL . "admin/login");
    exit;
}
$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;
$applications_q = mysqli_query(
    $conn,
    "SELECT * FROM user_pif WHERE st1_status = 'Approved' ORDER BY created_at DESC"
);
function e($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Approved Applications</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
    <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-danger)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:260px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .chip{display:inline-flex;align-items:center;gap:.5rem;border:1px solid var(--bs-border-color);padding:.35rem .65rem;border-radius:999px;background:#fff}
    .chip .bi{opacity:.7}
    .btn-icon{display:inline-flex;align-items:center;gap:.4rem}
    .status-pill{border-radius:999px;padding:.25rem .65rem;font-size:.75rem;border:1px solid transparent}
    .status-submitted{background:rgba(25,135,84,.12);color:#198754;border-color:rgba(25,135,84,.35)}
    .status-progress{background:rgba(255,193,7,.12);color:#b58100;border-color:rgba(255,193,7,.35)}
    .status-approved{background:rgba(13,110,253,.12);color:#0d6efd;border-color:rgba(13,110,253,.35)}
    .status-rejected{background:rgba(220,53,69,.12);color:#dc3545;border-color:rgba(220,53,69,.35)}
    .status-other{background:rgba(108,117,125,.12);color:#6c757d;border-color:rgba(108,117,125,.3)}
    .avatar-initial{width:34px;height:34px;border-radius:50%;display:inline-grid;place-items:center;background:var(--bs-primary);color:#fff;font-weight:600}
    @media (max-width: 575.98px){ .toolbar{flex-direction:column;align-items:stretch} .search-wrap{min-width:100%} }
    @media print {.no-print{display:none!important} .table thead th{background:#000!important;color:#fff!important}}
  </style>
</head>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php include __DIR__ . '/../partials/header.php'; include __DIR__ . '/../partials/sidebar.php'; ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">
        <h2>All Approved Applications</h2>
        <p class="text-muted">View approved PIF applications</p>

        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="search-wrap">
                <i class="bi bi-search"></i>
                <input id="tableSearch" type="text" class="form-control" placeholder="Search name, email, country...">
              </div>
              <div class="d-flex align-items-center gap-2">
                <label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto">
                  <option value="10">10</option><option value="25">25</option><option value="50">50</option><option value="500">500</option><option value="all">All</option>
                </select>
              </div>
              <div class="ms-auto d-flex flex-wrap gap-2 no-print">
                <div class="btn-group">
                  <button id="btnExportCSV" class="btn btn-outline-primary btn-icon"><i class="bi bi-filetype-csv"></i><span>CSV</span></button>
                  <button id="btnExportXLS" class="btn btn-outline-success btn-icon"><i class="bi bi-file-earmark-excel"></i><span>Excel</span></button>
                  <button id="btnExportPDF" class="btn btn-outline-danger btn-icon"><i class="bi bi-filetype-pdf"></i><span>PDF</span></button>
                </div>
                <button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button>
              </div>
            </div>
            <div class="table-responsive">
              <table id="appsTable" class="table table-hover align-middle table-sm mb-0">
                <thead class="table-dark">
                  <tr class="small">
                    <th>PIF‑ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Contact</th>
                    <th>Applied For</th>
                    <th>Date</th>
                    <th>Status</th>
                  </tr>
                </thead>
                <tbody>
                  <?php if ($applications_q && mysqli_num_rows($applications_q) > 0): ?>
                      <?php while ($app = mysqli_fetch_assoc($applications_q)): ?>
                          <?php
                              $status = $app['st1_status'];
                              $badgeClass = match ($status) {
                                  'Approved' => 'success',
                                  'Rejected' => 'danger',
                                  default    => 'warning',
                              };
                          ?>
                          <tr>
                              <td><?= (int)$app['idpif']; ?></td>
                              <td><?= e($app['username']); ?></td>
                              <td><a href="mailto:<?= e($app['email']); ?>"><?= e($app['email']); ?></a></td>
                              <td><?= e($app['phone'] ?? $app['contact_no'] ?? ''); ?></td>
                              <td><?= e($app['appliedfor']); ?></td>
                              <td class="text-muted small"><?= !empty($app['created_at']) ? date('d M Y, h:i A', strtotime($app['created_at'])) : '-'; ?></td>
                              <td><span class="badge bg-<?= $badgeClass; ?>"><?= e($status); ?></span></td>
                          </tr>
                      <?php endwhile; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="7" class="text-center text-muted py-4">No applications found.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>

      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

  <script>
    document.getElementById('btnRefresh').addEventListener('click', () => location.reload());
  </script>
  <script>
(function () {
  const table = document.getElementById('appsTable');
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const searchInput = document.getElementById('tableSearch');
  const rowsPerPageInput = document.getElementById('rowsPerPage');

  let filteredRows = [...rows];
  let currentPage = 1;

  function normalize(str) {
    return (str || '').toString().toLowerCase().trim();
  }

  function paginateData() {
    const rowsPerPage = rowsPerPageInput.value === 'all'
      ? filteredRows.length
      : parseInt(rowsPerPageInput.value, 10);

    const totalRows = filteredRows.length;
    const totalPages = Math.ceil(totalRows / rowsPerPage);

    currentPage = Math.min(currentPage, totalPages);
    const start = (currentPage - 1) * rowsPerPage;
    const end = start + rowsPerPage;

    rows.forEach(row => (row.style.display = 'none'));
    filteredRows.slice(start, end).forEach(row => (row.style.display = ''));

    renderPagination(totalPages);
  }
  function renderPagination(totalPages) {
    const pager = document.getElementById('pager');
    if (!pager) return;
    pager.innerHTML = '';
    if (totalPages <= 1) return;

    for (let i = 1; i <= totalPages; i++) {
      const li = document.createElement('li');
      li.className = 'page-item' + (i === currentPage ? ' active' : '');
      const a = document.createElement('a');
      a.className = 'page-link';
      a.href = '#';
      a.textContent = i;
      a.addEventListener('click', (e) => {
        e.preventDefault();
        currentPage = i;
        paginateData();
      });
      li.appendChild(a);
      pager.appendChild(li);
    }
  }
  function applySearch() {
    const query = normalize(searchInput.value);
    filteredRows = rows.filter(row =>
      normalize(row.innerText).includes(query)
    );
    currentPage = 1;
    paginateData();
  }
  searchInput.addEventListener('input', applySearch);
  rowsPerPageInput.addEventListener('change', () => {
    currentPage = 1;
    paginateData();
  });
  document.getElementById('btnRefresh')?.addEventListener('click', () => {
    location.reload();
  });
  applySearch();
})();
</script>
</body>
</html>
