<?php
session_start();
require '../../config.php';

if (!isset($_SESSION['admin'], $_SESSION['username'])) {
    header("Location: " . BASE_URL . "admin/login");
    exit;
}

$username = mysqli_real_escape_string($conn, $_SESSION['username']);
$admin_q  = mysqli_query($conn, "SELECT * FROM admins WHERE username='{$username}' LIMIT 1");
$admin    = $admin_q ? mysqli_fetch_assoc($admin_q) : null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['approve_idpif'], $_POST['action'])) {
    $approveId = (int)$_POST['approve_idpif'];
    $action = $_POST['action'];
    $valid_actions = ['Approved', 'Rejected', 'Hold'];
    if (!in_array($action, $valid_actions)) {
        $_SESSION['flash_error'] = "Invalid action submitted.";
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }
    $check_q = mysqli_query($conn, "SELECT idpif FROM user_pif WHERE idpif = $approveId AND st1_status = 'Pending' LIMIT 1");
    if ($check_q && mysqli_num_rows($check_q) === 1) {
        mysqli_query($conn, "UPDATE user_pif SET st1_status = '$action', st1_date = CURDATE() WHERE idpif = $approveId LIMIT 1");
        $_SESSION['flash_success'] = "Application #$approveId marked as $action successfully.";
    } else {
        $_SESSION['flash_error'] = "Application not found or already processed.";
    }
    header("Location: " . $_SERVER['REQUEST_URI']);
    exit;
}

$applications_q = mysqli_query(
    $conn,
    "SELECT * FROM user_pif WHERE st1_status = 'Pending' ORDER BY created_at DESC"
);

function e($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Pending Applications</title>
  <?php include __DIR__ . '/../partials/head.php'; ?>
    <style>
    .page-title{display:flex;align-items:center;gap:.75rem}
    .page-title .dot{width:10px;height:10px;border-radius:50%;background:var(--bs-danger)}
    .card-soft{border:0;box-shadow:0 4px 18px rgba(0,0,0,.08);border-radius:1rem}
    .toolbar{display:flex;flex-wrap:wrap;gap:.75rem;align-items:center}
    .search-wrap{position:relative;min-width:260px}
    .search-wrap input{padding-left:2.25rem}
    .search-wrap .bi{position:absolute;left:.65rem;top:50%;transform:translateY(-50%);opacity:.6}
    .table thead th{position:sticky;top:0;background:var(--bs-dark);color:#fff;z-index:1}
    .table-hover tbody tr:hover{background:rgba(13,110,253,.04)}
    .chip{display:inline-flex;align-items:center;gap:.5rem;border:1px solid var(--bs-border-color);padding:.35rem .65rem;border-radius:999px;background:#fff}
    .chip .bi{opacity:.7}
    .btn-icon{display:inline-flex;align-items:center;gap:.4rem}
    .status-pill{border-radius:999px;padding:.25rem .65rem;font-size:.75rem;border:1px solid transparent}
    .status-submitted{background:rgba(25,135,84,.12);color:#198754;border-color:rgba(25,135,84,.35)}
    .status-progress{background:rgba(255,193,7,.12);color:#b58100;border-color:rgba(255,193,7,.35)}
    .status-approved{background:rgba(13,110,253,.12);color:#0d6efd;border-color:rgba(13,110,253,.35)}
    .status-rejected{background:rgba(220,53,69,.12);color:#dc3545;border-color:rgba(220,53,69,.35)}
    .status-other{background:rgba(108,117,125,.12);color:#6c757d;border-color:rgba(108,117,125,.3)}
    .avatar-initial{width:34px;height:34px;border-radius:50%;display:inline-grid;place-items:center;background:var(--bs-primary);color:#fff;font-weight:600}
    @media (max-width: 575.98px){ .toolbar{flex-direction:column;align-items:stretch} .search-wrap{min-width:100%} }
    @media print {.no-print{display:none!important} .table thead th{background:#000!important;color:#fff!important}}
  </style>
</head>
<body>
<body class="d-flex flex-column min-vh-100">
  <div class="page-wrapper d-flex flex-column flex-grow-1" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
    <?php include __DIR__ . '/../partials/header.php'; include __DIR__ . '/../partials/sidebar.php'; ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid py-4">
        <h2>Pending Applications</h2>
        <p class="text-muted">Review all Pending PIF applications</p>
        <div class="card card-soft">
          <div class="card-body">
            <div class="toolbar mb-3">
              <div class="search-wrap">
                <i class="bi bi-search"></i>
                <input id="tableSearch" type="text" class="form-control" placeholder="Search name, email, country...">
              </div>
              <div class="d-flex align-items-center gap-2">
                <label for="rowsPerPage" class="text-muted small mb-0">Rows:</label>
                <select id="rowsPerPage" class="form-select form-select-sm" style="width:auto">
                  <option value="10">10</option><option value="25">25</option><option value="50">50</option><option value="500">500</option><option value="all">All</option>
                </select>
              </div>
              <div class="ms-auto d-flex flex-wrap gap-2 no-print">
                <div class="btn-group">
                  <button id="btnExportCSV" class="btn btn-outline-primary btn-icon"><i class="bi bi-filetype-csv"></i><span>CSV</span></button>
                  <button id="btnExportXLS" class="btn btn-outline-success btn-icon"><i class="bi bi-file-earmark-excel"></i><span>Excel</span></button>
                  <button id="btnExportPDF" class="btn btn-outline-danger btn-icon"><i class="bi bi-filetype-pdf"></i><span>PDF</span></button>
                </div>
                <button id="btnRefresh" class="btn btn-light btn-icon"><i class="bi bi-arrow-clockwise"></i><span>Refresh</span></button>
              </div>
            </div>
            <div class="table-responsive">
              <table id="appsTable" class="table table-hover align-middle table-sm mb-3">
                <thead class="table-dark">
                  <tr class="small">
                    <th>PIF‑ID</th>
                    <th>Applicant Name</th>
                    <th>Contact No.</th>
                    <th>Email</th>
                    <th>Applied For</th>
                    <th>Apply Date</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                <?php if ($applications_q && mysqli_num_rows($applications_q) > 0): ?>
                    <?php while ($app = mysqli_fetch_assoc($applications_q)): ?>
                    <?php
                        $pifId      = (int)$app['idpif'];
                        $fullName   = e(trim($app['username']));
                        $contactNo  = e($app['phone'] ?? $app['contact_no'] ?? '');
                        $emailAddr  = e($app['email']);
                        $appliedFor = e($app['appliedfor']);
                        $applyDate  = !empty($app['created_at'])
                                    ? date('d M Y, h:i A', strtotime($app['created_at']))
                                    : '-';
                        $status     = $app['st1_status'];
                    ?>
                    <tr>
                        <td><?= $pifId; ?></td>
                        <td><?= $fullName; ?></td>
                        <td><?= $contactNo; ?></td>
                        <td><a href="mailto:<?= $emailAddr; ?>"><?= $emailAddr; ?></a></td>
                        <td><?= $appliedFor; ?></td>
                        <td class="text-muted small"><?= $applyDate; ?></td>
                        <td>
                        <?php if ($status === 'Pending'): ?>
                           <button
                                class="btn btn-sm btn-primary btn-preview"
                                data-id="<?= $pifId; ?>"
                                data-username="<?= e($app['username']); ?>"
                                data-phone="<?= e($app['phone']); ?>"
                                data-email="<?= e($app['email']); ?>"
                                data-appliedfor="<?= e($app['appliedfor']); ?>"
                                data-resume="<?= e($app['resume']); ?>"
                                data-qualification="<?= e($app['qualification']); ?>"
                                data-totalExp="<?= e($app['totalExp']); ?>"
                                data-lastorg="<?= e($app['lastorg']); ?>"
                                data-lastdesignation="<?= e($app['last_designation']); ?>"
                                data-current_salary="<?= e($app['current_salary']); ?>"
                                data-expected_salary="<?= e($app['expected_salary']); ?>"
                                data-notice_period="<?= e($app['notice_period']); ?>"
                                data-last_designation="<?= e($app['last_designation']); ?>"
                                data-jobType="<?= e($app['jobType']); ?>"
                                data-notice_period="<?= e($app['notice_period']); ?>"
                                data-reason="<?= e($app['reason']); ?>"
                                data-others="<?= e($app['others']); ?>"
                                data-lastOrgEmail="<?= e($app['lastOrgEmail']); ?>"
                                data-ref="<?= e($app['ref']); ?>"
                                data-refname="<?= e($app['refname']); ?>"
                                data-empl="<?= e($app['empl']); ?>"
                                data-earlier_team="<?= e($app['earlier_team']); ?>"
                                data-earlier_employment="<?= e($app['earlier_employment']); ?>"
                                data-earlier_position="<?= e($app['earlier_position']); ?>"
                                data-earlier_leaving="<?= e($app['earlier_leaving']); ?>"
                                data-gender="<?= e($app['gender']); ?>"
                                data-marital_status="<?= e($app['marital_status']); ?>"
                                data-dob="<?= e($app['dob']); ?>"
                                data-currentAddress="<?= e($app['currentAddress']); ?>"
                                data-currentCity="<?= e($app['currentCity']); ?>"
                                data-conveyance="<?= e($app['conveyance']); ?>"
                                data-bs-toggle="modal"
                                data-bs-target="#previewModal"
                            >
                                <i class="bi bi-eye"></i> Preview
                            </button>
                        <?php else: ?>
                            <span class="badge bg-success">Approved</span>
                        <?php endif; ?>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                      <td colspan="7" class="text-center text-muted py-4">No applications found.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php include __DIR__ . '/../partials/footer.php'; ?>
  </div>

        <div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Application Preview</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="previewModalBody">
                        <div class="text-center py-5">
                            <div class="spinner-border" role="status"></div>
                        </div>
                    </div>
                    <div class="modal-footer d-none" id="previewModalFooter">
                        <form id="pifActionForm" method="post" class="d-flex gap-2">
                            <input type="hidden" name="approve_idpif" id="approve_id_input">
                            <input type="hidden" name="action" id="pif_action_input">

                            <button type="submit" class="btn btn-success" onclick="setPifAction('Approved')">Approve</button>
                            <button type="submit" class="btn btn-danger" onclick="setPifAction('Rejected')">Reject</button>
                            <button type="submit" class="btn btn-warning text-dark" onclick="setPifAction('Hold')">Hold</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

  <script>
    function escapeHtml(text) {
        if (!text) return '';
        return text
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }

    document.querySelectorAll('.btn-preview').forEach(button => {
        button.addEventListener('click', () => {
            const modalBody = document.getElementById('previewModalBody');
            const modalFooter = document.getElementById('previewModalFooter');
            const approveInput = document.getElementById('approve_id_input');
            const BASE_URL = <?= json_encode(BASE_URL); ?>;

            const data = {
                id: button.dataset.id,
                resume: escapeHtml(button.dataset.resume),
                team_name: escapeHtml(button.dataset.team_name),
                appliedfor: escapeHtml(button.dataset.appliedfor),
                current_salary: escapeHtml(button.dataset.current_salary),
                expected_salary: escapeHtml(button.dataset.expected_salary),
                notice_period: escapeHtml(button.dataset.notice_period),
                qualification: escapeHtml(button.dataset.qualification),
                lastorg: escapeHtml(button.dataset.lastorg),
                last_designation: escapeHtml(button.dataset.last_designation),
                jobType: escapeHtml(button.dataset.jobtype),
                totalExp: escapeHtml(button.dataset.totalexp) || 'Not Available',
                reason: escapeHtml(button.dataset.reason),
                lastOrgEmail: escapeHtml(button.dataset.lastorgemail),
                know_about: escapeHtml(button.dataset.knowabout),
                others: escapeHtml(button.dataset.others),
                ref: escapeHtml(button.dataset.ref),
                refname: escapeHtml(button.dataset.refname),
                empl: escapeHtml(button.dataset.empl),
                earlier_team: escapeHtml(button.dataset.earlier_team),
                earlier_employment: escapeHtml(button.dataset.earlier_employment),
                earlier_position: escapeHtml(button.dataset.earlier_position),
                earlier_leaving: escapeHtml(button.dataset.earlier_leaving),
                username: escapeHtml(button.dataset.username),
                phone: escapeHtml(button.dataset.phone),
                email: escapeHtml(button.dataset.email),
                gender: escapeHtml(button.dataset.gender),
                marital_status: escapeHtml(button.dataset.marital_status),
                dob: escapeHtml(button.dataset.dob),
                currentAddress: escapeHtml(button.dataset.currentaddress),
                currentCity: escapeHtml(button.dataset.currentcity),
                conveyance: escapeHtml(button.dataset.conveyance),
            };

            modalBody.innerHTML = `
                <div class="row">
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>PIF ID:</strong></h6>
                        <p>${data.id}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Applied For:</strong></h6>
                        <p>${data.appliedfor}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Username:</strong></h6>
                        <p>${data.username}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Phone:</strong></h6>
                        <p>${data.phone}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Email:</strong></h6>
                        <p><a href="mailto:${data.email}">${data.email}</a></p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Gender:</strong></h6>
                        <p>${data.gender}</p>
                    </div>

                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Marital Status:</strong></h6>
                        <p>${data.marital_status}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Current Salary:</strong></h6>
                        <p>${data.current_salary}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Expected Salary:</strong></h6>
                        <p>${data.expected_salary}</p>
                    </div>

                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Notice Period:</strong></h6>
                        <p>${data.notice_period}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Qualification:</strong></h6>
                        <p>${data.qualification}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Last Organization:</strong></h6>
                        <p>${data.lastorg}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Last Designation:</strong></h6>
                        <p>${data.last_designation}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Job Type:</strong></h6>
                        <p>${data.jobType}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Total Experience:</strong></h6>
                        <p>${data.totalExp}</p>
                    </div>

                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Reason for Change:</strong></h6>
                        <p>${data.reason}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Last Organization Email:</strong></h6>
                        <p>${data.lastOrgEmail}</p>
                    </div>

                    <!-- Additional Information Section -->
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Reference:</strong></h6>
                        <p>${data.ref}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Reference Name:</strong></h6>
                        <p>${data.refname}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Employed:</strong></h6>
                        <p>${data.empl}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Earlier Team:</strong></h6>
                        <p>${data.earlier_team}</p>
                    </div>

                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Earlier Employment:</strong></h6>
                        <p>${data.earlier_employment}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Earlier Position:</strong></h6>
                        <p>${data.earlier_position}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Earlier Leaving Reason:</strong></h6>
                        <p>${data.earlier_leaving}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Date of Birth:</strong></h6>
                        <p>${data.dob}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Current Address:</strong></h6>
                        <p>${data.currentAddress}</p>
                    </div>
                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Current City:</strong></h6>
                        <p>${data.currentCity}</p>
                    </div>

                    <div class="col-12 col-md-3 mb-3">
                        <h6><strong>Conveyance:</strong></h6>
                        <p>${data.conveyance}</p>
                    </div>

                    <!-- Resume Section -->
                    <div class="col-12">
                        <div class="badge bg-info">Resume: <a href="${BASE_URL}employee/employee-app/uploads/${data.id}/${data.resume}" target="_blank">View / Download</a></div>
                    </div>
                </div>
            `;

            approveInput.value = data.id;
            modalFooter.classList.remove('d-none');
        });
    });
  function setPifAction(action) {
        const actionInput = document.getElementById('pif_action_input');
        actionInput.value = action;
    }
  </script>
  <script>
(function () {
  const table = document.getElementById('appsTable');
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const searchInput = document.getElementById('tableSearch');
  const rowsPerPageInput = document.getElementById('rowsPerPage');

  let filteredRows = [...rows];
  let currentPage = 1;

  function normalize(str) {
    return (str || '').toString().toLowerCase().trim();
  }

  function paginateData() {
    const rowsPerPage = rowsPerPageInput.value === 'all'
      ? filteredRows.length
      : parseInt(rowsPerPageInput.value, 10);

    const totalRows = filteredRows.length;
    const totalPages = Math.ceil(totalRows / rowsPerPage);

    currentPage = Math.min(currentPage, totalPages);
    const start = (currentPage - 1) * rowsPerPage;
    const end = start + rowsPerPage;

    rows.forEach(row => (row.style.display = 'none'));
    filteredRows.slice(start, end).forEach(row => (row.style.display = ''));

    renderPagination(totalPages);
  }
  function renderPagination(totalPages) {
    const pager = document.getElementById('pager');
    if (!pager) return;
    pager.innerHTML = '';
    if (totalPages <= 1) return;

    for (let i = 1; i <= totalPages; i++) {
      const li = document.createElement('li');
      li.className = 'page-item' + (i === currentPage ? ' active' : '');
      const a = document.createElement('a');
      a.className = 'page-link';
      a.href = '#';
      a.textContent = i;
      a.addEventListener('click', (e) => {
        e.preventDefault();
        currentPage = i;
        paginateData();
      });
      li.appendChild(a);
      pager.appendChild(li);
    }
  }
  function applySearch() {
    const query = normalize(searchInput.value);
    filteredRows = rows.filter(row =>
      normalize(row.innerText).includes(query)
    );
    currentPage = 1;
    paginateData();
  }
  searchInput.addEventListener('input', applySearch);
  rowsPerPageInput.addEventListener('change', () => {
    currentPage = 1;
    paginateData();
  });
  document.getElementById('btnRefresh')?.addEventListener('click', () => {
    location.reload();
  });
  applySearch();
})();
</script>

</body>
</html>
