<?php
session_start();
require '../config.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}
$res = mysqli_query($conn, "SELECT * FROM employee_applications WHERE application_status='submitted'");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Pending Applications</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h3 class="mb-4">Pending Applications</h3>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>employee Name</th>
                <th>Email</th>
                <th>Payment Proof</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = mysqli_fetch_assoc($res)): ?>
            <tr>
                <td><?= $row['first_name'] . ' ' . $row['last_name'] ?></td>
                <td><?= $row['email'] ?></td>
                <td><a href="../uploads/payment_proofs/<?= $row['payment_proof'] ?>" target="_blank">View Proof</a></td>
                <td>
                    <a href="view_application.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-info">View</a>
                    <a href="approve.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-success">Approve</a>
                    <a href="reject.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger">Reject</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>