<?php
session_start();
require '../../config.php';

if (!isset($_SESSION['email'])) {
    header("Location: " . BASE_URL . "employee/login");
    exit;
}

$email = $_SESSION['email'];

$step = $_SESSION['step'] ?? 'current';
$success = $_SESSION['success_message'] ?? '';
$error = $_SESSION['error_message'] ?? '';

unset($_SESSION['step'], $_SESSION['success_message'], $_SESSION['error_message']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['verify_current'])) {
        $current_password = $_POST['current_password'];
        $query = mysqli_query($conn, "SELECT * FROM employees WHERE email = '" . mysqli_real_escape_string($conn, $email) . "'");
        $employee = mysqli_fetch_assoc($query);

        if ($employee && password_verify($current_password, $employee['password'])) {
            $_SESSION['step'] = 'new';
        } else {
            $_SESSION['error_message'] = "Current password is incorrect.";
            $_SESSION['step'] = 'current';
        }

        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }

    if (isset($_POST['update_password'])) {
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];

        if ($new_password !== $confirm_password) {
            $_SESSION['error_message'] = "New passwords do not match.";
            $_SESSION['step'] = 'new';
        } else {
            $hashed = password_hash($new_password, PASSWORD_DEFAULT);
            $escaped_email = mysqli_real_escape_string($conn, $email);

            $update = mysqli_query($conn, "UPDATE employees SET password = '$hashed' WHERE email = '$escaped_email'");
            if ($update) {
                $_SESSION['success_message'] = "Password changed successfully.";
                $_SESSION['step'] = 'current';
            } else {
                $_SESSION['error_message'] = "Error updating password.";
                $_SESSION['step'] = 'new';
            }
        }

        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Change Password</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="shortcut icon" type="image/jpg" href="<?= BASE_URL ?>assets/images/logos/favicon.ico">
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/styles.min.css">
  <style>
    body {
      background: linear-gradient(120deg, #c190f5ff, #93bbffff, #fddfedff, #80f1ecff);
      background-size: 400% 400%;
      animation: gradientFlow 15s ease infinite;
    }

    @keyframes gradientFlow {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }

    .form-card {
      background: #fff;
      border-radius: 12px;
      padding: 40px;
      max-width: 450px;
      margin: 80px auto;
      box-shadow: 0 20px 50px rgba(0,0,0,0.1);
    }

    .form-card h2 {
      text-align: center;
      margin-bottom: 25px;
      font-weight: 600;
      color: #333;
    }

    .form-group {
      margin-bottom: 20px;
    }

    label {
      font-weight: 500;
      margin-bottom: 6px;
      display: block;
    }

    input {
      width: 100%;
      padding: 12px 14px;
      border-radius: 8px;
      border: 1px solid #ddd;
      font-size: 1rem;
    }

    .body-wrapper .container-fluid {
      padding-top: 80px !important;
    }

    .btn-update {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #6A11CB, #2575FC);
      color: #fff;
      font-weight: 500;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      transition: background 0.3s;
    }

    .btn-update:hover {
      background: linear-gradient(135deg, #5e0fba, #1f6ae1);
    }

    .alert {
      padding: 12px;
      border-radius: 6px;
      margin-bottom: 20px;
    }

    .alert-danger {
      background-color: #ffdddd;
      color: #b30000;
    }

    .alert-success {
      background-color: #ddffdd;
      color: #006600;
    }
  </style>
</head>
<body>
  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6"
       data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">

    <?php
    include __DIR__ . '/../partials/header.php';
    include __DIR__ . '/../partials/sidebar.php';
    ?>

    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid">
        <div class="form-card">
          <h2>Change Password</h2>

          <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
          <?php endif; ?>

          <?php if (!empty($success)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($success) ?></div>
          <?php endif; ?>

          <?php if ($step === 'current'): ?>
            <form method="POST">
              <div class="form-group">
                <label for="current_password">Current Password</label>
                <input type="password" name="current_password" id="current_password" required>
              </div>
              <button class="btn-update" name="verify_current">Verify Password</button>
            </form>
          <?php elseif ($step === 'new'): ?>
            <form method="POST">
              <div class="form-group">
                <label for="new_password">New Password</label>
                <input type="password" name="new_password" id="new_password" required>
              </div>
              <div class="form-group">
                <label for="confirm_password">Confirm New Password</label>
                <input type="password" name="confirm_password" id="confirm_password" required>
              </div>
              <button class="btn-update" name="update_password">Update Password</button>
            </form>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <script src="<?= BASE_URL ?>assets/libs/jquery/dist/jquery.min.js"></script>
  <script src="<?= BASE_URL ?>assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
  <script src="<?= BASE_URL ?>assets/js/sidebarmenu.js"></script>
  <script src="<?= BASE_URL ?>assets/js/app.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/iconify-icon@1.0.8/dist/iconify-icon.min.js"></script>
</body>
</html>
