<?php
// employee/dashboard.php
session_start();
require '../../config.php'; // contains DB config and BASE_URL etc.

if (!isset($_SESSION['email'])) {
    header("Location: " . BASE_URL . "employee/login");
    exit;
}
mysqli_set_charset($conn, 'utf8mb4');

// Fetch user's application progress
$email = $_SESSION['email'];
$q = mysqli_prepare($conn, "SELECT * FROM employee_applications WHERE email=? ORDER BY id DESC LIMIT 1");
mysqli_stmt_bind_param($q, 's', $email);
mysqli_stmt_execute($q);
$res = mysqli_stmt_get_result($q);
$app = ($res && mysqli_num_rows($res)) ? mysqli_fetch_assoc($res) : [];

$completedSteps = [];
if (!empty($app['title'])) $completedSteps[] = 1;
if (!empty($app['ssc_certificate']) && !empty($app['inter_certificate'])) $completedSteps[] = 2;
if (!empty($app['experience_details']) || !empty($app['experience_letter'])) $completedSteps[] = 3;
if ($app['application_status'] === 'submitted') $completedSteps[] = 4;

$isSubmitted = ($app['application_status'] ?? '') === 'submitted';
$employeeName = $_SESSION['employee_name'] ?? 'Applicant';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width">
  <title>Employee Dashboard – Investors-Clinic</title>
  <link rel="shortcut icon" href="<?= BASE_URL ?>assets/images/logos/favicon.ico" />
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/styles.min.css" />
  <style>
    /* Minimal inline tweaks */
    .step-card { cursor: pointer; }
    .completed { opacity: 0.6; pointer-events: none; }
  </style>
</head>
<body>
<div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6"
       data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">

    <?php
    include __DIR__ . '/../partials/header.php';
    include __DIR__ . '/../partials/sidebar.php';
    ?>

    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid">
      <h2>Welcome, <?= htmlspecialchars($employeeName) ?>!</h2>
      <p class="text-muted">Track your application progress</p>

      <div class="row">
        <div class="col-lg-3 col-md-4 mb-3">
          <div class="card p-3 step-card <?= in_array(1, $completedSteps) ? 'completed' : '' ?>" onclick="location='?step=1'">
            <h5>Step 1: Application Details</h5>
            <div>Status: <?= in_array(1, $completedSteps) ? 'Completed' : 'Pending' ?></div>
          </div>
        </div>
        <div class="col-lg-3 col-md-4 mb-3">
          <div class="card p-3 step-card <?= in_array(2, $completedSteps) ? 'completed' : '' ?>" onclick="location='?step=2'">
            <h5>Step 2: Academic Certificates</h5>
            <div>Status: <?= in_array(2, $completedSteps) ? 'Completed' : 'Pending' ?></div>
          </div>
        </div>
        <div class="col-lg-3 col-md-4 mb-3">
          <div class="card p-3 step-card <?= in_array(3, $completedSteps) ? 'completed' : '' ?>" onclick="location='?step=3'">
            <h5>Step 3: Experience</h5>
            <div>Status: <?= in_array(3, $completedSteps) ? 'Completed' : 'Pending' ?></div>
          </div>
        </div>
        <div class="col-lg-3 col-md-4 mb-3">
          <div class="card p-3 <?= $isSubmitted ? 'completed' : '' ?>">
            <h5>Step 4: Review & Submit</h5>
            <div>Status: <?= $isSubmitted ? 'Submitted' : 'Pending' ?></div>
          </div>
        </div>
      </div>

      <div class="mt-4">
        <h4>Your Details</h4>
        <ul class="list-group">
          <li class="list-group-item">Name: <?= htmlspecialchars($app['title'] .' '. $app['first_name'] .' '. $app['surname'] ?? '') ?></li>
          <li class="list-group-item">Application Status: <?= htmlspecialchars($app['application_status'] ?? 'In Progress') ?></li>
          <li class="list-group-item">Submitted: <?= $isSubmitted ? 'Yes' : 'No' ?></li>
        </ul>
      </div>

      <div class="mt-4 no-print">
        <?php if(!$isSubmitted): ?>
          <a href="?step=<?= !in_array(1, $completedSteps) ? 1 : (in_array(2, $completedSteps)? 3 : 2) ?>" class="btn btn-primary">Continue Application</a>
        <?php else: ?>
          <span class="badge bg-success">Your application has been submitted </span>
        <?php endif; ?>
      </div>

    </div>
  </div>

  <?php include __DIR__ . '/../partials/footer.php'; ?>
</div>
</body>
</html>
