<?php
session_start();
require '../../config.php';

if (!isset($_SESSION['email'])) {
    header("Location: " . BASE_URL . "employee/login/");
    exit;
}
mysqli_set_charset($conn, 'utf8mb4');

$email = $_SESSION['email'];
$q = mysqli_prepare($conn, "SELECT * FROM employee_applications WHERE email=? ORDER BY id DESC LIMIT 1");
mysqli_stmt_bind_param($q, 's', $email);
mysqli_stmt_execute($q);
$res = mysqli_stmt_get_result($q);
$app = ($res && mysqli_num_rows($res)) ? mysqli_fetch_assoc($res) : [];

$completedSteps = [];
$step1Complete = false;
$q1 = mysqli_prepare($conn, "SELECT email FROM user_pif WHERE email=? LIMIT 1");
mysqli_stmt_bind_param($q1, 's', $email);
mysqli_stmt_execute($q1);
$res1 = mysqli_stmt_get_result($q1);
if ($res1 && mysqli_num_rows($res1) > 0) {
    $step1Complete = true;
}
if ($step1Complete) $completedSteps[] = 1;
if (!empty($app['title']) && !empty($app['religion'])) $completedSteps[] = 2;
if (!empty($app['passport_photo']) || !empty($app['aadhar_front'])) $completedSteps[] = 3;
if (!empty($app['bank_document'])) $completedSteps[] = 4;
if (!empty($app['ssc_certificate'])) $completedSteps[] = 5;
if (!empty($app['experience_letter'])) $completedSteps[] = 6;
if (!empty($app['application_status']) && $app['application_status'] === 'submitted') $completedSteps[] = 7;

$isSubmitted = ($app['application_status'] ?? '') === 'submitted';
$employeeName = $_SESSION['employee_name'] ?? 'Applicant';


$allSteps = [
    1 => 'Pre Application Form',
    2 => 'Personal Details',
    3 => 'Identity & Photo',
    4 => 'Bank Details',
    5 => 'Academics',
    6 => 'Experience Documents',
    7 => 'Final Submission'
];

$totalSteps = count($allSteps);
$completedCount = count($completedSteps);
$progressPercent = ($completedCount / $totalSteps) * 100;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width">
  <title>Employee Dashboard</title>
  <link rel="shortcut icon" href="<?= BASE_URL ?>assets/images/logos/favicon.ico" />
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/styles.min.css" />
  <style>
    .step-card { cursor: pointer; }
    .completed { opacity: 0.6; pointer-events: none;     background-color: aliceblue;}
  </style>
</head>
<body>
<div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
  <?php include __DIR__."/../partials/header.php"; include __DIR__."/../partials/sidebar.php"; ?>
  <div class="body-wrapper">
  <div class="container-fluid mt-4"><div class="card shadow-sm border-0 rounded-3"><div class="card-body">
      <h2>Welcome, <?= htmlspecialchars($employeeName) ?>!</h2>
      <p class="text-muted">Track your application progress</p>

      <div class="mb-4">
        <h5>Application Progress</h5>
        <div class="progress" style="height: 30px;">
            <div class="progress-bar" role="progressbar" style="width: <?= $progressPercent ?>%;" aria-valuenow="<?= $progressPercent ?>" aria-valuemin="0" aria-valuemax="100">
                <?= round($progressPercent) ?>%
            </div>
        </div>
      </div>

      <div class="row mt-3">
        <?php foreach ($allSteps as $stepNum => $stepTitle): ?>
          <?php $isDone = in_array($stepNum, $completedSteps); ?>
          <div class="col-lg-3 col-md-4 mb-3">
            <div class="card p-3 step-card <?= $isDone ? 'completed' : '' ?>" onclick="location='<?= BASE_URL ?>employee/employee-app/?step=<?= $stepNum ?>'">
              <h6>Step <?= $stepNum ?>: <?= htmlspecialchars($stepTitle) ?></h6>
              <div>Status: <?= $isDone ? 'Completed' : 'Pending' ?></div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>

      <div class="mt-4">
        <h4>Your Details</h4>
        <ul class="list-group">
          <li class="list-group-item">Name: <?= htmlspecialchars($app['title'] .' '. $app['first_name'] .' '. $app['surname'] ?? '') ?></li>
          <li class="list-group-item">Application Status: <?= htmlspecialchars($app['application_status'] ?? 'In Progress') ?></li>
          <li class="list-group-item">Submitted: <?= $isSubmitted ? 'Yes' : 'No' ?></li>
        </ul>
      </div>

      <div class="mt-4 no-print">
        <?php if(!$isSubmitted): ?>
            <?php $nextStep = null; for ($i = 1; $i <= 7; $i++) { if (!in_array($i, $completedSteps)) {$nextStep = $i;break;}}?>
            <?php if($nextStep): ?>
                <a href="?step=<?= $nextStep ?>" class="btn btn-primary">Continue Application</a>
            <?php else: ?>
                <span class="badge bg-success">All steps completed, ready to submit</span>
            <?php endif; ?>
        <?php else: ?>
            <span class="badge bg-success">Your application has been submitted</span>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <?php include __DIR__ . '/../partials/footer.php'; ?>
</div>
</div></div>
</body>
</html>
