<?php
date_default_timezone_set('Asia/Kolkata');
session_start();
require '../../config.php';

if (!isset($_SESSION['email'])) {
    header("Location: " . BASE_URL . "employee/login/");
    exit;
}
mysqli_set_charset($conn, 'utf8mb4');
$email = $_SESSION['email'];
function file_url($id, $name) {
    if (!$name) return null;
    return BASE_URL . "employee/employee-app/uploads/{$id}/" . $name;
}
$att_docs = [
    'offer_letter' => '',
    'kra' => '',
    'apl' => '',
    'undertaking' => '',
    'code_of_conduct' => ''
];
$statuses = [
    'offer_letter_status' => '',
    'kra_status' => '',
    'apl_status' => '',
    'undertaking_status' => '',
    'code_of_conduct_status' => ''
];
$id = null;
$query = "SELECT * FROM doc_by_hr WHERE email = '$email' LIMIT 1";
$result = mysqli_query($conn, $query);
if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $id = $row['id'];
    foreach ($att_docs as $field => $value) {
        if (!empty($row[$field])) {
            $att_docs[$field] = $row[$field];
        }
    }
    foreach ($statuses as $field => $value) {
        if (isset($row[$field])) {
            $statuses[$field] = $row[$field];
        }
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['approve_doc'])) {
    $doc_key = $_POST['doc_key'];
    $status_field = $doc_key . "_status";
    $date_field = $doc_key . "_approved_date";
    $now = date('Y-m-d H:i:s');

    $query = "UPDATE doc_by_hr 
              SET `$status_field` = 'approved', 
                  `$date_field` = '$now' 
              WHERE email = '$email'";

    mysqli_query($conn, $query);
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width">
  <title>Document By HR</title>
  <link rel="shortcut icon" href="<?= BASE_URL ?>assets/images/logos/favicon.ico" />
  <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/styles.min.css" />
</head>
<style>
  .table-rounded {
    border-radius: 0.5rem;
    overflow: hidden;
  }
  .custom-img {
    max-height: 70vh;
    max-width: 100%;
  }
</style>

<body>
<div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6"
       data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">

    <?php
    include __DIR__ . '/../partials/header.php';
    include __DIR__ . '/../partials/sidebar.php';
    ?>
    <div class="body-wrapper">
      <div class="body-wrapper-inner container-fluid">
            <h4 class="mb-4">Employee Documents</h4>
        <div class="table-responsive">
            <table class="table table-striped table-hover align-middle table-rounded">
                <thead class="table-dark">
                <tr>
                    <th>Document</th>
                    <th>Action</th>
                    <th>Status</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($att_docs as $doc => $filename): ?>
                    <?php
                    $status_field = $doc . '_status';
                    $status = $statuses[$status_field] ?? 'pending';
                    $label = ucfirst(str_replace('_', ' ', $doc));
                    ?>
                    <tr>
                        <td><?= $label ?></td>
                        <td>
                            <?php if ($filename): ?>
                                <?php $status = $statuses[$doc . '_status'] ?? 'pending'; ?>
                                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modal_<?= $doc ?>">
                                    <?= $status === 'approved' ? 'View' : 'View / Approve' ?>
                                </button>
                            <?php else: ?>
                                <span class="text-muted">Not uploaded</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($status === 'approved'): ?>
                                <span class="badge bg-success">Approved</span>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark">Pending</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
      </div>
    </div>

    <?php include __DIR__ . '/../partials/footer.php'; ?>
</div>
<?php foreach ($att_docs as $doc => $filename): ?>
    <?php if ($filename): ?>
        <?php 
            $doc_url = file_url($id, $filename) . '?v=' . time(); 
            $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
            $isImage = in_array($ext, ['jpg', 'jpeg', 'png', 'webp', 'gif']);
        ?>
        <div class="modal fade" id="modal_<?= $doc ?>" tabindex="-1" aria-labelledby="modalLabel_<?= $doc ?>" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel_<?= $doc ?>"><?= ucfirst(str_replace('_', ' ', $doc)) ?></h5>
                        <a href="<?= $doc_url ?>" download class="btn btn-sm btn-secondary ms-4">Download Document</a>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body d-flex justify-content-center align-items-center" style="height: 70vh; overflow-y: auto;">
                        <?php if ($isImage): ?>
                            <img src="<?= htmlspecialchars($doc_url) ?>" alt="<?= htmlspecialchars($doc) ?>" style="max-width: 100%; max-height: 100%; object-fit: contain; display: block;" >
                        <?php else: ?>
                            <iframe src="<?= htmlspecialchars($doc_url) ?>" width="100%" height="100%" style="border: none;"></iframe>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <?php if (($statuses[$doc . '_status'] ?? '') !== 'approved'): ?>
                            <form method="post">
                                <input type="hidden" name="doc_key" value="<?= $doc ?>">
                                <button type="submit" name="approve_doc" class="btn btn-success">Approve</button>
                            </form>
                        <?php else: ?>
                            <span class="text-success me-auto">Already approved</span>
                        <?php endif; ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php endforeach; ?>


</body>
</html>
