<?php
ini_set('display_errors',1);ini_set('display_startup_errors',1);error_reporting(E_ALL);
require '../../../config.php';mysqli_set_charset($conn,'utf8mb4');
$q = isset($_GET['q']) ? trim($_GET['q']) : '';
$qLike = $q!=='' ? "%$q%" : '%';
$cities = [];
/* Try DB first */
$haveTable = mysqli_query($conn,"SHOW TABLES LIKE 'india_cities'");
if($haveTable && mysqli_num_rows($haveTable)>0){
    $sql = "SELECT DISTINCT city FROM india_cities WHERE country='India' AND city LIKE ? ORDER BY city ASC LIMIT 500";
    $stmt = mysqli_prepare($conn,$sql);
    mysqli_stmt_bind_param($stmt,"s",$qLike);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    while($row = mysqli_fetch_assoc($res)){ $cities[] = $row['city']; }
}
/* Fallback if table missing/empty */
if(empty($cities)){
    $fallback = ["Noida","Greater Noida","Ghaziabad","Delhi","New Delhi","Gurugram","Faridabad","Mumbai","Pune","Nagpur","Bengaluru","Chennai","Hyderabad","Kolkata","Jaipur","Lucknow","Kanpur","Varanasi","Bhopal","Indore","Surat","Ahmedabad","Vadodara","Chandigarh"];
    if($q!==''){ $qLower=strtolower($q); $fallback=array_values(array_filter($fallback,function($c)use($qLower){return strpos(strtolower($c),$qLower)!==false;})); }
    $cities = array_slice($fallback,0,200);
}
header('Content-Type: application/json; charset=utf-8');
echo json_encode(['cities'=>$cities]);
