<?php
ini_set('display_errors',1);ini_set('display_startup_errors',1);error_reporting(E_ALL);
require '../../../config.php';mysqli_set_charset($conn,'utf8mb4');
$city = isset($_GET['city']) ? trim($_GET['city']) : '';
$pins = [];
if($city!==''){
    $have = mysqli_query($conn,"SHOW TABLES LIKE 'india_pincodes'");
    if($have && mysqli_num_rows($have)>0){
        $sql="SELECT DISTINCT pincode FROM india_pincodes WHERE city=? ORDER BY pincode ASC LIMIT 500";
        $st=mysqli_prepare($conn,$sql);
        mysqli_stmt_bind_param($st,"s",$city);
        mysqli_stmt_execute($st);
        $res=mysqli_stmt_get_result($st);
        while($row=mysqli_fetch_assoc($res)){ $pins[]=$row['pincode']; }
    }
    /* Fallback */
    if(empty($pins)){
        $map=[
            'Noida'=>['201301','201303','201304','201305','201307'],
            'Greater Noida'=>['201308'],
            'Ghaziabad'=>['201001'],
            'Delhi'=>['110001','110019'],
            'New Delhi'=>['110002'],
            'Gurugram'=>['122001','122018'],
            'Mumbai'=>['400001','400076'],
            'Pune'=>['411001','411057']
        ];
        $pins = $map[$city] ?? [];
    }
}
header('Content-Type: application/json; charset=utf-8');
echo json_encode(['pincodes'=>$pins]);
