<?php
ini_set('display_errors',1);ini_set('display_startup_errors',1);error_reporting(E_ALL);
session_start();
require_once '../../config.php';

mysqli_set_charset($conn,'utf8mb4');
mysqli_query($conn,"SET collation_connection='utf8mb4_general_ci'");

if(!isset($_SESSION['email'])){header("Location: ".(defined('BASE_URL')?BASE_URL:'')."employee/login/");exit;}

/* ------------ helpers ------------ */
function v($k, $d = '') {if (!isset($_POST[$k])) return $d;$val = $_POST[$k];if (is_string($val)){return trim($val);}return $val;}
function clean_name($s){$s=preg_replace('~[^A-Za-z0-9._-]+~','-',$s);return trim($s,'-');}
function ensure_dir($p){if(!is_dir($p)){mkdir($p,0775,true);}}
function file_url($id,$name){ if(!$name) return null; return "uploads/{$id}/".$name; }
function is_image_path($path){ if(!$path) return false; $ext=strtolower(pathinfo($path,PATHINFO_EXTENSION)); return in_array($ext,['jpg','jpeg','png','webp','gif']); }
function save_file($f, $allowed, $dest, $maxSize = null) {
    if (!isset($_FILES[$f]) || $_FILES[$f]['error'] === UPLOAD_ERR_NO_FILE) return null;
    if ($_FILES[$f]['error'] !== UPLOAD_ERR_OK) { $_SESSION['flash_error'] = "Upload error on $f (code " . $_FILES[$f]['error'] . ")"; header("Location: ?step=" . ($_GET['step'] ?? 1)); exit; }
    if ($maxSize !== null && $_FILES[$f]['size'] > $maxSize) { $_SESSION['flash_error'] = "$f exceeds the maximum allowed size of " . round($maxSize / 1024) . " KB."; header("Location: ?step=" . ($_GET['step'] ?? 1)); exit; }
    $ext = strtolower(pathinfo($_FILES[$f]['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, $allowed)) { $_SESSION['flash_error'] = "Invalid file type for $f"; header("Location: ?step=" . ($_GET['step'] ?? 1)); exit; }
    ensure_dir($dest);
    $name = date('Ymd_His') . "_" . clean_name($_FILES[$f]['name']);
    if (!move_uploaded_file($_FILES[$f]['tmp_name'], $dest . $name)) { $_SESSION['flash_error'] = "Failed to save $f"; header("Location: ?step=" . ($_GET['step'] ?? 1)); exit; }
    return $name;
}
/* ---- SendGrid mail ---- */
function send_confirmation_email($toEmail, $toName, &$err = null) {
    $apiKey    = defined('SENDGRID_API_KEY') ? SENDGRID_API_KEY : '';
    $fromEmail = defined('SENDGRID_FROM_EMAIL') ? SENDGRID_FROM_EMAIL : '';
    $fromName  = defined('SENDGRID_FROM_NAME') ? SENDGRID_FROM_NAME : 'Investors Clinic';

    if ($apiKey === '' || $fromEmail === '') {
        $err = "Email service not configured (API key or sender email missing)";
        return false;
    }

    $subject = "Investors Clinic | Application Submitted";
    $line1 = "Thank you! Your application has been submitted successfully.";
    $plain = $line1."\n".$line2."\n".$line3;

    $html = '<div style="font-family:Inter,Arial,sans-serif;line-height:1.6;color:#111">
                <div style="max-width:640px;margin:auto;border:1px solid #eaeaea;border-radius:12px;overflow:hidden">
                  <div style="background:#0e3a5f;color:#fff;padding:18px 22px;font-weight:700"> Investors Clinic</div>
                  <div style="padding:22px">
                    <div style="display:flex;gap:12px;align-items:center;margin-bottom:10px">
                      <svg width="28" height="28" viewBox="0 0 24 24" fill="none">
                        <circle cx="12" cy="12" r="11" stroke="#A5E51C" stroke-width="2"></circle>
                        <path d="M7 12.5l3.2 3.2L17 9" stroke="#A5E51C" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                      <div style="font-size:18px;font-weight:700">'.$line1.'</div>
                    </div>
                    <p style="margin:6px 0">'.$line2.'</p>
                    <p style="margin:6px 0">'.$line3.'</p>
                    <p style="margin-top:18px;color:#555">Regards,<br><b> Investors Clinic</b></p>
                  </div>
                </div>
              </div>';

    $data = [
        "from" => ["address" => $fromEmail, "name" => $fromName],
        "to"   => [["email_address" => ["address" => $toEmail, "name" => $toName]]],
        "subject"  => $subject,
        "htmlbody" => $html,
        "textbody" => $plain
    ];
    $ch = curl_init("https://api.zeptomail.in/v1.1/email");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => [
            "Authorization: Zoho-enczapikey $apiKey",
            "Content-Type: application/json",
            "Accept: application/json"
        ],
        CURLOPT_POST       => true,
        CURLOPT_POSTFIELDS => json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT    => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);
    $resp = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlErr = curl_error($ch);
    curl_close($ch);
    if ($curlErr) {
        $err = "cURL error: $curlErr";
        return false;
    }
    if (!in_array($http, [200, 201, 202])) {
        $err = "Mail API HTTP $http: " . ($resp ?: 'No response body');
        return false;
    }
    return true;
}

/* ---- schema upgrades WITHOUT 'IF NOT EXISTS' ---- */
function _db_name($conn){$r=mysqli_query($conn,"SELECT DATABASE()");$row=$r?mysqli_fetch_row($r):[null];return $row[0];}
function _col_exists($conn,$table,$column){
    $db=_db_name($conn); $sql="SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=? LIMIT 1";
    $st=mysqli_prepare($conn,$sql); mysqli_stmt_bind_param($st,"sss",$db,$table,$column); mysqli_stmt_execute($st);
    $res=mysqli_stmt_get_result($st); return ($res && mysqli_num_rows($res)>0);
}
function add_column_if_missing($conn,$table,$column,$definition,$after=null){
    if(!_col_exists($conn,$table,$column)){
        $sql="ALTER TABLE `$table` ADD COLUMN `$column` $definition".($after?" AFTER `$after`":"");
        if(!mysqli_query($conn,$sql)){ die("Schema update failed for `$column`: ".mysqli_error($conn)); }
    }
}
$__tbl='employee_applications';
add_column_if_missing($conn,$__tbl,'preferred_language','VARCHAR(50) NULL','gender');
add_column_if_missing($conn,$__tbl,'has_passport','TINYINT(1) NULL DEFAULT 0','language_proficiency');
add_column_if_missing($conn,$__tbl,'aadhar_front','VARCHAR(255) NULL','aadhar_number');
add_column_if_missing($conn,$__tbl,'aadhar_back','VARCHAR(255) NULL','aadhar_front');
add_column_if_missing($conn,$__tbl,'ssc_board','VARCHAR(30) NULL',);
add_column_if_missing($conn,$__tbl,'inter_board','VARCHAR(30) NULL');

/* ---- load or create application row ---- */
$email = $_SESSION['email'];

// Load application from employee_applications
$app = null;
  $q = mysqli_prepare($conn, "SELECT * FROM employee_applications WHERE email=? ORDER BY id DESC LIMIT 1");
  mysqli_stmt_bind_param($q, "s", $email);
  mysqli_stmt_execute($q);
  $r = mysqli_stmt_get_result($q);
  if ($r && mysqli_num_rows($r) > 0) {
      $app = mysqli_fetch_assoc($r);
      $_SESSION['broriser_app_id'] = $app['id'];
  }
  if (!$app) {
      $ins = mysqli_prepare($conn, "INSERT INTO employee_applications (email, application_status, created_at) VALUES (?,'in-progress',NOW())");
      mysqli_stmt_bind_param($ins, "s", $email);
      mysqli_stmt_execute($ins);
      $_SESSION['broriser_app_id'] = mysqli_insert_id($conn);
      $app = ['id' => $_SESSION['broriser_app_id'], 'email' => $email, 'application_status' => 'in-progress'];
  }

  if (isset($_GET['step'])) {
      $step = max(1, min(7, (int)$_GET['step']));
  } else {
      $step = determine_next_step($app, null);
  }
  $pre_app = null;
  if ($step === 1) {
      $q = mysqli_prepare($conn, "SELECT * FROM user_pif WHERE email = ? ORDER BY idpif DESC LIMIT 1");
      mysqli_stmt_bind_param($q, "s", $email);
      mysqli_stmt_execute($q);
      $r = mysqli_stmt_get_result($q);

      if ($r && mysqli_num_rows($r) > 0) {
          $pre_app = mysqli_fetch_assoc($r);
          $_SESSION['broriser_pre_app_id'] = $pre_app['idpif'];
      }
  }
  $pre_app_status = strtolower($pre_app['st1_status'] ?? '');
  $showApprovalPendingMessage = in_array($pre_app_status, ['pending', 'rejected']);
  $showWizard = true;

  if ($showApprovalPendingMessage) {
      // $showWizard = false;
  } else if ($step === 1 && !isset($_SESSION['pre_app_submitted'])) {
      // $showWizard = false;
  }

  if (isset($_GET['step']) && (int)$_GET['step'] === 1 && $pre_app_status === 'approved') {
      $_SESSION['flash_message'] = "Step 1 already approved. Redirected to Step 2.";
      header("Location: index.php?step=2");
      exit;
  }
  $q1 = mysqli_prepare($conn, "SELECT phone, gender, dob, marital_status FROM user_pif WHERE email = ? ORDER BY idpif DESC LIMIT 1");
  mysqli_stmt_bind_param($q1, "s", $email);
  mysqli_stmt_execute($q1);
  $r1 = mysqli_stmt_get_result($q1);
  $pre_app1 = mysqli_fetch_assoc($r1);
function determine_next_step($app, $pre_app = null) {
  if (!$app) return 1;
     if (
        empty($pre_app['st1_status']) ||
        strtolower($pre_app['st1_status']) === 'pending' ||
        strtolower($pre_app['st1_status']) === 'rejected' ||
        empty($pre_app['resume']) ||
        empty($pre_app['current_salary']) ||
        empty($pre_app['dob']) ||
        empty($pre_app['currentCity'])
    ) {
        return 1;
    }
    if (empty($pre_app['resume']) || empty($pre_app['current_salary']) || empty($pre_app['dob']) || empty($pre_app['currentCity'])) return 1;
    if (empty($app['title']) || empty($app['first_name']) || empty($app['dob']) || empty($app['city'])) return 2;
    if (empty($app['aadhar_front']) || empty($app['aadhar_back'])) return 3;
    if (empty($app['bank_document']) || empty($app['account_number'])) return 4;
    if (empty($app['ssc_certificate']) || empty($app['inter_certificate'])) return 5;
    if (empty($app['experience_details'])) return 6;
    if (($app['application_status'] ?? '') !== 'submitted') return 7;

    return 7;
}

$pre_application = null;
$q1 = mysqli_prepare($conn, "SELECT * FROM user_pif WHERE email = ? ORDER BY idpif DESC LIMIT 1");
if ($q1) {
    mysqli_stmt_bind_param($q1, "s", $email);
    mysqli_stmt_execute($q1);
    $res = mysqli_stmt_get_result($q1);
    if ($res && mysqli_num_rows($res) > 0) {
        $pre_application = mysqli_fetch_assoc($res);
    }
    mysqli_stmt_close($q1);
} else {
    die('Prepare failed (pre-application): ' . mysqli_error($conn));
}

if (isset($_GET['step'])) {
    $step = max(1, min(7, (int)$_GET['step']));
} else {
    $step = determine_next_step($app, $pre_application);
}
$actualStep = determine_next_step($app, $pre_application);
if (isset($_GET['step'])) {
    $requestedStep = max(1, min(7, (int)$_GET['step']));
    if ($requestedStep > $actualStep) {
        header("Location: index.php?step={$actualStep}");
        exit;
    }
    $step = $requestedStep;
} else {
    $step = $actualStep;
}

mysqli_stmt_bind_param($q,"s",$email);
mysqli_stmt_execute($q);
$r = mysqli_stmt_get_result($q);

if ($r && mysqli_num_rows($r) > 0) {
    $app = mysqli_fetch_assoc($r);
    if (isset($app['id'])) {
        $_SESSION['broriser_app_id'] = $app['id'];
    }
}
if (!isset($app)) {
    $ins = mysqli_prepare($conn, "INSERT INTO employee_applications (email, application_status, created_at) VALUES (?,'in-progress',NOW())");
    mysqli_stmt_bind_param($ins, "s", $email);
    mysqli_stmt_execute($ins);
    $_SESSION['broriser_app_id'] = mysqli_insert_id($conn);
    $app = [
        'id' => $_SESSION['broriser_app_id'],
        'email' => $email,
        'application_status' => 'in-progress'
    ];
}

$id=(int)$_SESSION['broriser_app_id'];$uploadBase=__DIR__."/uploads/$id/";

if(in_array($app['application_status'] ?? '', ['submitted', 'Approved']) && $step < 7){
    header("Location: ?step=7");
    exit;
}
$allowNextStep = true;
  $showApprovalPendingMessage = false;
  $pre_app_status = $pre_app['st1_status'] ?? null;
  if ($step === 1) {
      if (in_array($pre_app_status, ['Pending', 'Rejected'])) {
          $showApprovalPendingMessage = true;
          $allowNextStep = false;
      }
  }
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($step === 1) {
          $email = $_SESSION['email'] ?? '';
          $phone = $_SESSION['phone'] ?? '';
          $username = $_SESSION['employee_name'] ?? '';
          $recruiter_name = $_POST['recruiter_name'] ?? '';

          $resume_path = save_file('resume', ['pdf', 'doc', 'docx'], $uploadBase, 500 * 1024);
          $resume_to_save = $resume_path ?? ($app['resume'] ?? '');

          $appliedfor = $_POST['appliedfor'] ?? '';
          $current_salary = $_POST['current_salary'] ?? '';
          $expected_salary = $_POST['expected_salary'] ?? '';
          $notice_period = $_POST['notice_period_days'] ?? ($app['notice_period'] ?? '');
          $qualification = $_POST['highest_qualification'] ?? '';
          $lastorg = $_POST['last_organisation'] ?? ($app['lastorg'] ?? '');
          $last_designation = $_POST['designation'] ?? ($app['last_designation'] ?? '');
          $jobType = $_POST['job_type'] ?? ($app['jobType'] ?? 'Full-time');
          $experience = $_POST['totalExp'] ?? '';
          $reason = $_POST['reason_for_leaving'] ?? '';
          $last_email = $_POST['lastOrgEmail'] ?? ($app['lastOrgEmail'] ?? '');
          $gender = $_POST['gender'] ?? '';
          $marital_status = $_POST['marital_status'] ?? '';
          $dob = $_POST['dob'] ?? '';

          $address = $_POST['current_address'] ?? '';
          $city = $_POST['current_city'] ?? '';
          $conveyance = $_POST['conveyance'] ?? '';
          $conveyance_type = $_POST['conveyance_type'] ?? '';
          $own_device = $_POST['own_device'] ?? '';
          $device_type = $_POST['device_type'] ?? '';

          $know_about = $_POST['vacancy_source'] ?? 'Job Portal';
          $others = $_POST['vacancy_source_other'] ?? '';
          $ref = (isset($_POST['known_employee']) && $_POST['known_employee'] === 'Yes') ? 'Yes' : 'No';
          $refname = ($ref === 'Yes') ? ($_POST['known_employee_name'] ?? '') : '';

          $empl = (isset($_POST['empl']) && $_POST['empl'] === 'Yes') ? 'Yes' : 'No';
          $earlier_team = ($empl === 'Yes') ? ($_POST['prev_department'] ?? '') : '';
          $earlier_employment = ($empl === 'Yes') ? ($_POST['earlier_employment'] ?? '') : '';
          $earlier_position = ($empl === 'Yes') ? ($_POST['prev_position'] ?? '') : '';
          $earlier_leaving = ($empl === 'Yes') ? ($_POST['prev_reason_for_leaving'] ?? '') : '';

          $status = 'Approved';
          $check_stmt = mysqli_prepare($conn, "SELECT idpif FROM user_pif WHERE email = ?");
          mysqli_stmt_bind_param($check_stmt, "s", $email);
          mysqli_stmt_execute($check_stmt);
          mysqli_stmt_store_result($check_stmt);

          if (mysqli_stmt_num_rows($check_stmt) > 0) {
              $update_stmt = mysqli_prepare($conn, "UPDATE user_pif SET
                resume = ?, appliedfor = ?, current_salary = ?, expected_salary = ?, notice_period = ?,
                qualification = ?, lastorg = ?, last_designation = ?, jobType = ?, totalExp = ?, reason = ?,
                lastOrgEmail = ?, gender = ?, marital_status = ?, dob = ?, currentAddress = ?, currentCity = ?, conveyance = ?, convyes = ?, own_device = ?, device_type = ?,
                know_about = ?, others = ?, ref = ?, refname = ?, empl = ?, earlier_team = ?, earlier_employment = ?, earlier_position = ?, earlier_leaving = ?, st1_status = ?,
                phone = ?, username = ?, recruiter_name = ?
                WHERE email = ?");

              $update_stmt->bind_param(
                  "ssssissssssssssssssssssssssssssssss",
                  $resume_to_save, $appliedfor, $current_salary, $expected_salary, $notice_period,
                  $qualification, $lastorg, $last_designation, $jobType, $experience, $reason,
                  $last_email, $gender, $marital_status, $dob, $address, $city, $conveyance, $conveyance_type, $own_device, $device_type,
                  $know_about, $others, $ref, $refname, $empl, $earlier_team, $earlier_employment,
                  $earlier_position, $earlier_leaving, $status, $phone, $username, $recruiter_name, $email
              );
              if (!mysqli_stmt_execute($update_stmt)) {
                  die('Update failed: ' . mysqli_stmt_error($update_stmt));
              }
              mysqli_stmt_close($update_stmt);
              $_SESSION['pre_app_submitted'] = true;
              header("Location: ?step=2");
              exit;

          } else {
              $insert_stmt = mysqli_prepare($conn, "INSERT INTO user_pif 
                  (email, resume, appliedfor, current_salary, expected_salary, notice_period, qualification, lastorg, last_designation, jobType, 
                  totalExp, reason, lastOrgEmail, gender, marital_status, dob, currentAddress, currentCity, conveyance, convyes, own_device, device_type,
                  know_about, others, ref, refname, empl, earlier_team, earlier_employment, earlier_position, earlier_leaving, st1_status,
                  phone, username, recruiter_name)
                  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

              $insert_stmt->bind_param(
                  "sssssisssssssssssssssssssssssssssss",
                  $email, $resume_to_save, $appliedfor, $current_salary, $expected_salary,
                  $notice_period, $qualification, $lastorg, $last_designation, $jobType,
                  $experience, $reason, $last_email, $gender, $marital_status, $dob,
                  $address, $city, $conveyance, $conveyance_type, $own_device, $device_type, $know_about, $others,
                  $ref, $refname, $empl, $earlier_team, $earlier_employment,
                  $earlier_position, $earlier_leaving, $status, $phone, $username, $recruiter_name
              );
              if (!mysqli_stmt_execute($insert_stmt)) {
                  die('Insert failed: ' . mysqli_stmt_error($insert_stmt));
              }
              mysqli_stmt_close($insert_stmt);
          }

          mysqli_stmt_close($check_stmt);

          $_SESSION['pre_app_submitted'] = true;
          header("Location: ?step=2");
          exit;
      }

    if ($step === 2) {
        $city        = ($_POST['city'] === '__OTHER__') ? trim($_POST['city_other']) : $_POST['city'];
        $country     = ($_POST['country'] === '__OTHER__') ? trim($_POST['country_other']) : $_POST['country'];
        $state       = ($_POST['state'] === '__OTHER__') ? trim($_POST['state_other']) : $_POST['state'];
        $postal_code = ($_POST['postal_code'] === '__OTHER__') ? trim($_POST['postal_other']) : $_POST['postal_code'];
        $langSel = v('preferred_language') ?? [];
        if (!is_array($langSel)) { $langSel = [$langSel]; }
        if (in_array('Others', $langSel)) {
            $langOther = trim(v('preferred_language_other') ?? '');
            if ($langOther !== '') {
                $langSel = array_filter($langSel, fn($v) => $v !== 'Others');
                $langSel[] = $langOther;
            }
        }
        $preferred_lang      = implode(',', $langSel);
        $marital_status      = v('marital_status');
        $blood_group         = v('blood_group');
        $religion            = v('religion');
        $father_name         = v('father_name');
        $mother_name         = v('mother_name');
        $date_of_marriage    = v('date_of_marriage');
        $spouse_name         = v('spouse_name');
        $son_name            = v('son_name');
        $daughter_name       = v('daughter_name');
        $nominee_name        = v('nominee_name');
        $nominee_relation    = v('nominee_relation');
        $nominee_dob         = v('nominee_dob');
        $nominee_address     = v('nominee_address');
        $emergency_name      = v('emergency_name');
        $emergency_mobile    = v('emergency_mobile');
        $emergency_landline  = v('emergency_landline');
        $emergency_relation  = v('emergency_relation');
        $reference_1         = v('reference_1');
        $reference_1_contact = v('reference_1_contact');
        $reference_2         = v('reference_2');
        $reference_2_contact = v('reference_2_contact');
        $has_uan        = (int)v('has_uan', 0);
        $uan_number     = trim(v('uan_number'));
        $has_passport   = (int)v('has_passport', 0);
        $pan_number = trim(v('pan_number'));
        if ($pan_number === '') {
            $q = mysqli_query($conn, "SELECT pan_number FROM employee_applications WHERE id = " . (int)$id);
            $pan_number = mysqli_fetch_assoc($q)['pan_number'] ?? null;
        }
        $passport_number      = $has_passport ? v('passport_number') : '';
        $passport_issue_date  = ($has_passport && v('passport_issue_date') !== '') ? v('passport_issue_date') : NULL;
        $passport_place       = $has_passport ? v('passport_place_of_issue') : '';
        $passport_expiry      = ($has_passport && v('passport_expiry') !== '') ? v('passport_expiry') : NULL;

        $aadhar_number = trim(v('aadhar_number') ?? '');
        if ($aadhar_number !== '' && !preg_match('/^\d{12}$/', $aadhar_number)) {
            $_SESSION['flash_error'] = 'Enter a valid 12-digit Aadhar number (digits only).';
            header("Location: ?step=2");
            exit;
        }
        $sql = "UPDATE employee_applications SET 
              title=?, first_name=?, surname=?, gender=?, preferred_language=?, marital_status=?, dob=?, nationality=?, 
              country_of_birth=?, mobile=?, addr_line1=?, addr_line2=?, city=?, postal_code=?, country=?, state=?, 
              blood_group=?, religion=?, has_uan=?, uan_number=?, has_passport=?, passport_number=?, passport_issue_date=?, 
              passport_place_of_issue=?, passport_expiry=?, aadhar_number=?, pan_number=?,father_name=?, mother_name=?, date_of_marriage=?, spouse_name=?, 
              son_name=?, daughter_name=?, nominee_name=?, nominee_relation=?, nominee_dob=?, nominee_address=?, 
              emergency_name=?, emergency_mobile=?, emergency_landline=?, emergency_relation=?, 
              reference_1=?, reference_1_contact=?, reference_2=?, reference_2_contact=?, updated_at=NOW() WHERE id=?";

        $st = mysqli_prepare($conn, $sql);
        if (!$st) {
            die('Prepare failed (step2): ' . mysqli_error($conn));
        }
        $title          = $_POST['title'];       $first_name    = $_POST['first_name'];  $surname     = $_POST['surname'];
        $gender         = $_POST['gender'];      $dob           = $_POST['dob'];          $nationality = $_POST['nationality'];
        $country_of_birth = $_POST['country_of_birth']; $mobile = $_POST['mobile'];      $addr1       = $_POST['addr_line1'];
        $addr2          = $_POST['addr_line2'];
        $vars = [
        $title, $first_name, $surname, $gender, $preferred_lang, $marital_status, $dob, $nationality, $country_of_birth, $mobile,
        $addr1, $addr2, $city, $postal_code, $country, $state, $blood_group, $religion, $has_uan, $uan_number,
        $has_passport, $passport_number, $passport_issue_date, $passport_place, $passport_expiry, $aadhar_number, $pan_number,
        $father_name, $mother_name, $date_of_marriage, $spouse_name, $son_name, $daughter_name,
        $nominee_name, $nominee_relation, $nominee_dob, $nominee_address,
        $emergency_name, $emergency_mobile, $emergency_landline, $emergency_relation,
        $reference_1, $reference_1_contact, $reference_2, $reference_2_contact,
        $id
        ];
        $types = 'sssssssssssssssssssssssssssssssssssssssssssssi';
        if (strlen($types) !== count($vars)) {
            die("Mismatch: types length = " . strlen($types) . ", variables count = " . count($vars));
        }
        mysqli_stmt_bind_param(
        $st, $types,
        $title, $first_name, $surname, $gender, $preferred_lang, $marital_status, $dob, $nationality, $country_of_birth, $mobile,
        $addr1, $addr2, $city, $postal_code, $country, $state, $blood_group, $religion, $has_uan, $uan_number,
        $has_passport, $passport_number, $passport_issue_date, $passport_place, $passport_expiry, $aadhar_number, $pan_number,
        $father_name, $mother_name, $date_of_marriage, $spouse_name, $son_name, $daughter_name, $nominee_name, $nominee_relation, $nominee_dob, $nominee_address,
        $emergency_name, $emergency_mobile, $emergency_landline, $emergency_relation,
        $reference_1, $reference_1_contact, $reference_2, $reference_2_contact, $id);
        if (!mysqli_stmt_execute($st)) {
            die('Execute failed (step2): ' . mysqli_stmt_error($st));
        }
        header("Location: ?step=3");
        exit;
    }

    if ($step === 3) {
      ensure_dir($uploadBase);
      $pp_old = $app['passport_photo'] ?? null;
      $pan_card_old = $app['pan_card'] ?? null;
      $af_old = $app['aadhar_front'] ?? null;
      $ab_old = $app['aadhar_back'] ?? null;
      $passport_old = $app['passport_copy'] ?? null;
      $photo = save_file('passport_photo', ['jpg', 'jpeg', 'png'], $uploadBase, 500 * 1024);
      $pan_card = save_file('pan_card', ['jpg', 'jpeg', 'png', 'pdf'], $uploadBase, 500 * 1024);
      $passport = save_file('passport_copy', ['jpg', 'jpeg', 'png'], $uploadBase, 500 * 1024);
      $has_passport = (int) v('has_passport_hidden', 0);

      if ($has_passport === 1) {
          $a_front = null;
          $a_back = null;
      } else {
          $a_front = save_file('aadhar_front', ['jpg', 'jpeg', 'png', 'pdf'], $uploadBase, 500 * 1024);
          $a_back  = save_file('aadhar_back', ['jpg', 'jpeg', 'png', 'pdf'], $uploadBase, 500 * 1024);

          if ((!$af_old && !$a_front) || (!$ab_old && !$a_back)) {
              $_SESSION['flash_error'] = 'Aadhar front and back are mandatory.';
              header("Location: ?step=3");
              exit;
          }
      }
      $sql = "UPDATE employee_applications SET 
          passport_photo = IFNULL(?, passport_photo),
          aadhar_front = IFNULL(?, aadhar_front),
          aadhar_back = IFNULL(?, aadhar_back),
          pan_card = IFNULL(?, pan_card),
          passport_copy = IFNULL(?, passport_copy),
          updated_at = NOW() 
          WHERE id = ?";

      $st = mysqli_prepare($conn, $sql);
      if (!$st) {
          die('Prepare failed (step3): ' . mysqli_error($conn));
      }

      mysqli_stmt_bind_param($st, "sssssi", $photo, $a_front, $a_back, $pan_card, $passport, $id);

      if (!mysqli_stmt_execute($st)) {
          die('Execute failed (step3): ' . mysqli_stmt_error($st));
      }

      header("Location: ?step=4");
      exit;
  }
  if ($step === 4) {
    ensure_dir($uploadBase);
      $bank_doc_old = $app['bank_document'] ?? null;
      $bank_name = trim(v('bank_name'));
      $account_number = trim(v('account_number'));
      $ifsc_code = trim(v('ifsc_code'));
      $bank_document = save_file('bank_document', ['jpg', 'jpeg', 'png', 'pdf'], $uploadBase, 500 * 1024);
      if (empty($bank_name) || empty($account_number) || empty($ifsc_code)) {
          $_SESSION['flash_error'] = 'Please fill all the required bank details.';
          header("Location: ?step=4");
          exit;
      }
      $sql = "UPDATE employee_applications SET 
          bank_name = ?, 
          account_number = ?, 
          ifsc_code = ?, 
          bank_document = IFNULL(?, bank_document), 
          updated_at = NOW() 
          WHERE id = ?";
      $st = mysqli_prepare($conn, $sql);
      if (!$st) {
          die('Prepare failed (step4): ' . mysqli_error($conn));
      }
      mysqli_stmt_bind_param($st, "ssssi", $bank_name, $account_number, $ifsc_code, $bank_document, $id);

      if (!mysqli_stmt_execute($st)) {
          die('Execute failed (step4): ' . mysqli_stmt_error($st));
      }
      header("Location: ?step=5");
      exit;
  }

    if($step===5){
        ensure_dir($uploadBase);

        $sc_old = $app['ssc_certificate'] ?? null;
        $ic_old = $app['inter_certificate'] ?? null;
        $ugc_old = $app['ug_certificate'] ?? null;
        $pgc_old = $app['pg_certificate'] ?? null;
        $othc_old = $app['other_certificate'] ?? null;

        $ssc = save_file('ssc_certificate', ['jpg','jpeg','png','pdf'], $uploadBase, 500 * 1024);
        $inter = save_file('inter_certificate', ['jpg','jpeg','png','pdf'], $uploadBase, 500 * 1024);
        $ug = save_file('ug_certificate', ['jpg','jpeg','png','pdf'], $uploadBase, 500 * 1024);
        $pg = save_file('pg_certificate', ['jpg','jpeg','png','pdf'], $uploadBase, 500 * 1024);
        $other = save_file('other_certificate', ['jpg','jpeg','png','pdf'], $uploadBase, 500 * 1024);

        if(!$sc_old && !$ssc){ $_SESSION['flash_error']='10th Certificate upload is mandatory.'; header("Location: ?step=4"); exit; }
        if(!$ic_old && !$inter){ $_SESSION['flash_error']='12th Certificate upload is mandatory.'; header("Location: ?step=4"); exit; }

        // Collect into variables (refs) to fix "Only variables should be passed by reference"
        $ssc_year=v('ssc_year'); $ssc_school=v('ssc_school'); $ssc_board=v('ssc_board'); $ssc_grade=v('ssc_grade');

        $inter_year=v('inter_year'); $inter_school=v('inter_school'); $inter_board=v('inter_board'); $inter_grade=v('inter_grade');

        $grad_year = v('grad_year'); $grad_college = v('grad_college');$ug_stream = v('grad_degree_title');$grad_grade=v('grad_grade');
        $pg_year = v('pg_year'); $pg_college = v('pg_college');$pg_stream = v('pg_degree_title');$pg_grade=v('pg_grade');
        $other_qualification = v('other_qualification');

        $sql = "UPDATE employee_applications SET 
        ssc_year=?, ssc_school=?, ssc_board=?, ssc_grade=?, ssc_certificate=IFNULL(?, ssc_certificate),
        inter_year=?, inter_school=?, inter_board=?, inter_grade=?, inter_certificate=IFNULL(?, inter_certificate),
        grad_year=?, grad_college=?, grad_degree_title=?, grad_grade=?, ug_certificate=IFNULL(?, ug_certificate),
        pg_year=?, pg_college=?, pg_degree_title=?, pg_grade=?,  pg_certificate=IFNULL(?, pg_certificate),
        other_qualification=?, other_certificate=IFNULL(?, other_certificate),
        updated_at=NOW()
        WHERE id=?";
        $st=mysqli_prepare($conn,$sql);if(!$st){die('Prepare failed (step2): '.mysqli_error($conn));}
        // types: (i + 6s) + (i + 6s) + i  => 15 chars
       mysqli_stmt_bind_param(
        $st,
        "issssissssissssissssssi",
        $ssc_year, $ssc_school, $ssc_board, $ssc_grade, $ssc,
        $inter_year, $inter_school, $inter_board, $inter_grade, $inter,
        $grad_year, $grad_college, $ug_stream, $grad_grade, $ug,
        $pg_year, $pg_college, $pg_stream, $pg_grade, $pg,
        $other_qualification, $other,
        $id
      );
        if(!mysqli_stmt_execute($st)){die('Execute failed (step2): '.mysqli_stmt_error($st));}
        header("Location: ?step=6");exit;
    }

    if ($step === 6) {
        ensure_dir($uploadBase);
        $experience_letter = null;
        if (isset($_FILES['experience_letter']) && $_FILES['experience_letter']['error'] !== UPLOAD_ERR_NO_FILE) {
            $experience_letter = save_file('experience_letter', ['pdf', 'jpg', 'jpeg', 'png'], $uploadBase, 500 * 1024);
        }
        $salary_proof = null;$offer_letter = null;$salary_slip = null;$itr = null;$agreement = null;
        $optional_docs = ['salary_proof' => &$salary_proof,'offer_letter' => &$offer_letter,'salary_slip' => &$salary_slip,'itr' => &$itr,'agreement' => &$agreement];

        foreach ($optional_docs as $field_name => &$var) {
            if (isset($_FILES[$field_name]) && $_FILES[$field_name]['error'] !== UPLOAD_ERR_NO_FILE) {
                $var = save_file($field_name, ['pdf', 'jpg', 'jpeg', 'png'], $uploadBase, 500 * 1024);
            }
        }
        $sql = "UPDATE employee_applications SET 
                    experience_details = ?, 
                    experience_letter = IFNULL(?, experience_letter),
                    salary_proof = IFNULL(?, salary_proof),
                    offer_letter = IFNULL(?, offer_letter),
                    salary_slip = IFNULL(?, salary_slip),
                    itr = IFNULL(?, itr),
                    agreement = IFNULL(?, agreement),
                    updated_at = NOW()
                WHERE id = ?";
        $st = mysqli_prepare($conn, $sql);
        if (!$st) {
            die('Prepare failed (step2.3): ' . mysqli_error($conn));
        }
        $apps = v('experience_details');
        mysqli_stmt_bind_param($st, "sssssssi", $apps, $experience_letter, $salary_proof, $offer_letter, $salary_slip, $itr, $agreement, $id);
        if (!mysqli_stmt_execute($st)) {
            die('Execute failed (step2.3): ' . mysqli_stmt_error($st));
        }
        header("Location: ?step=7");
        exit;
    }

    if($step===7 && isset($_POST['final_submit']) && $_POST['final_submit']=='1'){
        $sql="UPDATE employee_applications SET application_status='submitted',submitted_at=NOW(),updated_at=NOW() WHERE id=?";
        $st=mysqli_prepare($conn,$sql);if(!$st){die('Prepare failed (final): '.mysqli_error($conn));}
        mysqli_stmt_bind_param($st,"i",$id);
        if(!mysqli_stmt_execute($st)){die('Execute failed (final): '.mysqli_stmt_error($st));}

        $qry=mysqli_prepare($conn,"SELECT first_name,surname FROM employee_applications WHERE id=?");
        mysqli_stmt_bind_param($qry,"i",$id); mysqli_stmt_execute($qry); $rs=mysqli_stmt_get_result($qry);
        $row=$rs?mysqli_fetch_assoc($rs):null; $name=trim(($row['first_name']??'').' '.($row['surname']??''));
        @send_confirmation_email($email,$name ?: 'Applicant');

        header("Location: ?step=7");exit;
    }
}

/* ---- view ---- */
$names=explode(' ',$_SESSION['employee_name']??'');$firstName=$names[0]??'';$surname=$names[1]??'';
$isSubmitted=(($app['application_status']??'')==='submitted');
$labels=['Pre Application Form', 'Personal Details','Identity & Photo', 'Bank details', 'Academics','Experience Letter','Preview'];
$percent = ($step<=1)?0:round((($step-1)/6)*100);

// derive Language select/value for "Others"
$prefSaved = $app['preferred_language'] ?? '';$langs = array_map('trim', explode(',', $prefSaved));
$standardLangs = ['English', 'Hindi', 'Others'];$prefIsOther = count(array_filter($langs, fn($l) => !in_array($l, $standardLangs))) > 0;
$prefSelectValue = $prefIsOther ? 'Others' : $prefSaved;
$prefOtherValue  = $prefIsOther ? $prefSaved : '';
if (!is_array($prefSelectValue)) {
    $prefSelectValue = array_map('trim', explode(',', $prefSelectValue));
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Employee Form</title>
<link rel="shortcut icon" type="image/jpg" href="<?= defined('BASE_URL')?BASE_URL:'' ?>assets/images/logos/favicon.jpg"/>
<link rel="stylesheet" href="<?= defined('BASE_URL')?BASE_URL:'' ?>assets/css/styles.min.css"/>
<style>
:root{ --accent:#A5E51C; --done:#a5e51c; --todo:#e9eef5; --curr:#09f; }
.err-icon{display:inline-flex;align-items:center;justify-content:center;width:18px;height:18px;border-radius:50%;background:#ff5a8b;color:#fff;font-size:12px;margin-left:6px;cursor:pointer;vertical-align:middle}
.err-pop{position:absolute;z-index:10;background:#fff;border:1px solid #f5a0b8;box-shadow:0 4px 12px rgba(0,0,0,.08);padding:8px 10px;border-radius:8px;max-width:280px;font-size:12px;color:#b0003a}
.help-wrap{position:relative}
.d-none{display:none!important}
.locked{pointer-events:none;background:#f8f9fa;opacity:.9}
.btn-file{background:var(--accent);border:none;color:#0f2a00;font-weight:600}
.btn-file:hover{filter:brightness(.95)}
.badge-accent{background:var(--accent);color:#0f2a00;font-weight:700}

/* Wizard progress (fix cut top) */
.wizard{margin:0 0 14px 0}
.wizard-bar{position:relative;height:10px;background:var(--todo);border-radius:8px;overflow:visible}
.wizard-fill{position:absolute;left:0;top:0;height:100%;background:linear-gradient(90deg,var(--done),#7fd012);border-radius:8px;transition:width .4s ease}
.wizard-steps{position:absolute;left:-2px;right:-2px;top:-6px;display:flex;justify-content:space-between}
.wizard-step{width:20px;height:20px;border-radius:50%;background:#dfe7f2;border:2px solid #fff;box-shadow:0 0 0 2px #dfe7f2}
.wizard-step.done{background:var(--done);box-shadow:0 0 0 2px var(--done)}
.wizard-step.curr{background:var(--curr);box-shadow:0 0 0 2px var(--curr)}
.wizard-labels{display:flex;justify-content:space-between;margin-top:6px;font-weight:700}
.wizard-hint{color:#667085;font-size:.9rem;margin-top:4px}

/* Thank-you banner & resume layout */
.ty-banner{border:1px solid #e6f7da;background:#f6ffed;border-radius:12px;padding:14px 16px;margin-bottom:16px}
.ty-banner .big{font-weight:800}
.ty-flex{display:flex;gap:12px;align-items:flex-start}

.resume{display:grid;grid-template-columns:minmax(240px,360px) 1fr;gap:22px;border:1px solid #e5e7eb;border-radius:14px;overflow:hidden}
.resume .left{background:#0e3a5f;color:#fff;padding:24px}
.resume .right{padding:28px;background:#fff}
.resume .avatar{width:150px;height:150px;border-radius:12px;object-fit:cover;border:3px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,.2)}
.resume .name{font-size:22px;font-weight:700;letter-spacing:.5px;margin-top:14px;line-height:1.2}
.resume .role{opacity:.9;margin-bottom:14px}
.resume .blk{margin-top:18px}
.resume .blk h6{font-size:13px;text-transform:uppercase;letter-spacing:1px;color:#cbe3ff;margin:0 0 8px 0}
.resume .blk .item{font-size:13px;margin:6px 0;word-break:break-word}
.resume .line{height:1px;background:#eaecef;margin:18px 0}
.resume .sec{margin-bottom:8px}

/* Attachments grid + print rules */
.print-only{display:none}
.attach-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:16px}
.attach-card{border:1px solid #e5e7eb;padding:10px;border-radius:10px;background:#fff}
.attach-card img{width:100%;height:220px;object-fit:contain;border-radius:8px;border:1px solid #eee}
.custom-multiselect {position: relative;width: 220px;font-family: Arial, sans-serif;}
.custom-multiselect .select-box {border: 1px solid #ced4da;border-radius: 4px;padding: 8px 10px;background: white; cursor: pointer;user-select: none;}
.custom-multiselect .options-container {position: absolute;top: 100%;left: 0;width: 100%;border: 1px solid #ced4da;border-radius: 0 0 4px 4px;background: white;max-height: 150px; overflow-y: auto;box-shadow: 0 2px 6px rgba(0,0,0,0.15);display: none;z-index: 999;}
.custom-multiselect.open .options-container {display: block;}.custom-multiselect label { display: flex;align-items: center;padding: 5px 10px;cursor: pointer;}
.custom-multiselect input[type="checkbox"] {margin-right: 8px;}#preferred_language_other { margin-top: 8px;}
/* Print (A4) */
@media print{
  @page { size: A4; margin: 8mm; }
  *{-webkit-print-color-adjust:exact; print-color-adjust:exact}
  body *{visibility:hidden !important}
  #printPreview, #printPreview *{visibility:visible !important}
  #printAttachments, #printAttachments *{visibility:visible !important}
  #printPreview{position:relative;left:0;top:0;width:190mm}
  #printAttachments{page-break-before:always;width:190mm}
}
</style>
</head>
<body>
<div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full" data-sidebar-position="fixed" data-header-position="fixed">
<?php include __DIR__."/../partials/header.php"; include __DIR__."/../partials/sidebar.php"; ?>
<div class="body-wrapper">
<div class="container-fluid mt-4"><div class="card shadow-sm border-0 rounded-3"><div class="card-body">
<h3 class="mb-3">Employee Application Form</h3>

<div class="d-flex align-items-center gap-3 mb-1">
  <div class="flex-grow-1 wizard">
    <?php if ($showWizard): ?>
      <div class="wizard-bar">
        <div class="wizard-fill" style="width: <?= $percent ?>%"></div>
        <div class="wizard-steps">
          <?php for($i=1; $i<=7; $i++): 
            $cls = ($i < $step) ? 'done' : (($i == $step) ? 'curr' : ''); ?>
            <span class="wizard-step <?= $cls ?>"></span>
          <?php endfor; ?>
        </div>
      </div>

      <div class="wizard-labels">
        <?php foreach($labels as $i => $lab): ?>
          <span class="<?= ($i+1 == $step) ? 'text-dark' : 'text-secondary' ?>"><?= $lab ?></span>
        <?php endforeach; ?>
      </div>

      <div class="wizard-hint">
        <?php if ($step < 7): ?>
          <?= $percent ?>% complete — Next: <b><?= $labels[$step] ?></b>
        <?php else: ?>
          100% complete — Review & Print your application.
        <?php endif; ?>
      </div>
      <span class="badge bg-primary-subtle text-primary rounded-pill px-3 py-2">Step <?= $step ?>/7</span>
    <?php endif; ?>
  </div>
</div>

<?php if(isset($_SESSION['flash_error'])): ?>
<div class="alert alert-danger mt-3"><?= htmlspecialchars($_SESSION['flash_error']); unset($_SESSION['flash_error']); ?></div>
<?php endif; ?>
<?php if ($step === 1): ?>
<div class="container position-relative">
  <?php if (!$isSubmitted): ?>
    <?php if (
        $showApprovalPendingMessage ||
        (is_string($pre_app_status) && strtolower($pre_app_status) === 'rejected') ||
        (is_string($pre_app_status) && strtolower($pre_app_status) === 'pending')): ?>
        <div class="alert alert-info">
            Your application status is <strong><?= htmlspecialchars($pre_app_status) ?></strong>.<br>
            <?php if (is_string($pre_app_status) && strtolower($pre_app_status) === 'rejected'): ?>
                Your application has been <strong>rejected</strong>. You cannot proceed further.
            <?php elseif (is_string($pre_app_status) && strtolower($pre_app_status) === 'pending'): ?>
                You cannot proceed until your application is approved.<br>
                Waiting for approval.
            <?php endif; ?>
        </div>
    <?php else: ?>
  <form method="POST" class="needs-validation row g-3" novalidate enctype="multipart/form-data">
    <div class="d-flex align-items-center">
      <h3 class="mb-0">Application Initial Details</h3>
      <h5 class="mb-0 ms-3">Position Applied For</h5>
    </div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">Resume (PDF/DOC) <?= empty($app['resume']) ? '<span class="text-danger">*</span>' : '' ?></label>
      <?php if (!empty($app['resume'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['resume']) ?>">View uploaded resume</a>
      <?php endif; ?>
      <input type="file" name="resume" id="resume" class="form-control" accept=".pdf,.doc,.docx" <?= empty($pre_app['resume']) ? 'required' : '' ?>>
    <div class="form-text text-muted">Maximum file size: 500 KB</div>
    </div>

    <div class="col-md-4">
      <label for="appliedfor" class="form-label">Select Position</label>
      <select id="appliedfor" name="appliedfor" class="form-control" required>
        <option value="">--Select--</option>
        <option value="Sales" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sales') ? 'selected' : '' ?>>Sales</option>
        <option value="Back Office" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Back Office') ? 'selected' : '' ?>>Back Office</option>
        <option value="Internship" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Internship') ? 'selected' : '' ?>>Internship</option>
        <option value="Sr. Executive / Executive - TA HR" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sr. Executive / Executive - TA HR') ? 'selected' : '' ?>>Sr. Executive / Executive - TA HR</option>
        <option value="Team Leader - Customer Care" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Team Leader - Customer Care') ? 'selected' : '' ?>>Team Leader - Customer Care</option>
        <option value="Sr. Executive - Customer Care" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sr. Executive - Customer Care') ? 'selected' : '' ?>>Sr. Executive - Customer Care</option>
        <option value="Sr. Executive - KYC" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sr. Executive - KYC') ? 'selected' : '' ?>>Sr. Executive - KYC</option>
        <option value="Sr. Executive - Graphic Desinger" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sr. Executive - Graphic Desinger') ? 'selected' : '' ?>>Sr. Executive - Graphic Desinger</option>
        <option value="Sr. Executive - Revenue Assurance" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sr. Executive - Revenue Assurance') ? 'selected' : '' ?>>Sr. Executive - Revenue Assurance</option>
        <option value="Executive - Sales Operation" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Executive - Sales Operation') ? 'selected' : '' ?>>Executive - Sales Operation</option>
        <option value="Sr. Executive - Operation HR" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sr. Executive - Operation HR') ? 'selected' : '' ?>>Sr. Executive - Operation HR</option>
        <option value="Sr. Project Manager" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Sr. Project Manager') ? 'selected' : '' ?>>Sr. Project Manager</option>
        <option value="Manager Billing" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Manager Billing') ? 'selected' : '' ?>>Manager Billing</option>
        <option value="Foreman" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Foreman') ? 'selected' : '' ?>>Foreman</option>
        <option value="Store Keeper" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Store Keeper') ? 'selected' : '' ?>>Store Keeper</option>
        <option value="Electrician" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Electrician') ? 'selected' : '' ?>>Electrician</option>
        <option value="Supervisor" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Supervisor') ? 'selected' : '' ?>>Supervisor</option>
        <option value="Others" <?= (isset($pre_app['appliedfor']) && $pre_app['appliedfor'] == 'Others') ? 'selected' : '' ?>>Others</option>
      </select>
    </div>

    <div class="col-md-4">
      <label for="current_salary" class="form-label">Current Salary (per month)</label>
      <select class="form-control" name="current_salary" id="current_salary" required>
        <option value="">--Select Salary--</option>
        <?php
          $salary_options = [
            'Fresher',
            '05 Thousands',
            '06-10 Thousands',
            '11-15 Thousands',
            '16-20 Thousands',
            '21-25 Thousands',
            '26-30 Thousands',
            '31-35 Thousands',
            '36-40 Thousands',
            '41-50 Thousands',
            '51-60 Thousands',
            '61-70 Thousands',
            '71-80 Thousands',
            '81-90 Thousands',
            '91-99 Thousands',
            '01 Lacs',
            '02 Lacs',
            '03 Lacs',
            '04 Lacs',
            '05+ Lacs'
          ];

          $selected_salary = $pre_app['current_salary'] ?? '';

          foreach ($salary_options as $option) {
              $selected = ($selected_salary === $option) ? 'selected' : '';
              $safe_option = htmlspecialchars($option, ENT_QUOTES, 'UTF-8');
              echo "<option value=\"$safe_option\" $selected>$safe_option</option>";
          }
        ?>
      </select>
    </div>

    <div class="col-md-4">
      <label for="expected_salary" class="form-label">Expected Salary (per month)</label>
      <select class="form-control" name="expected_salary" id="expected_salary" required>
        <option value="">--Select Salary--</option>
        <?php
          $salary_options = [
            'Fresher',
            '05 Thousands',
            '06-10 Thousands',
            '11-15 Thousands',
            '16-20 Thousands',
            '21-25 Thousands',
            '26-30 Thousands',
            '31-35 Thousands',
            '36-40 Thousands',
            '41-50 Thousands',
            '51-60 Thousands',
            '61-70 Thousands',
            '71-80 Thousands',
            '81-90 Thousands',
            '91-99 Thousands',
            '01 Lacs',
            '02 Lacs',
            '03 Lacs',
            '04 Lacs',
            '05+ Lacs'
          ];
          $selected_expected_salary = $app['expected_salary'] ?? '';

          foreach ($salary_options as $option) {
              $safe_option = htmlspecialchars($option, ENT_QUOTES, 'UTF-8');
              $selected = ($selected_expected_salary === $option) ? 'selected' : '';
              echo "<option value=\"$safe_option\" $selected>$safe_option</option>";
          }
        ?>
      </select>
    </div>

    <div class="col-md-4">
      <label for="highest_qualification" class="form-label">Highest Qualification</label>
      <select id="highest_qualification" name="highest_qualification" class="form-control" required>
        <option value="">--Select--</option>
        <?php
          $qualifications = [
            "High School", "Intermediate", "Diploma", "Undergraduate",
            "Graduate", "Postgraduate", "PhD", "Others"
          ];
          $selectedQual = $pre_app['qualification'] ?? '';
          foreach ($qualifications as $qual) {
              $selected = ($selectedQual === $qual) ? 'selected' : '';
              echo "<option value=\"$qual\" $selected>$qual</option>";
          }
        ?>
      </select>
    </div>
      <div class="col-md-4">
        <label for="totalExp" class="form-label">Total Work Experience (years)</label>
        <select class="form-control" name="totalExp" id="totalExp" onchange="toggleWorkExpFields()" required>
          <option value="">--Select Work Exp--</option>
          <?php 
            $expOptions = [
              "Internship", "Fresher", "06-12 Months", "02 Years", "03 Years", "04 Years", "05 Years",
              "06 Years", "07 Years", "08 Years", "09 Years", "10 Years", "11-15 Years", "16-20 Years",
              "21-25 Years", "26-30 Years", "30+ Years"
            ];
            $selectedExp = $pre_app['totalExp'] ?? '';
            foreach ($expOptions as $option) {
                $selected = ($selectedExp === $option) ? 'selected' : '';
                echo "<option value=\"$option\" $selected>$option</option>";
            }
          ?>
        </select>
      </div>

      <div id="workExpDetails" class="row g-3">
        <div class="col-md-4">
          <label for="notice_period_days" class="form-label">Notice Period (in days)</label>
          <input type="number" id="notice_period_days" name="notice_period_days" class="form-control" value="<?= htmlspecialchars($pre_app['notice_period'] ?? '') ?>">
        </div>

        <div class="col-md-4">
          <label for="last_organisation" class="form-label">Current/Last Organization</label>
          <input type="text" id="last_organisation" name="last_organisation" class="form-control" value="<?= htmlspecialchars($pre_app['lastorg'] ?? '') ?>">
        </div>

        <div class="col-md-4">
          <label for="designation" class="form-label">Current/Last Designation</label>
          <input type="text" id="designation" name="designation" class="form-control" value="<?= htmlspecialchars($pre_app['last_designation'] ?? '') ?>">
        </div>

        <div class="col-md-4">
          <label for="job_type" class="form-label">Job Type</label>
          <select id="job_type" name="job_type" class="form-select">
            <option value="">Select</option>
            <option value="Full-time" <?= (isset($pre_app['jobType']) && $pre_app['jobType'] == 'Full-time') ? 'selected' : '' ?>>Full-time</option>
            <option value="Part-time" <?= (isset($pre_app['jobType']) && $pre_app['jobType'] == 'Part-time') ? 'selected' : '' ?>>Part-time</option>
            <option value="Contract" <?= (isset($pre_app['jobType']) && $pre_app['jobType'] == 'Contract') ? 'selected' : '' ?>>Contract</option>
            <option value="Internship" <?= (isset($pre_app['jobType']) && $pre_app['jobType'] == 'Internship') ? 'selected' : '' ?>>Internship</option>
          </select>
        </div>

        <div class="col-md-4">
          <label for="reason_for_leaving" class="form-label">Reason for Leaving</label>
          <textarea id="reason_for_leaving" name="reason_for_leaving" class="form-control"><?= htmlspecialchars($pre_app['reason'] ?? '') ?></textarea>
        </div>

        <div class="col-md-4">
          <label for="lastOrgEmail" class="form-label">Current/Last Org Email:</label>
          <input type="email" id="lastOrgEmail" name="lastOrgEmail" class="form-control" value="<?= htmlspecialchars($pre_app['lastOrgEmail'] ?? '') ?>">
        </div>
      </div>

    <div class="col-md-4">
      <label for="gender" class="form-label">Gender</label>
      <select id="gender" name="gender" class="form-control" required>
        <option value="">--Select--</option>
        <option value="Male" <?= ($pre_app['gender'] ?? '') === 'Male' ? 'selected' : '' ?>>Male</option>
        <option value="Female" <?= ($pre_app['gender'] ?? '') === 'Female' ? 'selected' : '' ?>>Female</option>
        <option value="Others" <?= ($pre_app['gender'] ?? '') === 'Others' ? 'selected' : '' ?>>Others</option>
      </select>
    </div>

    <div class="col-md-4">
      <label for="marital_status" class="form-label">Marital Status</label>
      <select id="marital_status" name="marital_status" class="form-control" required>
        <option value="">--Select--</option>
        <option value="Single" <?= ($pre_app['marital_status'] ?? '') === 'Single' ? 'selected' : '' ?>>Single</option>
        <option value="Married" <?= ($pre_app['marital_status'] ?? '') === 'Married' ? 'selected' : '' ?>>Married</option>
		    <option value="Divorced" <?= ($pre_app['marital_status'] ?? '') === 'Divorced' ? 'selected' : '' ?>>Divorced</option>
        <option value="Widowed" <?= ($pre_app['marital_status'] ?? '') === 'Widowed' ? 'selected' : '' ?>>Widowed</option>
		    <option value="Other" <?= ($pre_app['marital_status'] ?? '') === 'Other' ? 'selected' : '' ?>>Other</option>
      </select>
    </div>

    <div class="col-md-4">
      <label for="dob" class="form-label">Date of Birth</label>
      <input type="date" id="dob" name="dob" class="form-control" required value="<?= $pre_app['dob'] ?? '' ?>">
    </div>

    <div class="col-md-6">
      <label for="current_address" class="form-label">Current Address</label>
      <input type="text" id="current_address" name="current_address" class="form-control" value="<?= htmlspecialchars($pre_app['currentAddress'] ?? '') ?>" required>
    </div>

    <div class="col-md-6">
      <label for="current_city" class="form-label">Current City</label>
      <input type="text" id="current_city" name="current_city" class="form-control" value="<?= htmlspecialchars($pre_app['currentCity'] ?? '') ?>" required>
    </div>

    <div class="col-md-4">
      <label for="vacancy_source" class="form-label">How did you come to know about the vacancy?</label>
      <select id="vacancy_source" name="vacancy_source" class="form-select" required onchange="toggleOtherVacancySource(this.value)">
        <option value="">Select</option>
        <option value="Naukri.com" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='Naukri.com') ? 'selected' : '' ?>>Naukri.com</option>
        <option value="Apna.co" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='Apna.co') ? 'selected' : '' ?>>Apna.co</option>
        <option value="Lead" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='Lead') ? 'selected' : '' ?>>Lead</option>
        <option value="Indeed" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='Indeed') ? 'selected' : '' ?>>Indeed</option>
        <option value="LinkedIn" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='LinkedIn') ? 'selected' : '' ?>>LinkedIn</option>
        <option value="Hirect.in" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='Hirect.in') ? 'selected' : '' ?>>Hirect.in</option>
        <option value="HR Reference" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='HR Reference') ? 'selected' : '' ?>>HR Reference</option>
        <option value="Other" <?= (isset($pre_app['know_about']) && $pre_app['know_about']=='Other') ? 'selected' : '' ?>>Other</option>
      </select> 
      <input type="text" id="vacancy_source_other" name="vacancy_source_other" class="form-control mt-2 <?= (isset($pre_app['others']) && $pre_app['others']=='Other') ? '' : 'd-none' ?>" placeholder="Please specify" value="<?= htmlspecialchars($pre_app['vacancy_source_other'] ?? '') ?>">
    </div>

    <div class="col-md-4">
      <label class="form-label">Any employee known to you working here?</label><br>

      <input type="radio" name="known_employee" id="known_employee_yes" value="Yes"
        <?= (isset($pre_app['ref']) && $pre_app['ref'] === 'Yes') ? 'checked' : '' ?>
        onchange="toggleKnownEmployeeName(true)">
      <label for="known_employee_yes">Yes</label>

      <input type="radio" name="known_employee" id="known_employee_no" value="No"
        <?= (!isset($pre_app['ref']) || $pre_app['ref'] === 'No') ? 'checked' : '' ?>
        onchange="toggleKnownEmployeeName(false)">
      <label for="known_employee_no">No</label>

      <div id="known_employee_name_div" style="margin-top:10px; display: <?= (isset($pre_app['ref']) && $pre_app['ref'] === 'Yes') ? 'block' : 'none' ?>;">
        <label for="known_employee_name" class="form-label">Name of Known Employee</label>
        <input type="text" id="known_employee_name" name="known_employee_name" class="form-control"
          value="<?= htmlspecialchars($pre_app['refname'] ?? '') ?>">
      </div>
    </div>
      <?php
        $hr_query = mysqli_query($conn, "SELECT empid, hrName FROM admin_hr ORDER BY hrName ASC");
        $hr_list = [];
        while ($row = mysqli_fetch_assoc($hr_query)) {
            $hr_list[] = $row;
        }
      ?>
      <div class="col-md-4">
        <label for="recruiter_name" class="form-label">Select HR</label>
        <select name="recruiter_name" id="recruiter_name" class="form-control">
          <option value="">-- Select HR --</option>
          <?php foreach ($hr_list as $hr): ?>
            <option value="<?= $hr['empid'] ?>" <?= (isset($pre_app['recruiter_name']) && $pre_app['recruiter_name'] == $hr['empid']) ? 'selected' : '' ?>>
              <?= htmlspecialchars($hr['hrName']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

    <div class="col-12">
      <h5>Have you ever been an employee here?</h5>
      <div>
        <input type="radio" name="empl" id="ever_employee_yes" value="Yes"
            <?= (isset($pre_app['empl']) && $pre_app['empl'] === 'Yes') ? 'checked' : '' ?>
            onclick="togglePreviousEmployment(true)">
        <label for="ever_employee_yes">Yes</label>

        <input type="radio" name="empl" id="ever_employee_no" value="No"
            <?= (!isset($pre_app['empl']) || $pre_app['empl'] === 'No') ? 'checked' : '' ?>
            onclick="togglePreviousEmployment(false)">
        <label for="ever_employee_no">No</label>
      </div>
    </div>

    <div class="col-12" id="previous_employment_fields"
     style="display: <?= (isset($pre_app['empl']) && $pre_app['empl'] === 'Yes') ? 'block' : 'none' ?>;">
      <div class="row g-3">
        <div class="col-md-4">
          <label for="prev_department" class="form-label">Department</label>
          <input type="text" id="prev_department" name="prev_department" class="form-control" value="<?= htmlspecialchars($pre_app['earlier_team'] ?? '') ?>">
        </div>
        <div class="col-md-4">
          <label for="earlier_employment" class="form-label">Period of Employment</label>
          <input type="text" id="earlier_employment" name="earlier_employment" class="form-control"
              value="<?= htmlspecialchars($pre_app['earlier_employment'] ?? '') ?>">
        </div>
        <div class="col-md-4">
          <label for="prev_position" class="form-label">Position</label>
          <input type="text" id="prev_position" name="prev_position" class="form-control" value="<?= htmlspecialchars($pre_app['earlier_position'] ?? '') ?>">
        </div>
        <div class="col-md-12">
          <label for="prev_reason_for_leaving" class="form-label">Reason for Leaving</label>
          <textarea id="prev_reason_for_leaving" name="prev_reason_for_leaving" class="form-control"><?= htmlspecialchars($pre_app['earlier_leaving'] ?? '') ?></textarea>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <label for="conveyance" class="form-label">Do you have your own conveyance?</label><br>
      <input type="radio" name="conveyance" value="Yes" <?= ($pre_app['conveyance'] ?? '') === 'Yes' ? 'checked' : '' ?> onchange="toggleConveyanceType(true)"> Yes
      <input type="radio" name="conveyance" value="No" <?= ($pre_app['conveyance'] ?? '') === 'No' ? 'checked' : '' ?> onchange="toggleConveyanceType(false)"> No
    </div>

    <div class="col-md-4" id="conveyance_type_div" style="display: <?= ($pre_app['conveyance'] ?? '') === 'Yes' ? 'block' : 'none' ?>;">
      <label for="conveyance_type" class="form-label">If Yes, Type:</label><br>
      <input type="radio" name="conveyance_type" value="Two Wheeler" <?= ($pre_app['convyes'] ?? '') === 'Two Wheeler' ? 'checked' : '' ?>> Two Wheeler
      <input type="radio" name="conveyance_type" value="Four Wheeler" <?= ($pre_app['convyes'] ?? '') === 'Four Wheeler' ? 'checked' : '' ?>> Four Wheeler
    </div>
   <div class="col-md-4">
    <label for="own_device" class="form-label">Do you have your own mobile or laptop?</label><br>
    <input type="radio" id="device_yes" name="own_device" value="Yes" <?= ($pre_app['own_device'] ?? '') === 'Yes' ? 'checked' : '' ?> onchange="toggleDeviceOptions(true)"> 
    <label for="device_yes">Yes</label> <input type="radio" id="device_no" name="own_device" value="No" <?= ($pre_app['own_device'] ?? '') === 'No' ? 'checked' : '' ?> onchange="toggleDeviceOptions(false)"><label for="device_no">No</label>
  </div>

  <div class="col-md-4" id="device_type_div" style="display: <?= ($pre_app['own_device'] ?? '') === 'Yes' ? 'block' : 'none' ?>;">
    <label for="device_type" class="form-label">If Yes, select device type:</label><br>

    <input type="radio" id="device_mobile" name="device_type" value="Mobile" 
      <?= ($pre_app['device_type'] ?? '') === 'Mobile' ? 'checked' : '' ?>>
    <label for="device_mobile">Mobile</label>

    <input type="radio" id="device_laptop" name="device_type" value="Laptop" 
      <?= ($pre_app['device_type'] ?? '') === 'Laptop' ? 'checked' : '' ?>>
    <label for="device_laptop">Laptop</label>

    <input type="radio" id="device_both" name="device_type" value="Mobile and Laptop" 
      <?= ($pre_app['device_type'] ?? '') === 'Mobile and Laptop' ? 'checked' : '' ?>>
    <label for="device_both">Mobile and Laptop</label>
  </div>
    <div class="col-12">
      <button type="submit" class="btn btn-primary mt-3">Submit</button>
    </div>
  </form>
    <?php endif; ?>
    <?php endif; ?>
</div>

<script>
  function togglePreviousEmployment(show) {
    document.getElementById('previous_employment_fields').style.display = show ? 'block' : 'none';
  }
  function toggleConveyanceType(show) {
    const conveyanceTypeDiv = document.getElementById('conveyance_type_div');
    conveyanceTypeDiv.style.display = show ? 'block' : 'none';
  }
  function toggleKnownEmployeeName(isYes) {
    const nameDiv = document.getElementById('known_employee_name_div');
    nameDiv.style.display = isYes ? 'block' : 'none';
  }
  window.onload = function () {
    const isYesChecked = document.getElementById('ever_employee_yes')?.checked;
    togglePreviousEmployment(isYesChecked);
    const conveyanceVal = document.querySelector('input[name="conveyance"]:checked')?.value;
    toggleConveyanceType(conveyanceVal === 'Yes');
  };
  function toggleWorkExpFields() {
  const exp = document.getElementById('totalExp').value;
  const hiddenFields = document.querySelectorAll('#workExpDetails input, #workExpDetails select, #workExpDetails textarea');
  const container = document.getElementById('workExpDetails');
  const isFresher = (exp === 'Fresher' || exp === 'Internship');
  container.style.display = isFresher ? 'none' : 'flex';
  hiddenFields.forEach(field => {
    if (isFresher) {
      field.removeAttribute('required');
    } else {
      field.setAttribute('required', 'required');
    }
  });
}
function toggleDeviceOptions(show) {
    const div = document.getElementById('device_type_div');
    div.style.display = show ? 'block' : 'none';
    if (!show) {
      const radios = document.getElementsByName('device_type');
      radios.forEach(radio => radio.checked = false);
    }
  }
document.addEventListener('DOMContentLoaded', function () {
  toggleWorkExpFields();
});
</script>



<?php endif; ?>
<?php if($step===2 && $isSubmitted===false): ?>

<form method="POST" class="needs-validation mt-3" novalidate>
<h5 class="mb-3">1.1 Personal Details</h5>
<div class="row g-3">
  <div class="col-md-3 help-wrap"><label class="form-label">Title</label><select name="title" class="form-select" required><option value="">Select</option><option <?= (($app['title']??'')==='Mr')?'selected':''; ?>>Mr</option><option <?= (($app['title']??'')==='Ms')?'selected':''; ?>>Ms</option><option <?= (($app['title']??'')==='Mrs')?'selected':''; ?>>Mrs</option><option <?= (($app['title']??'')==='Dr')?'selected':''; ?>>Dr</option><option <?= (($app['title']??'')==='Other')?'selected':''; ?>>Other</option></select></div>
  <div class="col-md-3 help-wrap"><label class="form-label">First Name</label><input type="text" name="first_name" class="form-control" value="<?= htmlspecialchars($app['first_name']??$firstName) ?>" required></div>
  <div class="col-md-3 help-wrap"><label class="form-label">Surname</label><input type="text" name="surname" class="form-control" value="<?= htmlspecialchars($app['surname']??$surname) ?>" required></div>
  <div class="col-md-3 help-wrap"><label class="form-label">Gender</label><select class="form-select" disabled><option value="">Select</option><option value="Male" <?= (($pre_app1['gender'] ?? '') === 'Male') ? 'selected' : ''; ?>>Male</option><option value="Female" <?= (($pre_app1['gender'] ?? '') === 'Female') ? 'selected' : ''; ?>>Female</option><option value="Other" <?= (($pre_app1['gender'] ?? '') === 'Other') ? 'selected' : ''; ?>>Other</option></select><input type="hidden" name="gender" value="<?= htmlspecialchars($pre_app1['gender'] ?? '') ?>"></div>
  <div class="col-md-3 help-wrap mt-3">
    <label class="form-label">Blood Group</label>
    <select id="blood_group" name="blood_group" class="form-select" required>
      <option value="">Select</option>
      <option <?= (($app['blood_group'] ?? '') === 'A+') ? 'selected' : ''; ?>>A+</option>
      <option <?= (($app['blood_group'] ?? '') === 'A-') ? 'selected' : ''; ?>>A-</option>
      <option <?= (($app['blood_group'] ?? '') === 'B+') ? 'selected' : ''; ?>>B+</option>
      <option <?= (($app['blood_group'] ?? '') === 'B-') ? 'selected' : ''; ?>>B-</option>
      <option <?= (($app['blood_group'] ?? '') === 'AB+') ? 'selected' : ''; ?>>AB+</option>
      <option <?= (($app['blood_group'] ?? '') === 'AB-') ? 'selected' : ''; ?>>AB-</option>
      <option <?= (($app['blood_group'] ?? '') === 'O+') ? 'selected' : ''; ?>>O+</option>
      <option <?= (($app['blood_group'] ?? '') === 'O-') ? 'selected' : ''; ?>>O-</option>
    </select>
  </div>
  <!-- Language BEFORE Proficiency -->
  <div class="col-md-3 help-wrap">
    <label class="form-label">Language</label>
    <div class="custom-multiselect" id="multiLangSelect">
      <div class="select-box" id="selectBoxDisplay">Select languages</div>
      <div class="options-container">
        <label><input type="checkbox" name="preferred_language[]" value="English" <?= (is_array($prefSelectValue) && in_array('English', $prefSelectValue)) ? 'checked' : '' ?>> English</label>
        <label><input type="checkbox" name="preferred_language[]" value="Hindi" <?= (is_array($prefSelectValue) && in_array('Hindi', $prefSelectValue)) ? 'checked' : '' ?>> Hindi</label>
        <label><input type="checkbox" id="lang_others" name="preferred_language[]" value="Others" <?= (is_array($prefSelectValue) && in_array('Others', $prefSelectValue)) ? 'checked' : '' ?>> Others</label>
      </div>
    </div>
    <input type="text" id="preferred_language_other" name="preferred_language_other" class="form-control mt-2 <?= (is_array($prefSelectValue) && in_array('Others', $prefSelectValue)) ? '' : 'd-none' ?>" placeholder="Type language" value="<?= htmlspecialchars($prefOtherValue) ?>">
  </div>
  <div class="col-md-3 help-wrap"><label class="form-label">Email Address</label><input type="email" class="form-control" value="<?= htmlspecialchars($email) ?>" disabled></div>
  <div class="col-md-3 help-wrap"><label class="form-label">Date of Birth</label><input type="date" name="dob" class="form-control" value="<?= htmlspecialchars($pre_app1['dob']??'') ?>" readonly></div>
  <div class="col-md-3 help-wrap mt-3">
    <label class="form-label">Religion</label>
    <select id="religion" name="religion" class="form-select" required>
      <option value="">Select</option>
      <option <?= (($app['religion'] ?? '') === 'Hindu') ? 'selected' : ''; ?>>Hindu</option>
      <option <?= (($app['religion'] ?? '') === 'Muslim') ? 'selected' : ''; ?>>Muslim</option>
      <option <?= (($app['religion'] ?? '') === 'Christian') ? 'selected' : ''; ?>>Christian</option>
      <option <?= (($app['religion'] ?? '') === 'Sikh') ? 'selected' : ''; ?>>Sikh</option>
      <option <?= (($app['religion'] ?? '') === 'Other') ? 'selected' : ''; ?>>Other</option>
    </select>
  </div>
  <div class="col-md-3 help-wrap"><label class="form-label">Nationality (as in passport)</label><input type="text" name="nationality" class="form-control" value="<?= htmlspecialchars($app['nationality']??'India') ?>" required></div>
  <div class="col-md-3 help-wrap"><label class="form-label">Country of Birth</label><input type="text" name="country_of_birth" class="form-control" value="<?= htmlspecialchars($app['country_of_birth']??'India') ?>" required></div>
  <div class="col-md-3 help-wrap"><label class="form-label">Mobile Number</label><input type="tel" name="mobile" class="form-control" placeholder="+91XXXXXXXXXX" value="<?= htmlspecialchars($pre_app1['mobile'] ?? ($_SESSION['phone'] ?? '')) ?>" readonly></div>
    <!-- Aadhar & PAN Fields -->
  <div class="row g-3">
    <div class="col-md-3 help-wrap" id="aadharField">
      <label class="form-label">Aadhar Number</label>
      <input type="text" name="aadhar_number" id="aadhar_number" class="form-control" maxlength="12"
        pattern="\d{12}" inputmode="numeric"
        oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,12)"
        value="<?= htmlspecialchars($app['aadhar_number'] ?? '') ?>"
        placeholder="12 digits"
        <?= ((int)($app['has_passport'] ?? 0) === 1) ? '' : 'required' ?>>
      <div class="invalid-feedback">Enter 12 digit Aadhar number (digits only).</div>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">PAN Number</label>
      <input type="text" name="pan_number" id="pan_number" class="form-control" maxlength="20"
        pattern="[A-Z]{5}[0-9]{4}[A-Z]{1}" inputmode="text"
        oninput="this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '').slice(0, 20)"
        value="<?= htmlspecialchars($app['pan_number'] ?? '') ?>"
        placeholder="ABCDE1234F"
        <?= ((int)($app['has_passport'] ?? 0) === 1) ? '' : 'required' ?>>
      <div class="invalid-feedback">Enter valid 10-character PAN (e.g., ABCDE1234F).</div>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Do you have Passport?</label>
      <input type="hidden" name="has_passport" id="has_passport_hidden" value="<?= (int)($app['has_passport'] ?? 0) ?>">

      <div class="form-check">
        <input class="form-check-input" type="radio" name="has_passport_radio" id="hp_yes" value="1"
          <?= ((int)($app['has_passport'] ?? 0) === 1) ? 'checked' : '' ?>>
        <label class="form-check-label" for="hp_yes">Yes</label>
      </div>

      <div class="form-check">
        <input class="form-check-input" type="radio" name="has_passport_radio" id="hp_no" value="0"
          <?= ((int)($app['has_passport'] ?? 0) !== 1) ? 'checked' : '' ?>>
        <label class="form-check-label" for="hp_no">No</label>
      </div>

      <div id="passportFields" class="mt-2" style="display: <?= ((int)($app['has_passport'] ?? 0) === 1) ? 'block' : 'none' ?>;">
        <label class="form-label mt-2">Passport Number</label>
        <input type="text" name="passport_number" id="passport_number" class="form-control"
          value="<?= htmlspecialchars($app['passport_number'] ?? '') ?>"
          placeholder="Enter Passport Number">
      </div>
    </div>

    <!-- UAN Question + Number -->
    <div class="col-md-3 help-wrap">
      <label class="form-label">Do you have UAN Number?</label>
      <input type="hidden" name="has_uan" id="has_uan_hidden" value="<?= (int)($app['has_uan'] ?? 0) ?>">

      <div class="form-check">
        <input class="form-check-input" type="radio" name="has_uan_radio" id="uan_yes" value="1"
          <?= ((int)($app['has_uan'] ?? 0) === 1) ? 'checked' : '' ?>>
        <label class="form-check-label" for="uan_yes">Yes</label>
      </div>

      <div class="form-check">
        <input class="form-check-input" type="radio" name="has_uan_radio" id="uan_no" value="0"
          <?= ((int)($app['has_uan'] ?? 0) !== 1) ? 'checked' : '' ?>>
        <label class="form-check-label" for="uan_no">No</label>
      </div>

      <div id="uanField" class="mt-2" style="display: <?= ((int)($app['has_uan'] ?? 0) === 1) ? 'block' : 'none' ?>;">
        <label class="form-label mt-2">UAN Number</label>
        <input type="text" name="uan_number" id="uan_number" class="form-control"
          value="<?= htmlspecialchars($app['uan_number'] ?? '') ?>"
          placeholder="Enter UAN Number">
      </div>
    </div>
  </div>


  <div class="col-md-6 help-wrap"><label class="form-label">Permanent Home Address (Line 1)</label><input type="text" name="addr_line1" class="form-control" value="<?= htmlspecialchars($app['addr_line1']??'') ?>" required></div>
  <div class="col-md-6 help-wrap"><label class="form-label">Permanent Home Address (Line 2) (Optional)</label><input type="text" name="addr_line2" class="form-control" value="<?= htmlspecialchars($app['addr_line2']??'') ?>"></div>

  <div class="col-md-3 help-wrap">
    <label class="form-label">City / Town (India)</label>
    <input type="text" id="citySearch" class="form-control mb-2" placeholder="Search city (type 2+ chars)">
    <select id="city" name="city" class="form-select" required data-selected="<?= htmlspecialchars($app['city']??'') ?>"><option value="">Select City</option><option value="__OTHER__">Other (not listed)</option></select>
    <input type="text" id="city_other" name="city_other" class="form-control mt-2 d-none" placeholder="Enter City/Town">
  </div>

  <div class="col-md-3 help-wrap">
    <label class="form-label">Postal Code</label>
    <select id="postal_code" name="postal_code" class="form-select" required data-selected="<?= htmlspecialchars($app['postal_code']??'') ?>"><option value="">Select Postal Code</option><option value="__OTHER__">Other (not listed)</option></select>
    <input type="text" id="postal_other" name="postal_other" class="form-control mt-2 d-none" placeholder="Enter Postal Code" maxlength="10">
  </div>

  <div class="col-md-3 help-wrap">
    <label class="form-label">Country</label>
    <select id="country" name="country" class="form-select" required data-selected="<?= htmlspecialchars($app['country']??'India') ?>"><option value="">Select Country</option><option value="__OTHER__">Other (not listed)</option></select>
    <input type="text" id="country_other" name="country_other" class="form-control mt-2 d-none" placeholder="Enter Country">
  </div>

  <div class="col-md-3 help-wrap">
    <label class="form-label">Province / State</label>
    <select id="state" name="state" class="form-select" required data-selected="<?= htmlspecialchars($app['state']??'') ?>"><option value="">Select State/Province</option><option value="__OTHER__">Other (not listed)</option></select>
    <input type="text" id="state_other" name="state_other" class="form-control mt-2 d-none" placeholder="Enter State/Province">
  </div>
</div>
<!-- Family / Nominee / Emergency Details -->
<h5 class="mb-3 mt-4 text-center mb-4">Family / Nominee / Emergency Details</h5>

<div class="row g-3">
  <!-- Family Details -->
  <div class="col-md-3 help-wrap">
    <label class="form-label">Father's Name</label>
    <input type="text" name="father_name" class="form-control" value="<?= htmlspecialchars($app['father_name'] ?? '') ?>" required>
  </div>
  <div class="col-md-3 help-wrap">
    <label class="form-label">Mother's Name</label>
    <input type="text" name="mother_name" class="form-control" value="<?= htmlspecialchars($app['mother_name'] ?? '') ?>" required>
  </div>
  <div class="col-md-3 help-wrap">
    <label class="form-label">Marital Status</label>
    <select id="marital_status" class="form-select" disabled>
      <option value="">Select</option>
      <option value="Single" <?= (($pre_app1['marital_status'] ?? '') === 'Single') ? 'selected' : ''; ?>>Single</option>
      <option value="Married" <?= (($pre_app1['marital_status'] ?? '') === 'Married') ? 'selected' : ''; ?>>Married</option>
      <option value="Divorced" <?= (($pre_app1['marital_status'] ?? '') === 'Divorced') ? 'selected' : ''; ?>>Divorced</option>
      <option value="Widowed" <?= (($pre_app1['marital_status'] ?? '') === 'Widowed') ? 'selected' : ''; ?>>Widowed</option>
      <option value="Other" <?= (($pre_app1['marital_status'] ?? '') === 'Other') ? 'selected' : ''; ?>>Other</option>
    </select>
    <input type="hidden" name="marital_status" value="<?= htmlspecialchars($pre_app1['marital_status'] ?? '') ?>">
  </div>
  <div class="col-md-3 help-wrap">
    <label class="form-label">Date of Marriage</label>
    <input type="date" name="date_of_marriage" class="form-control" value="<?= htmlspecialchars($app['date_of_marriage'] ?? '') ?>">
  </div>
  <div class="col-md-3 help-wrap">
    <label class="form-label">Spouse Name</label>
    <input type="text" name="spouse_name" class="form-control" value="<?= htmlspecialchars($app['spouse_name'] ?? '') ?>">
  </div>
  <div class="col-md-3 help-wrap">
    <label class="form-label">Daughter's Name</label>
    <input type="text" name="daughter_name" class="form-control" value="<?= htmlspecialchars($app['daughter_name'] ?? '') ?>">
  </div>
  <div class="col-md-3 help-wrap">
    <label class="form-label">Son's Name</label>
    <input type="text" name="son_name" class="form-control" value="<?= htmlspecialchars($app['son_name'] ?? '') ?>">
  </div>
</div>

  <!-- Nominee Details -->
  <h5 class="mb-3 mt-4 text-center mb-4">Nominee Details</h5>

  <div class="row g-3">
    <div class="col-md-3 help-wrap">
      <label class="form-label">Nominee Name</label>
      <input type="text" name="nominee_name" class="form-control" value="<?= htmlspecialchars($app['nominee_name'] ?? '') ?>" required>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Relation with Employee</label>
      <input type="text" name="nominee_relation" class="form-control" value="<?= htmlspecialchars($app['nominee_relation'] ?? '') ?>" required>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Nominee DOB</label>
      <input type="date" name="nominee_dob" class="form-control" value="<?= htmlspecialchars($app['nominee_dob'] ?? '') ?>" required>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Nominee Address</label>
      <input type="text" name="nominee_address" class="form-control" value="<?= htmlspecialchars($app['nominee_address'] ?? '') ?>" required>
    </div>
  </div>

  <!-- Emergency Contact Details -->
  <h5 class="mb-3 mt-4 text-center mb-4">Emergency Contact Details</h5>

  <div class="row g-3">
    <div class="col-md-3 help-wrap">
      <label class="form-label">Emergency Contact Name</label>
      <input type="text" name="emergency_name" class="form-control" value="<?= htmlspecialchars($app['emergency_name'] ?? '') ?>" required>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Mobile</label>
      <input type="tel" name="emergency_mobile" class="form-control" value="<?= htmlspecialchars($app['emergency_mobile'] ?? '') ?>" placeholder="+91XXXXXXXXXX" required>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Landline</label>
      <input type="text" name="emergency_landline" class="form-control" value="<?= htmlspecialchars($app['emergency_landline'] ?? '') ?>">
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Relation</label>
      <input type="text" name="emergency_relation" class="form-control" value="<?= htmlspecialchars($app['emergency_relation'] ?? '') ?>">
    </div>
  </div>

  <!-- References -->
  <h5 class="mb-3 mt-4 text-center mb-4">Reference Details</h5>

  <div class="row g-3">
    <div class="col-md-3 help-wrap">
      <label class="form-label">Reference-1</label>
      <input type="text" name="reference_1" class="form-control" value="<?= htmlspecialchars($app['reference_1'] ?? '') ?>" required>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Reference-1 Contact</label>
      <input type="text" name="reference_1_contact" class="form-control" value="<?= htmlspecialchars($app['reference_1_contact'] ?? '') ?>" required>
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Reference-2</label>
      <input type="text" name="reference_2" class="form-control" value="<?= htmlspecialchars($app['reference_2'] ?? '') ?>">
    </div>
    <div class="col-md-3 help-wrap">
      <label class="form-label">Reference-2 Contact</label>
      <input type="text" name="reference_2_contact" class="form-control" value="<?= htmlspecialchars($app['reference_2_contact'] ?? '') ?>">
    </div>
  </div>

<div class="d-grid mt-4"><button class="btn btn-primary btn-lg">Save & Continue</button></div>

<input type="hidden" id="has_passport_hidden" name="has_passport_hidden" value="<?= (int)($app['has_passport']??0) ?>">
<input type="hidden" id="aadhar_number_hidden" name="aadhar_number_hidden" value="<?= htmlspecialchars($app['aadhar_number']??'') ?>">
</form>
<?php endif; ?>
<?php if($step === 3 && !$isSubmitted): ?>
<form method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
  <h5 class="mb-3">1.2 Identity & Photo Uploads</h5>

  <div class="alert alert-info mb-3">
    <b>Rules:</b><br>
    Aadhar front + back <b>(mandatory)</b>.
  </div>

<div class="row g-3">
  <div class="col-md-4 help-wrap">
    <label class="form-label">Passport Size Photo</label>
    <?php if(!empty($app['passport_photo'])): ?>
      <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id,$app['passport_photo']) ?>">View uploaded attachment</a>
    <?php endif; ?>
    <input type="file" name="passport_photo" id="passport_photo" class="form-control" accept=".jpg,.jpeg,.png">
     <div class="form-text text-muted">Maximum file size: 500 KB</div>
  </div>
   <?php if (!empty($app['has_passport']) && $app['has_passport'] == 1 && !empty($app['passport_number'])): ?>
      <div class="col-md-4 help-wrap">
        <label class="form-label">Passport Copy <?= empty($app['passport_copy']) ? '<span class="text-danger">*</span>' : '' ?></label>
        <?php if (!empty($app['passport_copy'])): ?>
          <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['passport_copy']) ?>">View uploaded attachment</a>
        <?php endif; ?>
        <input type="file" name="passport_copy" class="form-control" accept=".jpg,.jpeg,.png,.pdf" <?= empty($app['passport_copy']) ? 'required' : '' ?>>
        <div class="form-text text-muted">Maximum file size: 500 KB</div>
      </div>
    <?php endif; ?>
  <div class="col-md-4 help-wrap">
    <label class="form-label">PAN Card Copy <?= empty($app['pan_card']) ? '<span class="text-danger">*</span>' : '' ?></label>
    <?php if (!empty($app['pan_card'])): ?>
      <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['pan_card']) ?>">View uploaded attachment</a>
    <?php endif; ?>
    <input type="file" name="pan_card" class="form-control" accept=".jpg,.jpeg,.png,.pdf" <?= empty($app['pan_card']) ? 'required' : '' ?>>
     <div class="form-text text-muted">Maximum file size: 500 KB</div>
  </div>
  <div class="col-md-4 help-wrap">
    <label class="form-label">Aadhar Front Copy <?= empty($app['aadhar_front']) ? '<span class="text-danger">*</span>' : '' ?></label>
    <?php if (!empty($app['aadhar_front'])): ?>
      <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['aadhar_front']) ?>">View uploaded attachment</a>
    <?php endif; ?>
    <input type="file" name="aadhar_front" class="form-control" accept=".jpg,.jpeg,.png,.pdf" <?= empty($app['aadhar_front']) ? 'required' : '' ?>>
     <div class="form-text text-muted">Maximum file size: 500 KB</div>
   </div>

  <div class="col-md-4 help-wrap">
    <label class="form-label">Aadhar Back Copy <?= empty($app['aadhar_back']) ? '<span class="text-danger">*</span>' : '' ?></label>
    <?php if (!empty($app['aadhar_back'])): ?>
      <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['aadhar_back']) ?>">View uploaded attachment</a>
    <?php endif; ?>
    <input type="file" name="aadhar_back" class="form-control" accept=".jpg,.jpeg,.png,.pdf" <?= empty($app['aadhar_back']) ? 'required' : '' ?>>
     <div class="form-text text-muted">Maximum file size: 500 KB</div>
  </div>

  <div class="d-flex justify-content-between mt-4">
    <a href="?step=1" class="btn btn-light">← Back</a>
    <button class="btn btn-primary">Save & Continue</button>
  </div>
</form>
<?php endif; ?>

<?php if($step === 4 && !$isSubmitted): ?>
<form method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
  <h5 class="mb-3">2.6 Bank Details</h5>
  <div class="row g-3">
    <div class="col-md-6 help-wrap">
      <label class="form-label">Bank Name <span class="text-danger">*</span></label>
      <input type="text" name="bank_name" class="form-control" value="<?= htmlspecialchars($app['bank_name'] ?? '') ?>" required>
    </div>

    <div class="col-md-6 help-wrap">
      <label class="form-label">Account Number <span class="text-danger">*</span></label>
      <input type="text" name="account_number" class="form-control" value="<?= htmlspecialchars($app['account_number'] ?? '') ?>" required>
    </div>

    <div class="col-md-6 help-wrap">
      <label class="form-label">IFSC Code <span class="text-danger">*</span></label>
      <input type="text" name="ifsc_code" class="form-control" value="<?= htmlspecialchars($app['ifsc_code'] ?? '') ?>" required>
    </div>

    <div class="col-md-6 help-wrap">
      <label class="form-label">Upload Passbook / Cancelled Cheque / Bank Statement <span class="text-danger">*</span></label>
      <?php if(!empty($app['bank_document'])): ?><a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['bank_document']) ?>">View uploaded attachment</a><?php endif; ?>
      <input type="file" name="bank_document" class="form-control" accept=".jpg,.jpeg,.png,.pdf" <?= empty($app['bank_document']) ? 'required' : '' ?>>
      <div class="form-text text-muted">Maximum file size: 500 KB</div>
    </div>
  </div>

  <div class="d-flex justify-content-between mt-4">
    <a href="?step=3" class="btn btn-light">← Back</a>
    <button class="btn btn-primary">Save & Continue</button>
  </div>
</form>
<?php endif; ?>

<?php if($step===5 && !$isSubmitted): ?>
<form method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
<h5 class="mb-3">STEP 2: Academic Qualifications</h5>

<div class="border rounded p-3 mb-4 bg-light">
  <h6 class="mb-3">2.1 10th Certificate</h6>
  <div class="row g-3">
    <div class="col-md-2 help-wrap"><label class="form-label">Passing Year</label><select id="ssc_year" name="ssc_year" class="form-select" required data-selected="<?= htmlspecialchars($app['ssc_year']??'') ?>"></select></div>
    <div class="col-md-3 help-wrap"><label class="form-label">School Name</label><input type="text" name="ssc_school" class="form-control" required value="<?= htmlspecialchars($app['ssc_school']??'') ?>"></div>
    <div class="col-md-3 help-wrap"><label class="form-label">School Board</label><input name="ssc_board" class="form-control" rows="2" required value="<?= htmlspecialchars($app['ssc_board']??'') ?>"></input></div>
    <div class="col-md-3 help-wrap"><label class="form-label">Grade / Percentage</label><input name="ssc_grade" class="form-control" rows="2" required value="<?= htmlspecialchars($app['ssc_grade']??'') ?>"></input></div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">10th Certificate Upload <?= empty($app['ssc_certificate'])?'<span class="text-danger">*</span>':'' ?></label>
      <?php if(!empty($app['ssc_certificate'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id,$app['ssc_certificate']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="ssc_certificate" class="form-control" accept=".jpg,.jpeg,.png,.pdf" <?= empty($app['ssc_certificate'])?'required':'' ?>>
    </div>
  </div>
</div>

<div class="border rounded p-3">
  <h6 class="mb-3">2.2 12th Certificate</h6>
  <div class="row g-3">
    <div class="col-md-2 help-wrap"><label class="form-label">Passing Year</label><select id="inter_year" name="inter_year" class="form-select" required data-selected="<?= htmlspecialchars($app['inter_year']??'') ?>"></select></div>
    <div class="col-md-3 help-wrap"><label class="form-label">School Name</label><input type="text" name="inter_school" class="form-control" required value="<?= htmlspecialchars($app['inter_school']??'') ?>"></div>
    <div class="col-md-3 help-wrap"><label class="form-label">School Board</label><input name="inter_board" class="form-control" rows="2" required value="<?= htmlspecialchars($app['inter_board']??'') ?>"></input></div>
    <div class="col-md-3 help-wrap"><label class="form-label">Grade / Percentage</label><input name="inter_grade" class="form-control" rows="2" required value="<?= htmlspecialchars($app['inter_grade']??'') ?>"></input></div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">12th Certificate Upload <?= empty($app['inter_certificate'])?'<span class="text-danger">*</span>':'' ?></label>
      <?php if(!empty($app['inter_certificate'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id,$app['inter_certificate']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="inter_certificate" class="form-control" accept=".jpg,.jpeg,.png,.pdf" <?= empty($app['inter_certificate'])?'required':'' ?>>
    </div>
  </div>
</div>
<div class="border rounded p-3 mt-4 bg-light">
  <h6 class="mb-3">2.3 Graduation Certificate</h6>
  <div class="row g-3">
    <div class="col-md-2 help-wrap"><label class="form-label">Passing Year</label><select id="grad_year" name="grad_year" class="form-select" data-selected="<?= htmlspecialchars($app['grad_year'] ?? '') ?>"></select></div>
    <div class="col-md-3 help-wrap"><label class="form-label">College/University</label><input type="text" name="grad_college" class="form-control" value="<?= htmlspecialchars($app['grad_college'] ?? '') ?>"></div>
    <div class="col-md-3 help-wrap"><label class="form-label">Degree Title</label><input type="text" name="grad_degree_title" class="form-control" value="<?= htmlspecialchars($app['grad_degree_title'] ?? '') ?>"></div>
    <div class="col-md-3 help-wrap"><label class="form-label">GraduationGrade / Percentage</label><input name="grad_grade" class="form-control" rows="2" value="<?= htmlspecialchars($app['grad_grade']??'') ?>"></input></div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">Graduation Certificate Upload</label>
      <?php if (!empty($app['ug_certificate'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['ug_certificate']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="ug_certificate" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>
  </div>
</div>

<div class="border rounded p-3 mt-4">
  <h6 class="mb-3">2.4 Post-Graduation Certificate</h6>
  <div class="row g-3">
    <div class="col-md-2 help-wrap"><label class="form-label">Passing Year</label><select id="pg_year" name="pg_year" class="form-select" data-selected="<?= htmlspecialchars($app['pg_year']??'') ?>"></select></div>
    <div class="col-md-3 help-wrap"><label class="form-label">College/University</label><input type="text" name="pg_college" class="form-control" value="<?= htmlspecialchars($app['pg_college']??'') ?>"></div>
    <div class="col-md-3 help-wrap"><label class="form-label">Degree Title</label><input type="text" name="pg_degree_title" class="form-control" value="<?= htmlspecialchars($app['pg_degree_title']??'') ?>"></div>
    <div class="col-md-3 help-wrap"><label class="form-label">Post-Graduation Grade / Percentage</label><input name="pg_grade" class="form-control" rows="2" value="<?= htmlspecialchars($app['pg_grade']??'') ?>"></input></div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">Post-Graduation Certificate Upload</label>
      <?php if(!empty($app['pg_certificate'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id,$app['pg_certificate']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="pg_certificate" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>
  </div>
</div>

<div class="border rounded p-3 mt-4 bg-light">
  <h6 class="mb-3">2.5 Other Qualifications (if any)</h6>
  <div class="row g-3">
    <div class="col-md-6 help-wrap"><label class="form-label">Qualification Title</label><input type="text" name="other_qualification" class="form-control" value="<?= htmlspecialchars($app['other_qualification']??'') ?>"></div>
    <div class="col-md-6 help-wrap">
      <label class="form-label">Upload Certificate (Optional)</label>
      <?php if(!empty($app['other_certificate'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id,$app['other_certificate']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="other_certificate" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>
  </div>
</div>
<div class="d-flex justify-content-between mt-4"><a href="?step=2" class="btn btn-light">← Back</a><button class="btn btn-primary">Save & Continue</button></div>
</form>
<?php endif; ?>

<?php if($step === 6 && !$isSubmitted): ?>
<?php
  $totalExp = $pre_app['totalExp'] ?? '';
  $isFresherOrIntern = in_array(strtolower(trim($totalExp)), ['fresher', 'internship']);
?>

<form method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
  <h5 class="mb-3">2.3 Work Experience Details</h5>

  <?php if($isFresherOrIntern): ?>
    <div class="alert alert-info">
      <strong>Note:</strong> If you're a <strong>Fresher</strong> or have only done an <strong>Internship</strong>, you can leave the fields below empty and click <strong>"Save & Continue"</strong>.
    </div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-12 help-wrap">
      <label class="form-label">Previous Roles & Responsibilities</label>
      <textarea name="experience_details" class="form-control" rows="6"
        placeholder="Describe your previous job roles, responsibilities, and relevant experience..."
        <?= $isFresherOrIntern ? '' : 'required' ?>
      ><?= htmlspecialchars($app['experience_details'] ?? '') ?></textarea>
    </div>
    
    <div class="col-md-6 help-wrap mb-4">
      <label class="form-label">
        Upload Experience / Relieving Letter / FNF <?= (!$isFresherOrIntern && empty($app['experience_letter'])) ? '<span class="text-danger">*</span>' : '' ?>
      </label>
      <?php if(!empty($app['experience_letter'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['experience_letter']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="experience_letter" class="form-control" accept=".jpg,.jpeg,.png,.pdf"
        <?= (!$isFresherOrIntern && empty($app['experience_letter'])) ? 'required' : '' ?>>
    </div>
    <div class="col-12 mt-3">
      <p class="fw-bold text-primary">You can upload any one of the following documents:</p>
    </div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">Salary Proof</label>
      <?php if(!empty($app['salary_proof'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['salary_proof']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="salary_proof" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">Offer Letter</label>
      <?php if(!empty($app['offer_letter'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['offer_letter']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="offer_letter" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">Salary Slip</label>
      <?php if(!empty($app['salary_slip'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['salary_slip']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="salary_slip" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">ITR</label>
      <?php if(!empty($app['itr'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['itr']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="itr" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>
    <div class="col-md-4 help-wrap">
      <label class="form-label">Agreement</label>
      <?php if(!empty($app['agreement'])): ?>
        <a target="_blank" class="btn btn-sm btn-file mb-1" href="<?= file_url($id, $app['agreement']) ?>">View uploaded attachment</a>
      <?php endif; ?>
      <input type="file" name="agreement" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
    </div>

    <div class="d-flex justify-content-between mt-4">
      <a href="?step=3" class="btn btn-light">← Back</a>
      <button class="btn btn-primary">Save & Continue</button>
    </div>
  </div>
</form>
<?php endif; ?>

<?php if($step===7): ?>
<?php
$q2=mysqli_prepare($conn,"SELECT * FROM employee_applications WHERE id=?");
mysqli_stmt_bind_param($q2,"i",$id);mysqli_stmt_execute($q2);$r2=mysqli_stmt_get_result($q2);$app=$r2?mysqli_fetch_assoc($r2):$app;
$isSubmitted=(($app['application_status']??'')==='submitted');

$pp=file_url($id,$app['passport_photo']??null);
$af=file_url($id,$app['aadhar_front']??null);
$ab=file_url($id,$app['aadhar_back']??null);
$pc=file_url($id,$app['pan_card']??null);
$passport=file_url($id,$app['passport_copy']??null);
$sc=file_url($id,$app['ssc_certificate']??null);
$ic=file_url($id,$app['inter_certificate']??null);
$sf=file_url($id,$app['experience_letter']??null);
$salary=file_url($id,$app['salary_proof']??null);
$ol=file_url($id,$app['offer_letter']??null);
$ss=file_url($id,$app['salary_slip']??null);
$itr=file_url($id,$app['itr']??null);
$ag=file_url($id,$app['agreement']??null);
?>
<div class="d-flex justify-content-between align-items-center mb-3 no-print">
  <h5 class="mb-0">Preview <?= $isSubmitted?'<span class="badge badge-accent ms-2">Submitted</span>':'' ?></h5>
  <div class="d-flex gap-2">
    <?php if(!$isSubmitted): ?>
    <form method="POST" class="d-inline me-2">
      <input type="hidden" name="final_submit" value="1">
      <button class="btn btn-primary">Final Submit</button>
    </form>
    <?php endif; ?>
    <button onclick="window.print()" class="btn btn-outline-secondary">Print (A4)</button>
    <button onclick="window.print()" class="btn btn-outline-primary">Save PDF</button>
  </div>
</div>

<?php if(!$isSubmitted): ?>
<div class="alert alert-warning">
  <b>NOTE:</b> Any wrong document with incorrect information will be viewed seriously and an appropriate action will be taken, thereafter. Application will be rejected automatically.
  <br>I acknowledge that I have read and understood the above instructions and procedures in its entirety and agree to abide by them.
</div>
<?php endif; ?>

<div id="printPreview">

  <div class="resume">
    <aside class="left text-center">
      <img src="<?= $pp ?: (defined('BASE_URL')?BASE_URL:'').'assets/images/profile/user-1.jpg' ?>" class="avatar" alt="photo">
      <div class="name mt-2"><?= htmlspecialchars(($app['first_name']??'').' '.($app['surname']??'')) ?></div>
      <div class="role">Investors Clinic Applicant</div>

      <div class="blk">
        <h6>CONTACT</h6>
        <div class="item">Email: <?= htmlspecialchars($email) ?></div>
        <div class="item">Mobile: <?= htmlspecialchars($app['mobile']??'') ?></div>
        <div class="item">DOB: <?= htmlspecialchars($app['dob']??'') ?></div>
        <div class="item">Gender: <?= htmlspecialchars($app['gender']??'') ?></div>
       <div class="item">Marital Status: <?= htmlspecialchars($app['marital_status'] ?? '') ?></div>
      </div>

      <div class="blk">
        <h6>IDENTITY</h6>
        <div class="item">Language: <?= htmlspecialchars($app['preferred_language']??'') ?></div>
        <div class="item">Nationality: <?= htmlspecialchars($app['nationality']??'') ?></div>
        <div class="item">Passport: <?= ((int)($app['has_passport']??0)===1)?'Available':'Not Available' ?></div>
        <?php if($af): ?><div class="item"><a class="btn btn-sm btn-file" target="_blank" href="<?= $af ?>">Aadhar Front</a></div><?php endif; ?>
        <?php if($ab): ?><div class="item"><a class="btn btn-sm btn-file" target="_blank" href="<?= $ab ?>">Aadhar Back</a></div><?php endif; ?>
      </div>

      <div class="blk">
        <h6>ADDRESS</h6>
        <div class="item"><?= htmlspecialchars(($app['addr_line1']??'')) ?></div>
        <?php if(!empty($app['addr_line2'])): ?><div class="item"><?= htmlspecialchars($app['addr_line2']) ?></div><?php endif; ?>
        <div class="item"><?= htmlspecialchars(($app['city']??'').', '.($app['state']??'')) ?></div>
        <div class="item"><?= htmlspecialchars(($app['country']??'').' - '.($app['postal_code']??'')) ?></div>
      </div>
    </aside>

    <section class="right">
      <h5 class="mb-3">1.1 Personal Details</h5>
        <div class="line"></div>
        <div class="row g-2 mb-2">
          <div class="col-md-3"><b>Title:</b> <?= htmlspecialchars($app['title'] ?? '') ?></div>
          <div class="col-md-3"><b>First Name:</b> <?= htmlspecialchars($app['first_name'] ?? '') ?></div>
          <div class="col-md-3"><b>Surname:</b> <?= htmlspecialchars($app['surname'] ?? '') ?></div>
          <div class="col-md-3"><b>Gender:</b> <?= htmlspecialchars($app['gender'] ?? '') ?></div>
          <div class="col-md-3"><b>Date of Birth:</b> <?= htmlspecialchars($app['dob'] ?? '') ?></div>
          <div class="col-md-3"><b>Blood Group:</b> <?= htmlspecialchars($app['blood_group'] ?? '') ?></div>
          <div class="col-md-3"><b>Religion:</b> <?= htmlspecialchars($app['religion'] ?? '') ?></div>
          <div class="col-md-3"><b>Aadhar Number:</b> <?= htmlspecialchars($app['aadhar_number'] ?? '') ?></div>
          <div class="col-md-3"><b>PAN Number:</b> <?= htmlspecialchars($app['pan_number'] ?? '') ?></div>
          <?php if ((int)($app['has_passport'] ?? 0) === 1): ?>
            <div class="col-md-3"><b>Passport Number:</b> <?= htmlspecialchars($app['passport_number'] ?? '') ?></div>
          <?php endif; ?>
          <?php if ((int)($app['has_uan'] ?? 0) === 1): ?>
            <div class="col-md-3"><b>UAN Number:</b> <?= htmlspecialchars($app['uan_number'] ?? '') ?></div>
          <?php endif; ?>
          <div class="col-md-3"><b>City:</b> <?= htmlspecialchars($app['city'] ?? '') ?></div>
          <div class="col-md-3"><b>Postal Code:</b> <?= htmlspecialchars($app['postal_code'] ?? '') ?></div>
          <div class="col-md-3"><b>State:</b> <?= htmlspecialchars($app['state'] ?? '') ?></div>
          <div class="col-md-3"><b>Country:</b> <?= htmlspecialchars($app['country'] ?? '') ?></div>
          <div class="col-md-3"><b>Father Name:</b> <?= htmlspecialchars($app['father_name'] ?? '') ?></div>
          <div class="col-md-3"><b>Mother Name:</b> <?= htmlspecialchars($app['mother_name'] ?? '') ?></div>
          <div class="col-md-3"><b>Spouse Name:</b> <?= htmlspecialchars($app['spouse_name'] ?? '') ?></div>
          <div class="col-md-3"><b>Nominee Name:</b> <?= htmlspecialchars($app['nominee_name'] ?? '') ?></div>
          <div class="col-md-3"><b>Nominee Relation:</b> <?= htmlspecialchars($app['nominee_relation'] ?? '') ?></div>
          <div class="col-md-3"><b>Emergency Name:</b> <?= htmlspecialchars($app['emergency_name'] ?? '') ?></div>
          <div class="col-md-3"><b>Emergency Mobile:</b> <?= htmlspecialchars($app['emergency_mobile'] ?? '') ?></div>
          <div class="col-md-3"><b>Emergency Relation:</b> <?= htmlspecialchars($app['emergency_relation'] ?? '') ?></div>
          <div class="col-md-3"><b>Reference Name:</b> <?= htmlspecialchars($app['reference_1'] ?? '') ?></div>
          <div class="col-md-3"><b>Reference Mobile:</b> <?= htmlspecialchars($app['reference_1_contact'] ?? '') ?></div>
        </div>
        <div class="d-flex flex-wrap gap-2 mt-2">
          <?php if ($pp): ?><a class="btn btn-sm btn-file" target="_blank" href="<?= $pp ?>">View Profile Photo</a><?php endif; ?>
          <?php if ($af): ?><a class="btn btn-sm btn-file" target="_blank" href="<?= $af ?>">View Aadhar Front</a><?php endif; ?>
          <?php if ($ab): ?><a class="btn btn-sm btn-file" target="_blank" href="<?= $ab ?>">View Aadhar Back</a><?php endif; ?>
          <?php if ($pc): ?><a class="btn btn-sm btn-file" target="_blank" href="<?= $pc ?>">View PAN Card</a><?php endif; ?>
          <?php if ($passport): ?><a class="btn btn-sm btn-file" target="_blank" href="<?= $passport ?>">View Passport</a><?php endif; ?>
        </div>

      <div class="sec mt-4">
        <h5>Bank Details</h5>
        <div class="line"></div>
        <div class="mb-2">
          <b>Bank Name:</b> <?= htmlspecialchars($app['bank_name'] ?? '') ?> &nbsp;
          <b>Account Number:</b> <?= htmlspecialchars($app['account_number'] ?? '') ?> &nbsp;
          <b>IFSC Code:</b> <?= htmlspecialchars($app['ifsc_code'] ?? '') ?>
        </div>
        <?php if (!empty($app['bank_document'])): ?>
          <div class="d-flex flex-wrap gap-2 mt-2">
            <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['bank_document']) ?>">View Bank Document</a>
          </div>
        <?php endif; ?>
      </div>
      <div class="sec">
        <h5>Academic Qualifications</h5>
        <div class="line"></div>

        <!-- 10th -->
        <div>
          <b>10th</b> • Year <?= htmlspecialchars($app['ssc_year']??'') ?> — <?= htmlspecialchars($app['ssc_school']??'') ?> • 
          School Board: <?= htmlspecialchars($app['ssc_board']??'') ?> • 
          Grade / Percentage: <?= htmlspecialchars($app['ssc_grade']??'') ?>
        </div>
        <div class="d-flex flex-wrap gap-2 mb-3">
          <?php if($sc): ?><a class="btn btn-sm btn-file" target="_blank" href="<?= $sc ?>">View 10th Certificate</a><?php endif; ?>
        </div>

        <!-- 12th -->
        <div>
          <b>12th</b> • Year <?= htmlspecialchars($app['inter_year']??'') ?> — <?= htmlspecialchars($app['inter_school']??'') ?> • 
          School Board: <?= htmlspecialchars($app['inter_board']??'') ?> • 
          Grade / Percentage: <?= htmlspecialchars($app['inter_grade']??'') ?>
        </div>
        <div class="d-flex flex-wrap gap-2 mt-2">
          <?php if($ic): ?><a class="btn btn-sm btn-file" target="_blank" href="<?= $ic ?>">View 12th Certificate</a><?php endif; ?>
        </div>

        <!-- Graduation -->
        <?php if (!empty($app['grad_year']) && !empty($app['grad_college'])): ?>
          <hr>
          <div>
            <b>Graduation</b> • Year <?= htmlspecialchars($app['grad_year']??'') ?> — <?= htmlspecialchars($app['grad_college']??'') ?> • 
            Course Name: <?= htmlspecialchars($app['grad_degree_title']??'') ?>
          </div>
          <div class="d-flex flex-wrap gap-2 mt-2">
            <?php if(!empty($app['ug_certificate'])): ?>
              <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['ug_certificate']) ?>">View Graduation Certificate</a>
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <!-- Post Graduation -->
        <?php if (!empty($app['pg_year']) && !empty($app['pg_college'])): ?>
          <hr>
          <div>
            <b>Post Graduation</b> • Year <?= htmlspecialchars($app['pg_year']??'') ?> — <?= htmlspecialchars($app['pg_college']??'') ?> • 
            Course Name: <?= htmlspecialchars($app['pg_degree_title']??'') ?>
          </div>
          <div class="d-flex flex-wrap gap-2 mt-2">
            <?php if(!empty($app['pg_certificate'])): ?>
              <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['pg_certificate']) ?>">View Post Graduation Certificate</a>
            <?php endif; ?>
          </div>
        <?php endif; ?>
      </div>

      <?php if (!empty($app['experience_details']) || !empty($app['experience_letter'])): ?>
        <div class="sec">
          <h5>Experience Letter</h5>
          <div class="line"></div><b>Previous Roles & Responsibilities</b>
          <?php if (!empty($app['experience_details'])): ?><div style="white-space:pre-line"><?= htmlspecialchars($app['experience_details']) ?></div><?php endif; ?>
          <?php if (!empty($app['experience_letter']) || !empty($app['salary_proof'])): ?>
            <div class="d-flex flex-wrap gap-2 mt-2">
              <?php if (!empty($app['experience_letter'])): ?>
                <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['experience_letter']) ?>">View Experience Letter</a>
              <?php endif; ?>
              <?php if (!empty($app['salary_proof'])): ?>
                <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['salary_proof']) ?>">View Salary Proof</a>
              <?php endif; ?>
              <?php if (!empty($app['offer_letter'])): ?>
                <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['offer_letter']) ?>">View Offer Letter</a>
              <?php endif; ?>
              <?php if (!empty($app['itr'])): ?>
                <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['itr']) ?>">View ITR</a>
              <?php endif; ?>
              <?php if (!empty($app['agreement'])): ?>
                <a class="btn btn-sm btn-file" target="_blank" href="<?= file_url($id, $app['agreement']) ?>">View Agreement</a>
              <?php endif; ?>
            </div>
          <?php endif; ?>
        </div>
      <?php endif; ?>
      <?php if(!$isSubmitted): ?>
      <div class="no-print mt-3">
        <a href="?step=2" class="btn btn-outline-secondary btn-sm me-1">Edit Personal</a>
        <a href="?step=3" class="btn btn-outline-secondary btn-sm me-1">Edit Identity</a>
        <a href="?step=4" class="btn btn-outline-secondary btn-sm me-1">Edit Academics</a>
        <a href="?step=5" class="btn btn-outline-secondary btn-sm me-1">Edit Experience Letter</a>
      </div>
      <?php endif; ?>
    </section>
  </div>

  <?php if($isSubmitted): ?>
  <div class="alert alert-success mt-3">
    <div><b>Thank you! Your application has been submitted successfully.</b></div>
  </div>
  <?php endif; ?>
</div>

<?php
$attachments=[
  'Passport Photo' => $pp,
  'Aadhar Front'   => $af,
  'Aadhar Back'    => $ab,
  'Pan Card'    => $pc,
  '10th Certificate'=> $sc,
  '12th Certificate'=>$ic,
  'Experience Letter (PDF)'=> $sf
];
?>
<div id="printAttachments" class="print-only mt-4">
  <h4 class="mb-3">Attachments</h4>
  <div class="attach-grid">
    <?php foreach($attachments as $label=>$url): if(!$url) continue; ?>
      <div class="attach-card">
        <div class="fw-semibold mb-2"><?= htmlspecialchars($label) ?></div>
        <?php if(is_image_path($url)): ?>
          <img src="<?= $url ?>" alt="<?= htmlspecialchars($label) ?>">
        <?php else: ?>
          <div class="small">Type: PDF / Other</div>
          <div class="mt-2"><a href="<?= $url ?>" target="_blank"><?= basename($url) ?></a></div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php endif; ?>

</div></div></div></div>
</div>

<!-- Flash modal -->
<div class="modal fade" id="flashModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-sm modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header"><h6 class="modal-title">Attention</h6><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div>
      <div class="modal-body"><div class="text-danger" id="flashText"></div></div>
      <div class="modal-footer"><button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button></div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
<script>
(function(){'use strict';
 const forms=document.querySelectorAll('.needs-validation');
 Array.prototype.slice.call(forms).forEach(function(form){
   form.addEventListener('submit',function(e){
     document.querySelectorAll('.err-pop').forEach(x=>x.remove());
     document.querySelectorAll('.err-icon').forEach(x=>x.remove());
     if(!form.checkValidity()){
        e.preventDefault();e.stopPropagation();
        const invalid=form.querySelectorAll(':invalid');
        invalid.forEach(el=>{
          const wrap=el.closest('.help-wrap')||el.parentElement;
          const ic=document.createElement('span');ic.className='err-icon';ic.textContent='!';
          const pop=document.createElement('div');pop.className='err-pop d-none';pop.textContent=el.validationMessage||'Please correct this field.';wrap.appendChild(ic);wrap.appendChild(pop);
          ic.addEventListener('click',()=>{pop.classList.toggle('d-none');});
        });
        alert('Please correct the highlighted fields.');
     }
     form.classList.add('was-validated');
   },false);
 });
})();

/* Countries/States */
const COUNTRIES=["Afghanistan","Albania","Algeria","Andorra","Angola","Argentina","Armenia","Australia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bhutan","Bolivia","Bosnia and Herzegovina","Botswana","Brazil","Brunei","Bulgaria","Burkina Faso","Burundi","Cambodia","Cameroon","Canada","Chile","China","Colombia","Comoros","Congo (Congo-Brazzaville)","Costa Rica","Côte d’Ivoire","Croatia","Cuba","Cyprus","Czechia","Denmark","Djibouti","Dominican Republic","Ecuador","Egypt","El Salvador","Estonia","Eswatini","Ethiopia","Finland","France","Gabon","Gambia","Georgia","Germany","Ghana","Greece","Guatemala","Guinea","Guyana","Haiti","Honduras","Hungary","Iceland","India","Indonesia","Iran","Iraq","Ireland","Israel","Italy","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kuwait","Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Mexico","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique","Myanmar (Burma)","Namibia","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria","North Macedonia","Norway","Oman","Pakistan","Panama","Paraguay","Peru","Philippines","Poland","Portugal","Qatar","Romania","Russia","Rwanda","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Somalia","South Africa","South Korea","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Sweden","Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Togo","Trinidad and Tobago","Tunisia","Turkey","Uganda","Ukraine","United Arab Emirates","United Kingdom","United States","Uruguay","Uzbekistan","Venezuela","Vietnam","Yemen","Zambia","Zimbabwe"];
const IN_STATES=["Andhra Pradesh","Arunachal Pradesh","Assam","Bihar","Chhattisgarh","Goa","Gujarat","Haryana","Himachal Pradesh","Jharkhand","Karnataka","Kerala","Madhya Pradesh","Maharashtra","Manipur","Meghalaya","Mizoram","Nagaland","Odisha","Punjab","Rajasthan","Sikkim","Tamil Nadu","Telangana","Tripura","Uttar Pradesh","Uttarakhand","West Bengal","Andaman and Nicobar Islands","Chandigarh","Delhi","Jammu and Kashmir","Ladakh","Lakshadweep","Puducherry"];
(function(){
  const countrySel=document.getElementById('country'),stateSel=document.getElementById('state');
  if(countrySel){COUNTRIES.forEach(c=>{const o=document.createElement('option');o.value=c;o.textContent=c;countrySel.appendChild(o);});const selected=countrySel?.getAttribute('data-selected')||'India';countrySel.value=COUNTRIES.includes(selected)?selected:(selected?'__OTHER__':'');toggleOther(countrySel,'country_other');}
  if(stateSel){IN_STATES.forEach(s=>{const o=document.createElement('option');o.value=s;o.textContent=s;stateSel.appendChild(o);});const sSelected=stateSel?.getAttribute('data-selected')||'';stateSel.value=IN_STATES.includes(sSelected)?sSelected:(sSelected?'__OTHER__':'');toggleOther(stateSel,'state_other');}
})();

/* Years (<= current year) */
(function(){
  const fill = (id) => {
    const el = document.getElementById(id);
    if (!el) return;
    const now = new Date().getFullYear();
    for (let y = now; y >= 1980; y--) {
      const o = document.createElement('option');
      o.value = y;
      o.textContent = y;
      el.appendChild(o);
    }
    const chosen = el.getAttribute('data-selected') || '';
    if (chosen) el.value = chosen;
  };
  ['ssc_year', 'inter_year', 'grad_year', 'pg_year'].forEach(fill);
})();

/* City & Pincode APIs + Country auto India */
const citySel=document.getElementById('city');const citySearch=document.getElementById('citySearch');
const pinSel=document.getElementById('postal_code');const countrySel=document.getElementById('country');
function toggleOther(selectEl,otherId){const other=document.getElementById(otherId);if(!selectEl||!other)return;other.classList.toggle('d-none',selectEl.value!=='__OTHER__');if(selectEl.value!=='__OTHER__'){other.value='';}}
function lockCountry(lock){if(!countrySel)return;countrySel.classList.toggle('locked',lock);countrySel.setAttribute('aria-disabled',lock?'true':'false');}
function loadCities(term){if(!citySel)return;const url="<?= (defined('BASE_URL')?BASE_URL:'') ?>employee/employee-app/api/city_api.php?q="+encodeURIComponent(term||'');fetch(url).then(r=>r.json()).then(j=>{const keep=citySel.value;citySel.innerHTML='<option value=\"\">Select City</option><option value=\"__OTHER__\">Other (not listed)</option>';(j.cities||[]).forEach(c=>{const o=document.createElement('option');o.value=c;o.textContent=c;citySel.appendChild(o);});const pre=citySel.getAttribute('data-selected')||keep;if(pre){const has=[...citySel.options].some(o=>o.value===pre);citySel.value=has?pre:(pre==='__OTHER__'?'__OTHER__':'');}toggleOther(citySel,'city_other');if(citySel.value&&citySel.value!=='__OTHER__'){countrySel.value='India';lockCountry(true);loadPins(this.value||citySel.value);}else{lockCountry(false);pinSel.innerHTML='<option value=\"\">Select Postal Code</option><option value=\"__OTHER__\">Other (not listed)</option>';toggleOther(pinSel,'postal_other');}}).catch(()=>{});}
function loadPins(city){if(!pinSel)return;const url="<?= (defined('BASE_URL')?BASE_URL:'') ?>employee/employee-app/api/pincode_api.php?city="+encodeURIComponent(city);fetch(url).then(r=>r.json()).then(j=>{const keep=pinSel.getAttribute('data-selected')||pinSel.value;pinSel.innerHTML='<option value=\"\">Select Postal Code</option><option value=\"__OTHER__\">Other (not listed)</option>';(j.pincodes||[]).forEach(p=>{const o=document.createElement('option');o.value=p;o.textContent=p;pinSel.appendChild(o);});if(keep){const has=[...pinSel.options].some(o=>o.value===keep);pinSel.value=has?keep:(keep==='__OTHER__'?'__OTHER__':'');}toggleOther(pinSel,'postal_other');}).catch(()=>{});}
if(citySearch){let tId=null;citySearch.addEventListener('input',function(){const v=this.value.trim();if(v.length<2)return;clearTimeout(tId);tId=setTimeout(()=>loadCities(v),300);});}
if(citySel){citySel.addEventListener('change',function(){toggleOther(citySel,'city_other');if(this.value&&this.value!=='__OTHER__'){countrySel.value='India';lockCountry(true);loadPins(this.value);}else{lockCountry(false);pinSel.innerHTML='<option value=\"\">Select Postal Code</option><option value=\"__OTHER__\">Other (not listed)</option>';toggleOther(pinSel,'postal_other');}});loadCities('');}
if(pinSel){pinSel.addEventListener('change',function(){toggleOther(pinSel,'postal_other');});}
countrySel?.addEventListener('change',function(){toggleOther(this,'country_other');});
document.getElementById('state')?.addEventListener('change',function(){toggleOther(this,'state_other');});

/* Language Others toggle */
const prefSel=document.getElementById('preferred_language');
const prefOther=document.getElementById('preferred_language_other');
function togglePrefOther(){ if(!prefSel||!prefOther)return; prefOther.classList.toggle('d-none',prefSel.value!=='Others'); if(prefSel.value!=='Others'){ prefOther.value=''; } }
prefSel?.addEventListener('change',togglePrefOther); togglePrefOther();

/* Passport vs Aadhar toggle (and Aadhar required when no passport) */
function syncPassportToggle() {
  const yes = document.getElementById('hp_yes');
  const pf = document.getElementById('passportFields');
  const hpHidden = document.getElementById('has_passport_hidden');
  const showPass = yes && yes.checked;
  pf.style.display = showPass ? 'block' : 'none';
  if (hpHidden) hpHidden.value = showPass ? 1 : 0;
  if (aInput) {
    aInput.required = !showPass;
    if (showPass) aInput.value = '';
  }
}
function syncUanToggle() {
  const yes = document.getElementById('uan_yes');
  const uanField = document.getElementById('uanField');
  const hidden = document.getElementById('has_uan_hidden');
  const show = yes && yes.checked;
  uanField.style.display = show ? 'block' : 'none';
  if (hidden) hidden.value = show ? 1 : 0;
}
document.getElementById('hp_yes')?.addEventListener('change', syncPassportToggle);
document.getElementById('hp_no')?.addEventListener('change', syncPassportToggle);
document.getElementById('uan_yes')?.addEventListener('change', syncUanToggle);
document.getElementById('uan_no')?.addEventListener('change', syncUanToggle);
syncPassportToggle();
syncUanToggle();;

/* Copy bank details */
function copyBank(){
  const s=`Account Name:  Trade Chamber
Account No.: 50200086475431
Bank & Branch: HDFC, Krishna Nagar, Delhi
IFSC: HDFC0006624`;
  navigator.clipboard.writeText(s).then(()=>{alert('Bank details copied');});
}

/* flash modal helper */
function showFlash(t){const el=document.getElementById('flashText'); if(el){el.textContent=t; const m=new bootstrap.Modal(document.getElementById('flashModal')); m.show();}}
<?php if(!empty($_SESSION['flash_error'])){ $msg=str_replace(["\n","\r"],' ', $_SESSION['flash_error']); unset($_SESSION['flash_error']); ?>
  showFlash("<?= htmlspecialchars($msg,ENT_QUOTES) ?>");
<?php } ?>
  document.getElementById('resume').addEventListener('change', function() {
    const file = this.files[0];
    if(file.size > 200 * 1024) {
      alert('File size must be less than 200 KB');
      this.value = '';
    }
  });
</script>
<script>
const MAX_SIZE = 200 * 1024;
function compressImage(file) {
  return new Promise((resolve, reject) => {
    const img = new Image();
    const canvas = document.createElement('canvas');
    const reader = new FileReader();
    reader.onload = function (e) {
      img.onload = function () {
        const ctx = canvas.getContext('2d');
        const scale = Math.min(1, MAX_SIZE / file.size);
        canvas.width = img.width * scale;
        canvas.height = img.height * scale;
        ctx.drawImage(img, 0, 0, canvas.width, canvas.height);

        canvas.toBlob((blob) => {
          if (blob) {
            const compressedFile = new File([blob], file.name, { type: file.type });
            resolve(compressedFile);
          } else {
            reject();
          }
        }, file.type, 0.6);
      };
      img.onerror = reject;
      img.src = e.target.result;
    };
    reader.onerror = reject;
    reader.readAsDataURL(file);
  });
}

function renameFile(file, prefix) {
  const extension = file.name.split('.').pop().toLowerCase();
  const timestamp = Date.now();
  const newFileName = `${timestamp}_${prefix}.${extension}`;
  return new File([file], newFileName, {
    type: file.type,
    lastModified: new Date().getTime()
  });
}
async function handleFileChange(event, prefix) {
  const input = event.target;
  let file = input.files[0];
  if (!file) return;

  const isImage = ['image/jpeg', 'image/jpg', 'image/png'].includes(file.type);
  const isPdf = file.type === 'application/pdf';
  if (file.size > MAX_SIZE) {
    if (isImage) {
      try {
        const compressed = await compressImage(file);
        file = compressed;
      } catch (err) {
        console.error("Compression failed:", err);
        input.value = '';
        return;
      }
    } else if (isPdf) {
      alert(`PDF is too large (${Math.round(file.size / 1024)} KB). Please compress and upload again.`);
      input.value = '';
      return;
    } else {
      alert("Unsupported file type.");
      input.value = '';
      return;
    }
  }
  const renamedFile = renameFile(file, prefix);
  const dataTransfer = new DataTransfer();
  dataTransfer.items.add(renamedFile);
  input.files = dataTransfer.files;
}
  
document.addEventListener('DOMContentLoaded', () => {
  const fileInputs = [
    { name: 'passport_photo', prefix: 'passport_photo' },
    { name: 'passport_copy', prefix: 'passport_copy' },
    { name: 'pan_card', prefix: 'pan_card' },
    { name: 'aadhar_front', prefix: 'aadhar_front' },
    { name: 'aadhar_back', prefix: 'aadhar_back' },
    { name: 'ssc_certificate', prefix: 'high_school' },
    { name: 'inter_certificate', prefix: 'intermediate' },
    { name: 'ug_certificate', prefix: 'ug_certificate' },
    { name: 'pg_certificate', prefix: 'pg_certificate' },
    { name: 'experience_letter', prefix: 'experience_letter' },
    { name: 'bank_document', prefix: 'bank_document' },
    { name: 'salary_proof', prefix: 'salary_proof' },
    { name: 'offer_letter', prefix: 'offer_letter' },
    { name: 'salary_slip', prefix: 'salary_slip' },
    { name: 'itr', prefix: 'itr' },
    { name: 'agreement', prefix: 'agreement' }
  ];

  fileInputs.forEach(({ name, prefix }) => {
    const input = document.querySelector(`input[name="${name}"]`);
    if (input) {
      input.addEventListener('change', (e) => handleFileChange(e, prefix));
    }
  });
});
  const multiSelect = document.getElementById('multiLangSelect');
  const selectBoxDisplay = document.getElementById('selectBoxDisplay');
  const checkboxes = multiSelect.querySelectorAll('input[type="checkbox"]');
  const otherCheckbox = document.getElementById('lang_others');
  const otherInput = document.getElementById('preferred_language_other');
  selectBoxDisplay.addEventListener('click', () => {
    multiSelect.classList.toggle('open');
  });
  document.addEventListener('click', (e) => {
    if (!multiSelect.contains(e.target)) {
      multiSelect.classList.remove('open');
    }
  });
  otherCheckbox.addEventListener('change', () => {
    if (otherCheckbox.checked) {
      otherInput.classList.remove('d-none');
    } else {
      otherInput.classList.add('d-none');
      otherInput.value = '';
    }
  });
  function updateSelectedText() {
    const selected = [];
    checkboxes.forEach(cb => {
      if (cb.checked) selected.push(cb.value);
    });
    selectBoxDisplay.textContent = selected.length > 0 ? selected.join(', ') : 'Select languages';
  }
  checkboxes.forEach(cb => {
    cb.addEventListener('change', updateSelectedText);
  });
  updateSelectedText();
</script>
</body>
</html>
