<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('log_errors', 1);
error_reporting(E_ALL);

session_start();
require '../../config.php'; // mysqli $conn + BASE_URL + SENDGRID_* from config.php

/* ---------- Helpers ---------- */
function sendOTP($email, $otp, &$err = null) {
    $apiKey    = defined('SENDGRID_API_KEY')    ? SENDGRID_API_KEY    : '';
    $fromEmail = defined('SENDGRID_FROM_EMAIL') ? SENDGRID_FROM_EMAIL : '';
    $fromName  = defined('SENDGRID_FROM_NAME')  ? SENDGRID_FROM_NAME  : 'Investors Clinic';
    $brand     = 'Investors Clinic';
    $thankLine = 'Thank you for applying to Investors Clinic Office.';

    if ($apiKey === '' || $fromEmail === '') {
        $err = "Email service not configured (missing API key or sender).";
        return false;
    }

    $plain = "$thankLine\n\nYour One-Time Password (OTP) is: $otp\nIt’s valid for 10 minutes. Do not share this code with anyone.\n\n$brand";

    $html = '
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Your OTP Code</title></head>
<body style="font-family:Arial,Helvetica,sans-serif;background:#f6f9fc;color:#0f172a">
  <div style="max-width:560px;margin:auto;background:#fff;border-radius:14px;box-shadow:0 6px 22px rgba(16,24,40,.08);overflow:hidden">
    <div style="background:linear-gradient(135deg,#6a11cb,#2575fc);padding:16px 20px;color:#fff;font-weight:bold;font-size:18px">'.$brand.'</div>
    <div style="padding:26px">
      <h2 style="margin:0 0 12px 0;font-size:20px">Your OTP Code</h2>
      <p style="margin:0 0 14px 0;font-size:14px;color:#475467">'.htmlspecialchars($thankLine).'</p>
      <div style="margin:16px 0;font-size:24px;font-weight:bold;letter-spacing:2px;color:#1f2937;background:#eef3ff;border:1px solid #d6dcff;border-radius:10px;display:inline-block;padding:12px 18px">'.$otp.'</div>
      <p style="font-size:14px;color:#334155;margin:12px 0 0">This code will expire in <strong>10 minutes</strong>. Don’t share it with anyone.</p>
    </div>
    <div style="background:#f8fafc;padding:14px 20px;font-size:12px;color:#64748b;text-align:left">© Copyright '.date('Y').' '.$brand.'</div>
  </div>
</body>
</html>';

    $data = [
        "from" => ["address" => $fromEmail, "name" => $fromName],
        "to"   => [["email_address" => ["address" => $email, "name" => ""]]],
        "subject"  => "Your OTP Code",
        "htmlbody" => $html,
        "textbody" => $plain
    ];

    $ch = curl_init("https://api.zeptomail.in/v1.1/email");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => [
            "Authorization: Zoho-enczapikey $apiKey",
            "Content-Type: application/json",
            "Accept: application/json"
        ],
        CURLOPT_POST       => true,
        CURLOPT_POSTFIELDS => json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE),
        CURLOPT_TIMEOUT    => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);

    $resp = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlErr = curl_error($ch);
    curl_close($ch);
    if ($curlErr) {
        $err = "cURL error: $curlErr";
        return false;
    }
    if (!in_array($http, [200, 201, 202])) {
        $err = "Mail API HTTP $http: " . ($resp ?: 'No response body');
        return false;
    }
    return true;
}
function clean($conn, $v){ return mysqli_real_escape_string($conn, trim((string)$v)); }
function go($path){ header("Location: $path"); exit; }

/* ---------- State ---------- */
$mode = $_GET['mode'] ?? ($_SESSION['mode'] ?? 'new'); // 'new' | 'existing' | 'forgot'
if (isset($_GET['mode'])) { $_SESSION['mode'] = $mode; }
$step = $_SESSION['step'] ?? 'email';
$forgot_stage = $_SESSION['forgot_stage'] ?? 'email';
if ($mode==='forgot' && !isset($_SESSION['forgot_stage'])) { $_SESSION['forgot_stage']='email'; $forgot_stage='email'; }
$error = '';
$notice = '';
$prefill_email = $_SESSION['prefill_email'] ?? '';

/* ---------- POST Actions ---------- */
if($_SERVER['REQUEST_METHOD']==='POST'){
    // Switch tabs
    if(isset($_POST['switch_mode'])){
        $mode = $_POST['switch_mode']==='existing' ? 'existing' : 'new';
        $_SESSION['mode'] = $mode;
        if($mode==='new'){ $_SESSION['step']='email'; $step='email'; }
    }

    // NEW APPLICANT
    if($mode==='new'){
        if(isset($_POST['send_otp'])){
            $email = clean($conn, $_POST['email']);
            if(!filter_var($email, FILTER_VALIDATE_EMAIL)){ $error = "Enter a valid email address."; $step='email'; }
            else{
                $_SESSION['email'] = $email;
                $q = mysqli_query($conn, "SELECT id, otp_verified, first_name, last_name, phone, password FROM employees WHERE email='$email' LIMIT 1");
                $user = mysqli_fetch_assoc($q);

                if($user && !empty($user['password'])){
                    $_SESSION['mode'] = 'existing';
                    $mode = 'existing';
                    $_SESSION['prefill_email'] = $email;
                    $prefill_email = $email;
                    $notice = "This email is already registered. Please login below.";
                }else{
                    $otp = rand(100000, 999999);
                    $_SESSION['otp'] = $otp;
                    $_SESSION['otp_time'] = time();
                    $mailErr = null;
                    if(!sendOTP($email, $otp, $mailErr)){
                        $error = "OTP could not be sent: $mailErr.";
                        error_log("[OTP_SEND_FAIL] $mailErr");
                        $step='email';
                    }else{
                        $_SESSION['step'] = 'verify_otp'; $step='verify_otp';
                        $notice = "OTP sent to $email. Please check Inbox/Spam.";
                    }
                }
            }
        }
        elseif(isset($_POST['verify_otp'])){
            $input = trim($_POST['otp'] ?? '');
            if(!isset($_SESSION['otp'])){ $error="OTP expired. Please resend."; $step='email'; }
            elseif(time() - ($_SESSION['otp_time'] ?? 0) > 600){ $error="OTP expired after 10 minutes. Please resend."; $step='email'; }
            elseif($input != $_SESSION['otp']){ $error="Incorrect OTP. Try again."; $step='verify_otp'; }
            else{
                $email = $_SESSION['email'] ?? '';
                if($email!==''){
                    $exists = mysqli_query($conn, "SELECT id FROM employees WHERE email='$email' LIMIT 1");
                    if(mysqli_num_rows($exists)){
                        mysqli_query($conn, "UPDATE employees SET otp_verified=1 WHERE email='$email'");
                    }else{
                        mysqli_query($conn, "INSERT INTO employees (email, otp_verified) VALUES('$email',1)");
                    }
                    $_SESSION['step']='register'; $step='register';
                }else{
                    $error="Session expired. Start again."; $step='email';
                }
            }
        }
        elseif(isset($_POST['resend_otp'])){
            $email = $_SESSION['email'] ?? '';
            if($email===''){ $error="Session expired. Please re-enter your email."; $step='email'; }
            else{
                $otp = rand(100000, 999999);
                $_SESSION['otp'] = $otp;
                $_SESSION['otp_time'] = time();
                $mailErr = null;
                if(!sendOTP($email, $otp, $mailErr)){
                    $error = "OTP could not be re-sent: $mailErr.";
                    error_log("[OTP_RESEND_FAIL] $mailErr");
                    $step='verify_otp';
                }else{
                    $notice = "A new OTP has been sent to $email.";
                    $step='verify_otp';
                }
            }
        }
        elseif(isset($_POST['register_submit'])){
            $first = clean($conn, $_POST['first_name'] ?? '');
            $last  = clean($conn, $_POST['last_name'] ?? '');
            $phone = clean($conn, $_POST['phone'] ?? '');
            $pass  = $_POST['password'] ?? '';

            if($first===''||$last===''||$phone===''||$pass===''){ $error="All fields are required."; $step='register'; }
            elseif(!preg_match('/^[6-9]\d{9}$/', $phone)){ $error="Enter a valid 10-digit mobile number (starts with 6-9)."; $step='register'; }
            else{
                $hash = password_hash($pass, PASSWORD_DEFAULT);
                $email = $_SESSION['email'] ?? '';
                if($email===''){ $error="Session expired. Start again."; $step='email'; }
                else{
                    $q = mysqli_query($conn, "SELECT id FROM employees WHERE email='$email' LIMIT 1");
                    if(mysqli_num_rows($q)){
                        $sql = "UPDATE employees SET first_name='$first', last_name='$last', phone='$phone', password='$hash', otp_verified=1 WHERE email='$email'";
                    }else{
                        $sql = "INSERT INTO employees (first_name,last_name,phone,email,password,otp_verified) VALUES('$first','$last','$phone','$email','$hash',1)";
                    }
                    if(mysqli_query($conn,$sql)){
                        $_SESSION['employee_logged_in']=true;
                        $_SESSION['employee_name']="$first $last";
                        $_SESSION['phone']=$phone;
                        unset($_SESSION['otp'],$_SESSION['otp_time'],$_SESSION['step']);
                        go(BASE_URL.'employee/employee-app');
                    }else{
                        $error="Database error: ".mysqli_error($conn); $step='register';
                    }
                }
            }
        }
        elseif(isset($_POST['login_submit_new'])){
            $email = $_SESSION['email'] ?? '';
            $pass  = $_POST['password'] ?? '';
            if($email===''){ $error="Start with your email first."; $step='email'; }
            else{
                $r = mysqli_query($conn, "SELECT * FROM employees WHERE email='$email' LIMIT 1");
                $u = mysqli_fetch_assoc($r);
                if($u && password_verify($pass, $u['password'])){
                    $_SESSION['employee_logged_in']=true;
                    $_SESSION['employee_name']=$u['first_name'].' '.$u['last_name'];
                    $_SESSION['phone']=$u['phone'];
                    unset($_SESSION['otp'],$_SESSION['otp_time'],$_SESSION['step']);
                    go(BASE_URL.'employee/employee-app');
                }else{ $error="Incorrect password."; $step='password'; }
            }
        }
    }

    // EXISTING APPLICANT
    if($mode==='existing'){
        if(isset($_POST['login_submit'])){
            $email = clean($conn, $_POST['email'] ?? '');
            $pass  = $_POST['password'] ?? '';
            if(!filter_var($email, FILTER_VALIDATE_EMAIL) || $pass===''){ $error="Enter valid email and password."; }
            else{
                $r = mysqli_query($conn, "SELECT * FROM employees WHERE email='$email' LIMIT 1");
                if(!mysqli_num_rows($r)){
                    // Email not found -> redirect to New Applicant with prefill
                    $_SESSION['mode'] = 'new';
                    $_SESSION['step'] = 'email';
                    $_SESSION['email'] = $email;
                    $mode = 'new'; $step='email';
                    $notice = "Email not found. Please start as a New Applicant.";
                }else{
                    $u = mysqli_fetch_assoc($r);
                    if($u && password_verify($pass, $u['password'])){
                        $_SESSION['employee_logged_in']=true;
                        $_SESSION['employee_name']=$u['first_name'].' '.$u['last_name'];
                        $_SESSION['phone']=$u['phone'];
                        $_SESSION['email']=$u['email'];
                        go(BASE_URL.'employee/employee-app');
                    }else{ $error="Invalid credentials."; }
                }
            }
        }
        if(isset($_POST['goto_forgot'])){ $mode='forgot'; $_SESSION['mode']='forgot'; $_SESSION['forgot_stage']='email'; $forgot_stage='email'; }
    }

    // FORGOT PASSWORD
    if($mode==='forgot'){
        if(isset($_POST['forgot_send_otp'])){
            $email = clean($conn, $_POST['email']);
            if(!filter_var($email, FILTER_VALIDATE_EMAIL)){ $error="Enter a valid email."; $forgot_stage='email'; }
            else{
                $r = mysqli_query($conn, "SELECT id FROM employees WHERE email='$email' LIMIT 1");
                if(!mysqli_num_rows($r)){
                    // Email not found -> redirect to New Applicant with prefill
                    $_SESSION['mode']='new'; $_SESSION['step']='email'; $_SESSION['email']=$email;
                    $mode='new'; $step='email';
                    $notice="Email not found. Please create an account as a New Applicant.";
                }else{
                    $_SESSION['forgot_email']=$email;
                    $otp = rand(100000,999999);
                    $_SESSION['forgot_otp']=$otp;
                    $_SESSION['forgot_time']=time();
                    $mailErr = null;
                    if(!sendOTP($email,$otp,$mailErr)){
                        $error = "OTP could not be sent: $mailErr.";
                        error_log("[FP_OTP_FAIL] $mailErr");
                        $forgot_stage='email';
                    }else{
                        $_SESSION['forgot_stage']='verify'; $forgot_stage='verify';
                        $notice = "OTP sent to $email.";
                    }
                }
            }
        }elseif(isset($_POST['forgot_verify'])){
            $in = trim($_POST['otp'] ?? '');
            if(!isset($_SESSION['forgot_otp'])){ $error="OTP expired. Try again."; $forgot_stage='email'; }
            elseif(time()-($_SESSION['forgot_time']??0) > 600){ $error="OTP expired after 10 minutes. Try again."; $forgot_stage='email'; }
            elseif($in != $_SESSION['forgot_otp']){ $error="Incorrect OTP."; $forgot_stage='verify'; }
            else{ $_SESSION['forgot_stage']='reset'; $forgot_stage='reset'; }
        }elseif(isset($_POST['forgot_reset'])){
            $p1 = $_POST['password'] ?? '';
            $p2 = $_POST['password2'] ?? '';
            if($p1==='' || strlen($p1)<6){ $error="Password must be at least 6 characters."; $forgot_stage='reset'; }
            elseif($p1!==$p2){ $error="Passwords do not match."; $forgot_stage='reset'; }
            else{
                $email = $_SESSION['forgot_email'] ?? '';
                if($email===''){ $error="Session expired. Start again."; $forgot_stage='email'; }
                else{
                    $hash = password_hash($p1, PASSWORD_DEFAULT);
                    if(mysqli_query($conn, "UPDATE employees SET password='$hash' WHERE email='$email'")){
                        unset($_SESSION['forgot_email'],$_SESSION['forgot_otp'],$_SESSION['forgot_time'],$_SESSION['forgot_stage']);
                        $_SESSION['mode']='existing'; $mode='existing';
                        $_SESSION['prefill_email']=$email; $prefill_email=$email;
                        $notice="Password reset successful. Please login.";
                    }else{ $error="Database error: ".mysqli_error($conn); $forgot_stage='reset'; }
                }
            }
        }
        if(isset($_POST['back_to_login'])){ $_SESSION['mode']='existing'; $mode='existing'; }
    }
    $_SESSION['mode']=$mode;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>employee Access</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
<style>
:root{
  --text:#0f172a; --muted:#667085; --chipBg:#fff3cd; --chipText:#1f2937;
  --brandV:#6a11cb; --brandB:#2575fc;
}
/* Sky background + clouds */
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins',sans-serif}
html,body{height:100%}
body{background:linear-gradient(135deg,#e9f2ff 0%,#eef9ff 50%,#f5faff 100%);overflow-x:hidden}
.bg-anim,.bg-clouds{position:fixed;inset:-10%;pointer-events:none;z-index:-2}
.bg-anim{
  background: radial-gradient(120% 80% at 10% 0%, #c7d2fe 0%, transparent 60%),
              radial-gradient(120% 80% at 90% 100%, #bae6fd 0%, transparent 65%),
              linear-gradient(120deg,#c7d2fe 0%, #93c5fd 40%, #a7f3d0 80%, #c7d2fe 100%);
  filter:hue-rotate(0deg); animation:hue 30s linear infinite;
}
@keyframes hue{0%{filter:hue-rotate(0)}50%{filter:hue-rotate(25deg)}100%{filter:hue-rotate(0)}}
.bg-clouds{
  z-index:-1;
  background:
    radial-gradient(closest-side, rgba(255,255,255,.8), rgba(255,255,255,0)) 0 0/400px 200px,
    radial-gradient(closest-side, rgba(255,255,255,.7), rgba(255,255,255,0)) 200px 120px/420px 240px,
    radial-gradient(closest-side, rgba(255,255,255,.6), rgba(255,255,255,0)) 600px -40px/380px 220px;
  animation: clouds 50s linear infinite; opacity:.6;
}
@keyframes clouds{0%{background-position:0 0,200px 120px,600px -40px}100%{background-position:1200px 0,1400px 120px,1800px -40px}}

.wrapper{max-width:1100px;margin:32px auto;padding:0 16px}

/* Layout */
.card{display:flex;gap:28px;align-items:stretch}
.left{
  flex:1; min-height:420px; border-radius:18px; padding:40px; color:#fff; position:relative; overflow:hidden;
  background: radial-gradient(300px 300px at -10% -10%, #ffffff33 0%, transparent 60%),
              radial-gradient(220px 220px at 110% 110%, #ffffff26 0%, transparent 60%),
              linear-gradient(135deg, var(--brandV), var(--brandB));
  box-shadow: 0 20px 50px rgba(2,6,23,.10);
}
.left h1{font-size:40px;margin-bottom:8px;font-weight:700}
.left p{opacity:.95}

/* Login card with 3D hover glow */
.right{
  flex:1; position:relative; padding:2px; border-radius:22px;
  background: linear-gradient(135deg, #a78bfa, #60a5fa);
  box-shadow: 0 24px 60px rgba(37,99,235,.18), 0 0 0 6px rgba(96,165,250,.12) inset;
  transition: transform .25s ease, box-shadow .25s ease, filter .25s ease;
}
.right:hover{ transform: translateY(-2px); box-shadow: 0 28px 70px rgba(37,99,235,.26), 0 0 0 8px rgba(96,165,250,.16) inset; filter: saturate(1.05); }
.inner{
  position:relative; z-index:1; background:#ffffff; border-radius:20px; padding:24px 24px 28px; min-height:420px;
  box-shadow: 0 14px 34px rgba(2,6,23,.10), 0 6px 18px rgba(37,99,235,.10);
}

/* Tabs above login box */
.tabs{display:flex;gap:12px;margin-bottom:14px;flex-wrap:wrap}
.tab{display:inline-flex;align-items:center;gap:10px;padding:10px 14px;border-radius:12px;cursor:pointer;border:2px solid transparent;font-weight:600;transition:.25s;box-shadow:0 6px 16px rgba(17,24,39,.08)}
.tab.new{background:#06b6d4;color:#fff}
.tab.existing{background:#facc15;color:#111}
.tab.outline{background:#ffffff;color:#111;border-color:#e5e7eb}

h2{font-size:26px;margin:4px 0 6px;color:var(--text)}
.subtitle{font-size:14px;color:#667085;margin-bottom:14px}

/* Inputs */
.form-group{margin-bottom:16px}
label{display:block;font-size:13px;color:#475467;margin-bottom:6px}
input[type=email],input[type=password],input[type=text]{
  width:100%;padding:12px 14px;border:none;border-radius:12px;outline:none;transition:.2s;font-size:14px;background:#eef3f9;color:var(--text);
  box-shadow: inset 7px 7px 14px rgba(2,6,23,.06), inset -7px -7px 14px rgba(255,255,255,.95);
}
input:focus{box-shadow: inset 5px 5px 10px rgba(2,6,23,.07), inset -5px -5px 10px rgba(255,255,255,.98), 0 0 0 4px rgba(124,58,237,.15)}

/* Buttons with hover glow */
.btn{
  width:100%;padding:12px 14px;border:none;border-radius:12px;background:linear-gradient(135deg,var(--brandV),var(--brandB));color:#fff;font-weight:700;cursor:pointer;transition:.2s;
  box-shadow: 0 10px 24px rgba(37,99,235,.25), 0 0 24px rgba(124,58,237,.20);
}
.btn:hover{filter:brightness(1.06);transform:translateY(-1px);box-shadow: 0 14px 30px rgba(37,99,235,.32), 0 0 34px rgba(124,58,237,.26)}
.row{display:flex;gap:12px}
.alert{padding:10px 12px;border-radius:12px;font-size:13px;margin-bottom:12px}
.alert.error{background:#fee2e2;color:#7f1d1d;border:1px solid #fecaca}
.alert.notice{background:#ecfeff;color:#0c4a6e;border:1px solid #a5f3fc}
.actions{display:flex;justify-content:space-between;align-items:center;margin-top:8px}
.link{font-size:13px;color:#4338ca;text-decoration:none}
.email-chip{font-weight:700;background:var(--chipBg);color:var(--chipText);padding:2px 6px;border-radius:6px}

/* Help strip (IVR) */
.help-strip{margin-top:18px;padding-top:14px;border-top:1px dashed #e5e7eb;display:flex;gap:10px;align-items:center;justify-content:space-between;flex-wrap:wrap}
.help-strip .text{font-size:13px;color:#475467}
.help-strip .tel{display:inline-block;padding:8px 12px;border-radius:999px;background:linear-gradient(135deg,#22c55e,#16a34a);color:#fff;text-decoration:none;font-weight:700;box-shadow:0 10px 22px rgba(22,163,74,.25)}

@media (max-width: 980px){ .card{flex-direction:column} .left{display:none} .inner{min-height:auto} }
@media (max-width: 540px){ .tab{padding:8px 12px} }
</style>
</head>
<body>
<div class="bg-anim"></div><div class="bg-clouds"></div>

<div class="wrapper">
    <div class="card">
        <div class="left">
            <h1>Welcome</h1>
            <p>Sign in to your account</p>
        </div>

        <div class="right">
            <div class="inner">
                <form method="post" class="tabs">
                    <button name="switch_mode" value="new"      type="submit" class="tab new<?= ($mode==='new'?'':' outline') ?>">👥 New Applicant</button>
                    <button name="switch_mode" value="existing" type="submit" class="tab existing<?= ($mode==='existing'?'':' outline') ?>">👤 Already Applied</button>
                </form>

                <h2>Hello!</h2>
                <div class="subtitle" id="greet">Good Morning</div>

                <?php if($error!==''): ?>
                    <div class="alert error"><?= htmlspecialchars($error) ?></div>
                <?php endif; ?>
                <?php if($notice!==''): ?>
                    <div class="alert notice"><?= htmlspecialchars($notice) ?></div>
                <?php endif; ?>

                <?php if($mode==='new'): ?>
                    <?php if($step==='email'): ?>
                        <form method="post">
                            <div class="form-group">
                                <label>Email Address</label>
                                <input type="email" name="email" value="<?= htmlspecialchars($_SESSION['email'] ?? '') ?>" required>
                            </div>
                            <button class="btn" name="send_otp">Send OTP / Password</button>
                            <div class="actions"><span class="subtitle" style="margin:0">Already registered?</span><a class="link" href="?mode=existing">Login here</a></div>
                        </form>
                    <?php elseif($step==='verify_otp'): ?>
                        <form method="post">
                            <div class="form-group">
                                <label>Enter OTP sent to <span class="email-chip"><?= htmlspecialchars($_SESSION['email'] ?? '') ?></span></label>
                                <input type="text" name="otp" maxlength="6" pattern="\d{6}" oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,6)" required>
                            </div>
                            <button class="btn" name="verify_otp">Verify OTP</button>
                            <div class="actions">
                                <button class="link" name="resend_otp" style="background:none;border:none;cursor:pointer">Resend OTP</button>
                                <a class="link" href="?mode=new">Change Email</a>
                            </div>
                        </form>
                    <?php elseif($step==='register'): ?>
                        <form method="post">
                            <div class="row">
                                <div class="form-group" style="flex:1">
                                    <label>First Name</label>
                                    <input type="text" name="first_name" required>
                                </div>
                                <div class="form-group" style="flex:1">
                                    <label>Last Name</label>
                                    <input type="text" name="last_name" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Mobile Number (India)</label>
                                <input type="text" name="phone" maxlength="10" pattern="^[6-9]\d{9}$" oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,10)" required>
                            </div>
                            <div class="form-group">
                                <label>Create Password</label>
                                <input type="password" name="password" minlength="6" required>
                            </div>
                            <button class="btn" name="register_submit">Complete Registration</button>
                        </form>
                    <?php elseif($step==='password'): ?>
                        <form method="post">
                            <div class="form-group">
                                <label>Password for <span class="email-chip"><?= htmlspecialchars($_SESSION['email'] ?? '') ?></span></label>
                                <input type="password" name="password" required>
                            </div>
                            <button class="btn" name="login_submit_new">Login</button>
                            <div class="actions"><a class="link" href="?mode=forgot">Forgot password?</a></div>
                        </form>
                    <?php endif; ?>
                <?php elseif($mode==='existing'): ?>
                    <form method="post">
                        <div class="form-group">
                            <label>Email Address</label>
                            <input type="email" name="email" value="<?= htmlspecialchars($prefill_email) ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" required>
                        </div>
                        <button class="btn" name="login_submit">Login</button>
                        <div class="actions">
                            <a class="link" href="#" onclick="event.preventDefault();document.getElementById('fp_existing').value='1'; this.closest('form').submit();">Forgot password?</a>
                            <input type="hidden" id="fp_existing" name="goto_forgot" value="">
                        </div>
                    </form>
                <?php elseif($mode==='forgot'): ?>
                    <?php if($forgot_stage==='email'): ?>
                        <form method="post">
                            <div class="form-group">
                                <label>Enter your registered Email</label>
                                <input type="email" name="email" required>
                            </div>
                            <button class="btn" name="forgot_send_otp">Send OTP</button>
                            <div class="actions"><button class="link" name="back_to_login" style="background:none;border:none;cursor:pointer">Back to Login</button></div>
                        </form>
                    <?php elseif($forgot_stage==='verify'): ?>
                        <form method="post">
                            <div class="form-group">
                                <label>Enter OTP sent to <span class="email-chip"><?= htmlspecialchars($_SESSION['forgot_email'] ?? '') ?></span></label>
                                <input type="text" name="otp" maxlength="6" pattern="\d{6}" oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,6)" required>
                            </div>
                            <button class="btn" name="forgot_verify">Verify OTP</button>
                            <div class="actions"><button class="link" name="back_to_login" style="background:none;border:none;cursor:pointer">Back to Login</button></div>
                        </form>
                    <?php elseif($forgot_stage==='reset'): ?>
                        <form method="post">
                            <div class="form-group">
                                <label>New Password</label>
                                <input type="password" name="password" minlength="6" required>
                            </div>
                            <div class="form-group">
                                <label>Confirm Password</label>
                                <input type="password" name="password2" minlength="6" required>
                            </div>
                            <button class="btn" name="forgot_reset">Reset Password</button>
                            <div class="actions"><button class="link" name="back_to_login" style="background:none;border:none;cursor:pointer">Back to Login</button></div>
                        </form>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Help strip (visible on both desktop and mobile) -->
                <!-- <div class="help-strip">
                    <div class="text">For brorisers assistance, call IVR:</div>
                    <a class="tel" href="tel:9643004778">9643004778</a>
                </div> -->
            </div>
        </div>
    </div>
</div>

<script>
// Dynamic greeting from user's local time
(function(){
    var h = new Date().getHours(), t = "Good Morning";
    if(h >= 12 && h < 17) t = "Good Afternoon";
    else if(h >= 17 && h < 21) t = "Good Evening";
    else if(h >= 21 || h < 5) t = "Good Night";
    var el = document.getElementById('greet'); if(el) el.textContent = t;
})();
</script>
</body>
</html>
