<?php
require '../../config.php';

if (!isset($_SESSION['email'])) {
  header("Location: " . BASE_URL . "employee/login");
  exit;
}

$email = mysqli_real_escape_string($conn, $_SESSION['email']);
$errors = [];
$success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_profile'])) {
  $first_name = trim($_POST['first_name'] ?? '');
  $last_name = trim($_POST['last_name'] ?? '');
  $phone = trim($_POST['phone'] ?? '');

  if ($first_name === '') $errors[] = "First name is required.";
  if ($last_name === '') $errors[] = "Last name is required.";
  if ($phone === '') $errors[] = "Phone number is required.";

  if (empty($errors)) {
    $stmt = mysqli_prepare($conn, "UPDATE employees SET first_name=?, last_name=?, phone=? WHERE email=?");
    mysqli_stmt_bind_param($stmt, 'ssss', $first_name, $last_name, $phone, $email);
    if (mysqli_stmt_execute($stmt)) {
      $success = "Profile updated successfully.";
    } else {
      $errors[] = "Error updating profile.";
    }
    mysqli_stmt_close($stmt);
  }
}

$employee = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM employees WHERE email='$email'"));
$application = null;
$pp = null;
$application_status = null;
?>

<!-- Header -->
<div class="app-topstrip bg-dark py-2 px-4 w-100 d-flex align-items-center justify-content-between">
  <div class="d-flex align-items-center gap-3">
    <a class="nav-link sidebartoggler d-block d-xl-none text-white" id="headerCollapse" href="javascript:void(0)">
      <i class="ti ti-menu-2 fs-4"></i>
    </a>
    <a class="d-flex justify-content-center" href="#" target="_blank" 
      style="background: white; border-radius: 12px; display: inline-block; width: 70px; height: auto;">
      <img src="<?= BASE_URL ?>assets/images/logos/logo.png" alt="Logo" width="65" height="50px" style="display: block; border-radius: 12px;">
    </a>
  </div>
  <div class="flex-grow-1 d-none d-md-block px-3">
      <div class="scrolling-text-container w-100 overflow-hidden position-relative" style="height: 20px;">
        <div class="scrolling-text text-white position-absolute" style="white-space: nowrap;">
          📢 Investors-Clinic Open for employee registration – Apply Now!
        </div>
      </div>
    </div>
  <div class="d-flex align-items-center gap-3">
    <div class="dropdown">
      <a class="all-access-pass-btn rounded btn btn-primary d-flex align-items-center justify-content-center gap-2 fs-4 border-0 text-black px-3 py-2 dropdown-toggle" href="#" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
        Profile
      </a>
      <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
        <li>
          <a class="dropdown-item d-flex align-items-center gap-3" href="#">
            <img src="<?= $pp ?: BASE_URL . 'assets/images/profile/user-1.jpg' ?>" width="40" height="40" class="rounded-circle border">
            <div>
              <div class="fw-semibold"><?= htmlspecialchars(($employee['first_name'] ?? '') . ' ' . ($employee['last_name'] ?? '')) ?></div>
              <div class="small text-muted"><?= htmlspecialchars($employee['email'] ?? 'No email') ?></div>
            </div>
          </a>
        </li>
        <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#editProfileModal">Account</a></li>
        <li><hr class="dropdown-divider"></li>
        <li><a class="dropdown-item" href="<?= BASE_URL ?>employee/logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="editProfileModal" tabindex="-1" aria-labelledby="editProfileModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <form method="POST">
         <input type="hidden" name="update_profile" value="1">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title" id="editProfileModalLabel">Edit Profile</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
          <?php endif; ?>
          <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
              <?php foreach ($errors as $error): echo htmlspecialchars($error) . "<br>"; endforeach; ?>
            </div>
          <?php endif; ?>

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">First Name</label>
              <input type="text" class="form-control" name="first_name" value="<?= htmlspecialchars($employee['first_name']) ?>" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Last Name</label>
              <input type="text" class="form-control" name="last_name" value="<?= htmlspecialchars($employee['last_name']) ?>" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Phone</label>
              <input type="text" class="form-control" name="phone" value="<?= htmlspecialchars($employee['phone']) ?>" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Email (readonly)</label>
              <input type="email" class="form-control" value="<?= htmlspecialchars($employee['email']) ?>" readonly>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <a href="#" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#editProfileModal" onclick="event.preventDefault();">Update Accout</a>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Auto-open modal on submit (optional) -->
<?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
<script>
  const profileModal = new bootstrap.Modal(document.getElementById('editProfileModal'));
  profileModal.show();
</script>
<?php endif; ?>
