<?php
// ---- employee Sidebar (WrapPixel style, matches Admin look) ----
// Requirements honored: uses ../../config.php for DB connection; mysqli (no PDO)

require '../../config.php';

// Resolve current file/slug robustly (handles trailing slashes)
$uriPath      = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uriParts     = array_values(array_filter(explode('/', trim($uriPath, '/'))));
$current_file = end($uriParts) ?: 'dashboard'; // default if path ends with '/'

// employee name + initial (fallbacks)
$employeeName    = isset($_SESSION['employee_name']) && $_SESSION['employee_name'] !== '' ? $_SESSION['employee_name'] : 'employee';
$employeeInitial = strtoupper(mb_substr($employeeName, 0, 1));

// Helper: active state check for links where URL ends with these slugs
function isActive($slug, $curr) {
  if ($slug === $curr) return true;
  // Also consider common aliases
  $map = [
    'dashboard'       => ['dashboard','index'],
    'employee-app'   => ['employee-app','application','apply','broriser','employee-broriser','employee-application'],
    'profile'         => ['doc_by_hr', 'index'],
    'Document By HR'         => ['profile','my-profile','account'],
    'change_password' => ['change_password','change-password','password','reset-password']
  ];
  foreach ($map as $key => $arr) {
    if ($slug === $key && in_array($curr, $arr, true)) return true;
  }
  return false;
}
?>
<style>
  /* Make text readable (light theme), align with Admin look */
  .left-sidebar { background: #ffffff; border-right: 1px solid rgba(0,0,0,.06); }
  .left-sidebar .brand-logo a { color: #212529; }
  .left-sidebar .logo-img-initial {
    display:inline-flex; align-items:center; justify-content:center;
    width:32px; height:32px; border-radius:8px; font-weight:700;
  }
  .left-sidebar .sidebar-link { color:#212529 !important; border-radius:10px; }
  .left-sidebar .sidebar-link.active,
  .left-sidebar .sidebar-link:hover { background: rgba(13,110,253,.1); }
  .left-sidebar .nav-small-cap { font-size:.75rem; text-transform:uppercase; letter-spacing:.04em; color:#6c757d; }
  .left-sidebar .brand-logo { position:relative; }
  .left-sidebar .btn#sidebarCloseBtn {
    position:absolute; top:10px; right:10px; cursor:pointer; z-index:1051;
    font-size:1.5rem; line-height:1; border:none; background:transparent; color:#333;
  }
  /* Tiny dot before child items if ever added */
  .left-sidebar .icon-small {
    display:inline-block; width:6px; height:6px; border-radius:50%; background:currentColor; opacity:.4;
  }
  /* Color pickers row */
  .left-sidebar .theme-row label { font-size:.75rem; color:#6c757d; }
</style>

<aside class="left-sidebar">
  <div>
    <div class="brand-logo d-flex align-items-center justify-content-between px-3 py-2">
      <a href="<?= BASE_URL ?>employee/dashboard" class="text-nowrap logo-img d-flex align-items-center gap-2 text-decoration-none">
        <span class="logo-img-initial bg-primary text-white"><?= htmlspecialchars($employeeInitial) ?></span>
        <span class="fw-semibold text-dark text-truncate">Welcome, <?= htmlspecialchars($employeeName) ?></span>
      </a>
      <button id="sidebarCloseBtn" class="btn btn-sm d-xl-none" aria-label="Close sidebar">&times;</button>
    </div>

    <nav class="sidebar-nav scroll-sidebar" data-simplebar>
      <ul id="sidebarnav" class="text-dark mb-3">
        <li class="nav-small-cap px-3 mt-2">Menu</li>
          <li class="sidebar-item px-2">
            <a class="sidebar-link d-flex align-items-center gap-2 py-2 px-3 <?= isActive('dashboard', $current_file) ? 'active' : '' ?>"
              href="<?= BASE_URL ?>employee/dashboard" aria-expanded="false">
              <iconify-icon icon="mdi:view-dashboard-outline" class="fs-5"></iconify-icon>
              <span class="hide-menu text-dark">Dashboard</span>
            </a>
          </li>

          <li class="sidebar-item px-2">
            <a class="sidebar-link d-flex align-items-center gap-2 py-2 px-3 <?= isActive('employee-app', $current_file) ? 'active' : '' ?>"
              href="<?= BASE_URL ?>employee/employee-app" aria-expanded="false">
              <iconify-icon icon="mdi:form-textbox" class="fs-5"></iconify-icon>
              <span class="hide-menu text-dark">Employee Form</span>
            </a>
          </li>

          <li class="sidebar-item px-2">
            <a class="sidebar-link d-flex align-items-center gap-2 py-2 px-3 <?= isActive('change_password', $current_file) ? 'active' : '' ?>"
              href="<?= BASE_URL ?>employee/change_password" aria-expanded="false">
              <iconify-icon icon="mdi:lock-reset" class="fs-5"></iconify-icon>
              <span class="hide-menu text-dark">Change Password</span>
            </a>
          </li>
          <li class="sidebar-item px-2">
              <a class="sidebar-link d-flex align-items-center gap-2 py-2 px-3 <?= isActive('doc-by-hr', $current_file) ? 'active' : '' ?>"
                href="<?= BASE_URL ?>employee/doc-by-hr" aria-expanded="false">
                  <iconify-icon icon="mdi:file-document" class="fs-5"></iconify-icon>
                  <span class="hide-menu text-dark">Document By HR</span>
              </a>
          </li>
          <li class="sidebar-item px-2">
            <a class="sidebar-link d-flex align-items-center gap-2 py-2 px-3"
              href="<?= BASE_URL ?>employee/logout.php" aria-expanded="false">
              <iconify-icon icon="mdi:logout" class="fs-5"></iconify-icon>
              <span class="hide-menu text-dark">Logout</span>
            </a>
          </li>
      </ul>

      <!-- Optional: Theme controls (kept like Admin) -->
      <div class="px-3 pb-3">
        <div class="row g-2 align-items-center theme-row">
          <div class="col-6">
            <label class="form-label mb-1" for="sbBgS">BG</label>
            <input type="color" id="sbBgS" class="form-control form-control-color w-100" value="#ffffff" title="Sidebar background">
          </div>
          <div class="col-6">
            <label class="form-label mb-1" for="sbTxtS">Text</label>
            <input type="color" id="sbTxtS" class="form-control form-control-color w-100" value="#212529" title="Sidebar text color">
          </div>
        </div>
      </div>
    </nav>
  </div>
</aside>

<script>
// Align behavior with Admin sidebar: high-contrast text, mini toggle persistence, theme, mobile close
window.addEventListener('load', function () {
  // Force readable text classes
  document.querySelectorAll('.left-sidebar .sidebar-link, .left-sidebar .hide-menu, .left-sidebar .nav-small-cap')
    .forEach(el => { el.classList.add('text-dark','fw-semibold'); });

  // Mini-sidebar toggle persistence (uses same #main-wrapper class convention)
  const WRAP  = document.getElementById('main-wrapper') || document.querySelector('.page-wrapper');
  const MINI_KEY = 'wrap:mini:employee';

  function applyMiniFromStorage() {
    try {
      if (localStorage.getItem(MINI_KEY) === '1') {
        WRAP && WRAP.classList.add('mini-sidebar');
      } else {
        WRAP && WRAP.classList.remove('mini-sidebar');
      }
    } catch (e) {}
  }
  applyMiniFromStorage();

  // If there is a global toggle button elsewhere with these IDs, wire it up too (safe no-op otherwise)
  const BTN = document.getElementById('btnSidebarMini');
  BTN && BTN.addEventListener('click', function(){
    if (!WRAP) return;
    WRAP.classList.toggle('mini-sidebar');
    const isMini = WRAP.classList.contains('mini-sidebar');
    try { localStorage.setItem(MINI_KEY, isMini ? '1' : '0'); } catch(e){}
  });

  // Mobile close button -> collapse to mini
  const closeBtn = document.getElementById('sidebarCloseBtn');
  closeBtn && closeBtn.addEventListener('click', function() {
    if (!WRAP) return;
    WRAP.classList.remove('show-sidebar');
    WRAP.classList.add('mini-sidebar');
    try { localStorage.setItem(MINI_KEY, '1'); } catch(e){}
  });

  // Theme (BG/Text) like Admin
  const sidebar = document.querySelector('.left-sidebar');
  const bg = document.getElementById('sbBgS');
  const tx = document.getElementById('sbTxtS');
  const KBG='sb:bg:employee', KTX='sb:txt:employee';

  function applyTheme() {
    if (!sidebar) return;
    if (bg) sidebar.style.backgroundColor = bg.value || '';
    if (tx) {
      sidebar.style.color = tx.value || '';
      sidebar.querySelectorAll('.sidebar-link,.hide-menu,.nav-small-cap,iconify-icon').forEach(el => {
        el.style.color = tx.value || '';
      });
    }
  }

  try {
    const sbg = localStorage.getItem(KBG), stx = localStorage.getItem(KTX);
    if (sbg) bg.value = sbg;
    if (stx) tx.value = stx;
    applyTheme();
  } catch(e){}

  bg && bg.addEventListener('input', () => { applyTheme(); try{localStorage.setItem(KBG, bg.value);}catch(e){} });
  tx && tx.addEventListener('input', () => { applyTheme(); try{localStorage.setItem(KTX, tx.value);}catch(e){} });
});
</script>
