<?php
/* ============================================================================
 * File   : config.php
 * Purpose: Central DB connection (MySQLi, NO PDO) + basic settings
 * Notes  : - Update DB credentials as per your server.
 *          - All tables MUST use utf8mb4_general_ci collation.
 * ========================================================================== */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

date_default_timezone_set('Asia/Kolkata');

/* --------- DB credentials (EDIT HERE) ---------- */
$DB_HOST = 'localhost';
$DB_USER = 'root';
$DB_PASS = '';
$DB_NAME = 'code_editor';

/* --------- Create connection (MySQLi) ---------- */
$conn = mysqli_connect($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

if (!$conn) {
    die('Database connection failed: ' . mysqli_connect_error());
}

/* --------- Charset & Collation ----------------- */
mysqli_set_charset($conn, 'utf8mb4');
mysqli_query($conn, "SET collation_connection = 'utf8mb4_general_ci'");

/* --------- Base path helpers ------------------- */
$APP_ROOT = rtrim(str_replace('\\', '/', __DIR__), '/');
$APP_URL  = ''; // You can set this manually if needed.

?>
