<?php
/* ============================================================================
 * File   : dashboard.php
 * Purpose: List projects available to current user
 * ========================================================================== */
require_once __DIR__ . '/functions.php';
require_login();
$user = current_user();

$projects = get_projects_for_user($conn, $user);
?>
<?php include __DIR__ . '/header.php'; ?>

<h2>Projects</h2>

<?php if ($user['role'] === 'admin'): ?>
    <p>
        <a class="btn btn-success" href="project_create.php">+ Create New Project</a>
    </p>
<?php endif; ?>

<table class="table">
    <tr>
        <th>ID</th>
        <th>Name</th>
        <th>Base Path</th>
        <th>Base URL</th>
        <th>Created</th>
        <th>Actions</th>
    </tr>
    <?php if (empty($projects)): ?>
        <tr><td colspan="6">No projects available.</td></tr>
    <?php else: ?>
        <?php foreach ($projects as $p): ?>
            <tr>
                <td><?php echo (int)$p['id']; ?></td>
                <td><?php echo h($p['name']); ?></td>
                <td><?php echo h($p['base_path']); ?></td>
                <td><?php echo h($p['base_url']); ?></td>
                <td><?php echo h($p['created_at']); ?></td>
                <td>
                    <?php if ($user['role'] === 'admin'): ?>
                        <a class="btn btn-secondary" href="project_files.php?project_id=<?php echo (int)$p['id']; ?>">Files &amp; Permissions</a>
                    <?php endif; ?>
                    <a class="btn btn-primary" href="editor.php?project_id=<?php echo (int)$p['id']; ?>">Open Editor</a>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php endif; ?>
</table>

<?php include __DIR__ . '/footer.php'; ?>
