<?php
/* ============================================================================
 * File   : header.php
 * Purpose: Simple top navigation
 * ========================================================================== */
require_once __DIR__ . '/functions.php';
$user = current_user();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Project Code Editor</title>
<style>
body {
    margin:0;
    font-family:Arial, sans-serif;
    background:#181818;
    color:#eee;
}
.topbar {
    background:#222;
    padding:10px 20px;
    display:flex;
    justify-content:space-between;
    align-items:center;
}
.topbar .left span {
    font-weight:bold;
}
.topbar a {
    color:#eee;
    margin-left:10px;
    text-decoration:none;
}
.topbar a:hover {
    text-decoration:underline;
}
.content {
    padding:20px;
}
.table {
    width:100%;
    border-collapse:collapse;
    margin-top:10px;
}
.table th, .table td {
    border:1px solid #444;
    padding:8px;
    font-size:13px;
}
.table th {
    background:#333;
}
.btn {
    display:inline-block;
    padding:6px 10px;
    border-radius:4px;
    text-decoration:none;
    font-size:13px;
    margin:2px 0;
}
.btn-primary { background:#007bff; color:#fff; }
.btn-success { background:#28a745; color:#fff; }
.btn-warning { background:#ffc107; color:#000; }
.btn-danger  { background:#dc3545; color:#fff; }
.btn-secondary { background:#6c757d; color:#fff; }
input[type="text"], input[type="file"], select {
    padding:6px;
    border-radius:4px;
    border:1px solid #555;
    background:#111;
    color:#eee;
    font-size:13px;
}
label {
    font-size:13px;
}
.form-group {
    margin-bottom:8px;
}
</style>
</head>
<body>
<div class="topbar">
    <div class="left">
        <span>Project Code Editor</span>
        <?php if ($user): ?>
            <span style="font-size:12px; margin-left:10px;">
                Logged in as: <?php echo h($user['name']); ?> (<?php echo h($user['role']); ?>)
            </span>
        <?php endif; ?>
    </div>
    <div class="right">
        <?php if ($user): ?>
            <a href="dashboard.php">Dashboard</a>
            <?php if ($user['role'] === 'admin'): ?>
                <a href="users.php">Users</a>
                <a href="project_create.php">New Project</a>
            <?php endif; ?>
            <a href="logout.php">Logout</a>
        <?php else: ?>
            <a href="login.php">Login</a>
        <?php endif; ?>
    </div>
</div>
<div class="content">
