<?php
/* ============================================================================
 * File   : login.php
 * Purpose: Simple login form for Code Editor
 * Notes  : On first run, if no users exist, creates default admin:
 *          email: admin@example.com / password: admin123
 * ========================================================================== */
require_once __DIR__ . '/functions.php';

// Auto-create default admin if no users
$cntRes = mysqli_query($conn, "SELECT COUNT(*) AS c FROM users");
$rowCnt = $cntRes ? mysqli_fetch_assoc($cntRes) : null;
if ($rowCnt && (int)$rowCnt['c'] === 0) {
    $name  = 'Default Admin';
    $email = 'admin@example.com';
    $pass  = password_hash('admin123', PASSWORD_DEFAULT);
    $role  = 'admin';
    $now   = date('Y-m-d H:i:s');
    $stmt  = mysqli_prepare($conn, "INSERT INTO users (name, email, password, role, created_at) VALUES (?,?,?,?,?)");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "sssss", $name, $email, $pass, $role, $now);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $pass  = trim($_POST['password'] ?? '');

    if ($email === '' || $pass === '') {
        $error = 'Please enter both email and password.';
    } else {
        $stmt = mysqli_prepare($conn, "SELECT id, name, email, password, role FROM users WHERE email = ? LIMIT 1");
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "s", $email);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_bind_result($stmt, $uid, $uname, $uemail, $upass, $urole);
            if (mysqli_stmt_fetch($stmt)) {
                if (password_verify($pass, $upass)) {
                    $_SESSION['user_id']   = $uid;
                    $_SESSION['user_name'] = $uname;
                    $_SESSION['user_role'] = $urole;
                    mysqli_stmt_close($stmt);
                    redirect('dashboard.php');
                } else {
                    $error = 'Invalid credentials.';
                }
            } else {
                $error = 'Invalid credentials.';
            }
            mysqli_stmt_close($stmt);
        } else {
            $error = 'DB error. Please try again.';
        }
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Code Editor Login</title>
<style>
body {
    background:#111;
    color:#eee;
    font-family: Arial, sans-serif;
    display:flex;
    align-items:center;
    justify-content:center;
    height:100vh;
    margin:0;
}
.login-box {
    background:#222;
    padding:30px;
    border-radius:8px;
    box-shadow:0 0 10px rgba(0,0,0,0.6);
    width:320px;
}
h2 {
    margin-top:0;
    text-align:center;
}
input[type="email"], input[type="password"] {
    width:100%;
    padding:10px;
    margin:8px 0;
    border-radius:4px;
    border:1px solid #444;
    background:#111;
    color:#fff;
}
button {
    width:100%;
    padding:10px;
    border:none;
    border-radius:4px;
    background:#28a745;
    color:#fff;
    font-size:15px;
    cursor:pointer;
}
button:hover {
    background:#218838;
}
.error {
    color:#ff6b6b;
    margin-bottom:10px;
    font-size:13px;
}
.small-note {
    margin-top:10px;
    font-size:12px;
    color:#aaa;
}
</style>
</head>
<body>
<div class="login-box">
    <h2>Code Editor Login</h2>
    <?php if ($error): ?>
        <div class="error"><?php echo h($error); ?></div>
    <?php endif; ?>
    <form method="post" action="">
        <label>Email</label>
        <input type="email" name="email" required>

        <label>Password</label>
        <input type="password" name="password" required>

        <button type="submit">Login</button>
    </form>
    <div class="small-note">
        First time login?<br>
        Admin: <b>admin@example.com</b> / <b>admin123</b>
    </div>
</div>
</body>
</html>
