<?php
/* ============================================================================
 * File   : project_files.php
 * Purpose: Admin - manage file-level permissions for a project
 * ========================================================================== */
require_once __DIR__ . '/functions.php';
require_login();
if (!is_admin()) {
    die('Access denied');
}

$project_id = isset($_GET['project_id']) ? (int)$_GET['project_id'] : 0;
$file_id    = isset($_GET['file_id']) ? (int)$_GET['file_id'] : 0;

if ($project_id <= 0) {
    die('Invalid project.');
}

// Fetch project
$stmtP = mysqli_prepare($conn, "SELECT * FROM projects WHERE id = ? LIMIT 1");
if (!$stmtP) die('DB error.');
mysqli_stmt_bind_param($stmtP, "i", $project_id);
mysqli_stmt_execute($stmtP);
$resP = mysqli_stmt_get_result($stmtP);
$project = mysqli_fetch_assoc($resP);
mysqli_stmt_close($stmtP);

if (!$project) {
    die('Project not found.');
}

// Handle POST to save permissions for one file
$info = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $file_id > 0) {
    // Delete existing perms for file
    $stmtDel = mysqli_prepare($conn, "DELETE FROM project_permissions WHERE project_id = ? AND file_id = ?");
    if ($stmtDel) {
        mysqli_stmt_bind_param($stmtDel, "ii", $project_id, $file_id);
        mysqli_stmt_execute($stmtDel);
        mysqli_stmt_close($stmtDel);
    }

    if (!empty($_POST['perm']) && is_array($_POST['perm'])) {
        foreach ($_POST['perm'] as $uid => $permVal) {
            $uid = (int)$uid;
            $permVal = trim($permVal);
            if (!in_array($permVal, ['view','edit'], true)) continue;
            $stmtIns = mysqli_prepare($conn, "INSERT INTO project_permissions (project_id, file_id, user_id, permission) VALUES (?,?,?,?)");
            if ($stmtIns) {
                mysqli_stmt_bind_param($stmtIns, "iiis", $project_id, $file_id, $uid, $permVal);
                mysqli_stmt_execute($stmtIns);
                mysqli_stmt_close($stmtIns);
            }
        }
    }
    $info = 'Permissions updated.';
}

// List files (right side)
$files = [];
$resF = mysqli_query($conn, "SELECT id, relative_path FROM project_files WHERE project_id = " . (int)$project_id . " ORDER BY relative_path ASC");
if ($resF) {
    while ($row = mysqli_fetch_assoc($resF)) {
        $files[] = $row;
    }
}

// If one file selected, load its permissions
$selectedFile = null;
$filePerms    = [];
if ($file_id > 0) {
    foreach ($files as $f) {
        if ((int)$f['id'] === $file_id) { $selectedFile = $f; break; }
    }
    if ($selectedFile) {
        $resPerm = mysqli_query($conn, "SELECT user_id, permission FROM project_permissions WHERE project_id = " . (int)$project_id . " AND file_id = " . (int)$file_id);
        if ($resPerm) {
            while ($row = mysqli_fetch_assoc($resPerm)) {
                $filePerms[(int)$row['user_id']] = $row['permission'];
            }
        }
    }
}

// Users list
$users = [];
$resU = mysqli_query($conn, "SELECT id, name, email, role FROM users ORDER BY name ASC");
if ($resU) {
    while ($row = mysqli_fetch_assoc($resU)) {
        $users[] = $row;
    }
}
?>
<?php include __DIR__ . '/header.php'; ?>

<h2>Project Files &amp; Permissions</h2>
<p>
    Project: <b><?php echo h($project['name']); ?></b> (ID: <?php echo (int)$project['id']; ?>)
</p>

<?php if ($info): ?>
    <div style="color:#28a745; font-size:13px; margin-bottom:10px;"><?php echo h($info); ?></div>
<?php endif; ?>

<div style="display:flex; gap:20px;">
    <div style="width:40%; max-height:500px; overflow:auto; border:1px solid #444; padding:10px;">
        <h3 style="margin-top:0; font-size:14px;">Files</h3>
        <ul style="list-style:none; padding-left:0; font-size:13px;">
            <?php if (empty($files)): ?>
                <li>No files indexed.</li>
            <?php else: ?>
                <?php foreach ($files as $f): ?>
                    <li style="margin-bottom:4px;">
                        <a href="project_files.php?project_id=<?php echo (int)$project_id; ?>&file_id=<?php echo (int)$f['id']; ?>">
                            <?php echo h($f['relative_path']); ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>

    <div style="width:60%; border:1px solid #444; padding:10px;">
        <h3 style="margin-top:0; font-size:14px;">Permissions</h3>
        <?php if (!$selectedFile): ?>
            <p>Select a file on the left to manage its permissions.</p>
        <?php else: ?>
            <p>File: <b><?php echo h($selectedFile['relative_path']); ?></b></p>
            <form method="post" action="project_files.php?project_id=<?php echo (int)$project_id; ?>&file_id=<?php echo (int)$file_id; ?>">
                <table class="table">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Permission</th>
                    </tr>
                    <?php if (empty($users)): ?>
                        <tr><td colspan="4">No users found.</td></tr>
                    <?php else: ?>
                        <?php foreach ($users as $u): 
                            $uid = (int)$u['id'];
                            $permValue = $filePerms[$uid] ?? '';
                        ?>
                            <tr>
                                <td><?php echo h($u['name']); ?></td>
                                <td><?php echo h($u['email']); ?></td>
                                <td><?php echo h($u['role']); ?></td>
                                <td>
                                    <select name="perm[<?php echo $uid; ?>]">
                                        <option value="" <?php if ($permValue==='') echo 'selected'; ?>>None</option>
                                        <option value="view" <?php if ($permValue==='view') echo 'selected'; ?>>View only</option>
                                        <option value="edit" <?php if ($permValue==='edit') echo 'selected'; ?>>Edit</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </table>
                <button class="btn btn-success" type="submit">Save Permissions</button>
            </form>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
