<?php
/* ============================================================================
 * File   : save_file.php
 * Purpose: AJAX endpoint to save file content (only if user has edit rights)
 * ========================================================================== */
require_once __DIR__ . '/functions.php';
require_login();
$user = current_user();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'Method not allowed';
    exit;
}

$project_id = isset($_POST['project_id']) ? (int)$_POST['project_id'] : 0;
$file_id    = isset($_POST['file_id']) ? (int)$_POST['file_id'] : 0;
$content    = $_POST['content'] ?? '';

if ($project_id <= 0 || $file_id <= 0) {
    http_response_code(400);
    echo 'Invalid parameters.';
    exit;
}

// Fetch project
$stmtP = mysqli_prepare($conn, "SELECT * FROM projects WHERE id = ? LIMIT 1");
if (!$stmtP) {
    http_response_code(500);
    echo 'DB error.';
    exit;
}
mysqli_stmt_bind_param($stmtP, "i", $project_id);
mysqli_stmt_execute($stmtP);
$resP = mysqli_stmt_get_result($stmtP);
$project = mysqli_fetch_assoc($resP);
mysqli_stmt_close($stmtP);

if (!$project) {
    http_response_code(404);
    echo 'Project not found.';
    exit;
}

// Fetch file
$stmtF = mysqli_prepare($conn, "SELECT * FROM project_files WHERE id = ? AND project_id = ? LIMIT 1");
if (!$stmtF) {
    http_response_code(500);
    echo 'DB error.';
    exit;
}
mysqli_stmt_bind_param($stmtF, "ii", $file_id, $project_id);
mysqli_stmt_execute($stmtF);
$resF = mysqli_stmt_get_result($stmtF);
$file = mysqli_fetch_assoc($resF);
mysqli_stmt_close($stmtF);

if (!$file) {
    http_response_code(404);
    echo 'File not found.';
    exit;
}

// Check permission
$perm = get_file_permission($conn, $project_id, $file_id, $user['id']);
if ($perm !== 'edit') {
    http_response_code(403);
    echo 'No edit permission.';
    exit;
}

$projectRoot = get_project_root_path($project);
$relPath     = clean_relative_path($file['relative_path']);
$fullPath    = $projectRoot . '/' . $relPath;

// Basic security: ensure path is inside projectRoot
$realRoot = realpath($projectRoot);
$realFile = realpath(dirname($fullPath));
if ($realRoot === false || $realFile === false || strpos($realFile, $realRoot) !== 0) {
    http_response_code(400);
    echo 'Invalid file path.';
    exit;
}

// Make backup
if (file_exists($fullPath)) {
    $backupName = $fullPath . '.bak-' . date('YmdHis');
    @copy($fullPath, $backupName);
}

// Save new content
if (file_put_contents($fullPath, $content) === false) {
    http_response_code(500);
    echo 'Failed to write file.';
    exit;
}

echo 'OK';
